/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.ClientStructureWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveScanMessage
implements IMessage {
    private static final String TAG_MILLIS = "millies";
    public static final String TAG_SCHEMATIC = "schematic";
    private CompoundNBT compoundNBT;
    private String fileName;

    public SaveScanMessage() {
    }

    public SaveScanMessage(CompoundNBT CompoundNBT2, String fileName) {
        this.fileName = fileName;
        this.compoundNBT = CompoundNBT2;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        PacketBuffer buffer = new PacketBuffer((ByteBuf)buf);
        try (ByteBufInputStream stream = new ByteBufInputStream((ByteBuf)buffer);){
            CompoundNBT wrapperCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
            this.compoundNBT = wrapperCompound.func_74775_l(TAG_SCHEMATIC);
            this.fileName = wrapperCompound.func_74779_i(TAG_MILLIS);
        }
        catch (RuntimeException e) {
            Log.getLogger().info("Structure too big to be processed", (Throwable)e);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        CompoundNBT wrapperCompound = new CompoundNBT();
        wrapperCompound.func_74778_a(TAG_MILLIS, this.fileName);
        wrapperCompound.func_218657_a(TAG_SCHEMATIC, (INBT)this.compoundNBT);
        PacketBuffer buffer = new PacketBuffer((ByteBuf)buf);
        try (ByteBufOutputStream stream = new ByteBufOutputStream((ByteBuf)buffer);){
            CompressedStreamTools.func_74799_a((CompoundNBT)wrapperCompound, (OutputStream)stream);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (this.compoundNBT != null) {
            ClientStructureWrapper.handleSaveScanMessage(this.compoundNBT, this.fileName);
        }
    }
}

