/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.optifine;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;

public class OptifineCompat {
    private static OptifineCompat ourInstance = new OptifineCompat();
    private Method isShadersEnabledMethod;
    private Method calcNormalForLayerMethod;
    private Method setupArrayPointersVboMethod;
    private Method preRenderChunkLayerMethod;
    private Method postRenderChunkLayerMethod;
    private Method endTerrainMethod;
    private Method beginEntitiesMethod;
    private Method nextEntityMethod;
    private Method endEntitiesMethod;
    private Method beginBlockEntitiesMethod;
    private Method nextBlockEntityMethod;
    private Method endBlockEntitiesMethod;
    private Method preWaterMethod;
    private Method beginWaterMethod;
    private Method endWaterMethod;
    private boolean currentShadowPassFieldValue = false;
    private Field isShadowPassField;
    private boolean currentIsRenderingWorldFieldValue = false;
    private Field isRenderingWorldField;
    private boolean enableOptifine = false;

    public static OptifineCompat getInstance() {
        return ourInstance;
    }

    private OptifineCompat() {
    }

    public void intialize() {
        try {
            this.setupReflectedMethodReferences();
            if (!((Boolean)Structurize.getConfig().getClient().useOptifineCompatPatch.get()).booleanValue()) {
                Log.getLogger().warn("Optifine found. COMPAT PATCH NOT ENABLED BECAUSE OF CONFIG SETTINGS. RENDERING CRASHES AROUND STRUCTURIZE SHOULD NOT BE CONSIDERED VALID.");
                this.enableOptifine = false;
                return;
            }
            Log.getLogger().info("Optifine found. Enabling compat.");
            this.enableOptifine = true;
        }
        catch (ClassNotFoundException e) {
            Log.getLogger().info("Optifine not found. Disabling compat.");
            this.enableOptifine = false;
        }
        catch (NoSuchMethodException e) {
            Log.getLogger().error("Optifine found. But could not access related methods.", (Throwable)e);
            this.enableOptifine = false;
        }
        catch (NoSuchFieldException e) {
            Log.getLogger().error("Optifine found. But could not access related fields", (Throwable)e);
            this.enableOptifine = false;
        }
    }

    private void setupReflectedMethodReferences() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        Class<?> configClass = Class.forName("net.optifine.Config");
        Class<?> shaderRenderClass = Class.forName("net.optifine.shaders.ShadersRender");
        Class<?> sVertexBuilderClass = Class.forName("net.optifine.shaders.SVertexBuilder");
        Class<?> shadersClass = Class.forName("net.optifine.shaders.Shaders");
        this.isShadersEnabledMethod = configClass.getMethod("isShaders", new Class[0]);
        this.isShadersEnabledMethod.setAccessible(true);
        this.isShadowPassField = shadersClass.getField("isShadowPass");
        this.isShadowPassField.setAccessible(true);
        this.isRenderingWorldField = shadersClass.getField("isRenderingWorld");
        this.isRenderingWorldField.setAccessible(true);
        this.calcNormalForLayerMethod = sVertexBuilderClass.getMethod("calcNormalChunkLayer", BufferBuilder.class);
        this.calcNormalForLayerMethod.setAccessible(true);
        this.preRenderChunkLayerMethod = shaderRenderClass.getMethod("preRenderChunkLayer", RenderType.class);
        this.preRenderChunkLayerMethod.setAccessible(true);
        this.setupArrayPointersVboMethod = shaderRenderClass.getMethod("setupArrayPointersVbo", new Class[0]);
        this.setupArrayPointersVboMethod.setAccessible(true);
        this.postRenderChunkLayerMethod = shaderRenderClass.getMethod("postRenderChunkLayer", RenderType.class);
        this.postRenderChunkLayerMethod.setAccessible(true);
        this.endTerrainMethod = shaderRenderClass.getMethod("endTerrain", new Class[0]);
        this.endTerrainMethod.setAccessible(true);
        this.beginEntitiesMethod = shadersClass.getMethod("beginEntities", new Class[0]);
        this.beginEntitiesMethod.setAccessible(true);
        this.nextEntityMethod = shadersClass.getMethod("nextEntity", Entity.class);
        this.nextEntityMethod.setAccessible(true);
        this.endEntitiesMethod = shadersClass.getMethod("endEntities", new Class[0]);
        this.endEntitiesMethod.setAccessible(true);
        this.beginBlockEntitiesMethod = shadersClass.getMethod("beginBlockEntities", new Class[0]);
        this.beginBlockEntitiesMethod.setAccessible(true);
        this.nextBlockEntityMethod = shadersClass.getMethod("nextBlockEntity", TileEntity.class);
        this.nextBlockEntityMethod.setAccessible(true);
        this.endBlockEntitiesMethod = shadersClass.getMethod("endBlockEntities", new Class[0]);
        this.endBlockEntitiesMethod.setAccessible(true);
        this.preWaterMethod = shadersClass.getMethod("preWater", new Class[0]);
        this.preWaterMethod.setAccessible(true);
        this.beginWaterMethod = shadersClass.getMethod("beginWater", new Class[0]);
        this.beginWaterMethod.setAccessible(true);
        this.endWaterMethod = shadersClass.getMethod("endWater", new Class[0]);
        this.endWaterMethod.setAccessible(true);
    }

    public void beforeBuilderUpload(BufferBuilder bufferBuilder) {
        this.tryRun(() -> this.calcNormalForLayerMethod.invoke(null, bufferBuilder));
    }

    public void preBlueprintDraw() {
        this.tryRunIfShadersEnabled(() -> {
            this.currentShadowPassFieldValue = this.isShadowPassField.getBoolean(null);
            this.isShadowPassField.set(null, false);
            this.currentIsRenderingWorldFieldValue = this.isRenderingWorldField.getBoolean(null);
            this.isRenderingWorldField.set(null, true);
        });
    }

    public void preLayerDraw(RenderType layer) {
        this.tryRunIfShadersEnabled(() -> this.preRenderChunkLayerMethod.invoke(null, layer));
    }

    public void setupArrayPointers() {
        this.tryRunIfShadersEnabled(() -> this.setupArrayPointersVboMethod.invoke(null, new Object[0]));
    }

    public void postLayerDraw(RenderType layer) {
        this.tryRunIfShadersEnabled(() -> this.postRenderChunkLayerMethod.invoke(null, layer));
    }

    public void endTerrain() {
        this.tryRunIfShadersEnabled(() -> this.endTerrainMethod.invoke(null, new Object[0]));
    }

    public void beginEntities() {
        this.tryRunIfShadersEnabled(() -> this.beginEntitiesMethod.invoke(null, new Object[0]));
    }

    public void preRenderEntity(Entity entity) {
        this.tryRunIfShadersEnabled(() -> this.nextEntityMethod.invoke(null, entity));
    }

    public void endEntitiesBeginBlockEntities() {
        this.tryRunIfShadersEnabled(() -> {
            this.endEntitiesMethod.invoke(null, new Object[0]);
            this.beginBlockEntitiesMethod.invoke(null, new Object[0]);
        });
    }

    public void preRenderBlockEntity(TileEntity blockEntity) {
        this.tryRunIfShadersEnabled(() -> this.nextBlockEntityMethod.invoke(null, blockEntity));
    }

    public void endBlockEntities() {
        this.tryRunIfShadersEnabled(() -> this.endBlockEntitiesMethod.invoke(null, new Object[0]));
    }

    public void preWaterBeginWater() {
        this.tryRunIfShadersEnabled(() -> {
            this.preWaterMethod.invoke(null, new Object[0]);
            this.beginWaterMethod.invoke(null, new Object[0]);
        });
    }

    public void endWater() {
        this.tryRunIfShadersEnabled(() -> this.endWaterMethod.invoke(null, new Object[0]));
    }

    public void postBlueprintDraw() {
        this.tryRunIfShadersEnabled(() -> {
            this.isShadowPassField.set(null, this.currentShadowPassFieldValue);
            this.isRenderingWorldField.set(null, this.currentIsRenderingWorldFieldValue);
        });
    }

    public boolean isShaders() {
        boolean isShaders = this.tryRun(() -> (Boolean)this.isShadersEnabledMethod.invoke(null, new Object[0]), false);
        return isShaders;
    }

    private void tryRunIfShadersEnabled(ReflectionRunnable code) {
        this.tryRun(() -> {
            if (((Boolean)this.isShadersEnabledMethod.invoke(null, new Object[0])).booleanValue()) {
                code.run();
            }
        });
    }

    private void tryRun(ReflectionRunnable code) {
        if (!this.enableOptifine) {
            return;
        }
        try {
            code.run();
        }
        catch (ReflectiveOperationException e) {
            Log.getLogger().error("Failed to access Optifine related rendering things.", (Throwable)e);
            Log.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
    }

    private <T> T tryRun(ReflectionSupplier<T> code, T defaultValue) {
        if (!this.enableOptifine) {
            return defaultValue;
        }
        try {
            return code.run();
        }
        catch (ReflectiveOperationException e) {
            Log.getLogger().error("Failed to access Optifine related rendering things.", (Throwable)e);
            Log.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
            return defaultValue;
        }
    }

    @FunctionalInterface
    private static interface ReflectionSupplier<T> {
        public T run() throws ReflectiveOperationException;
    }

    @FunctionalInterface
    private static interface ReflectionRunnable {
        public void run() throws ReflectiveOperationException;
    }
}

