/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import com.yungnickyoung.minecraft.bettercaves.world.feature.CarverFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class BCFeature {
    private static final DeferredRegister<Feature<?>> FEATURES = new DeferredRegister(ForgeRegistries.FEATURES, "bettercaves");
    public static final CarverFeature BETTERCAVES_CARVER = new CarverFeature(NoFeatureConfig::func_214639_a);
    public static final RegistryObject<Feature<?>> BETTERCAVES_CARVER_FEATURE = FEATURES.register("bettercave", () -> BETTERCAVES_CARVER);

    public static void init() {
        FEATURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BCFeature::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BCFeature::configChanged);
        MinecraftForge.EVENT_BUS.addListener(BCFeature::worldUnload);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(BCFeature::lateSetup);
    }

    private static void lateSetup() {
        BetterCaves.LOGGER.info("Replacing biome carvers with Better Caves carvers...");
        Set biomesList = ForgeRegistries.BIOMES.getEntries();
        for (Map.Entry e : biomesList) {
            Biome biome = (Biome)e.getValue();
            List defaultAirCarvers = biome.func_203603_a(GenerationStage.Carving.AIR);
            List defaultLiquidCarvers = biome.func_203603_a(GenerationStage.Carving.LIQUID);
            BetterCaves.defaultBiomeAirCarvers.put(biome.getClass(), defaultAirCarvers);
            BetterCaves.defaultBiomeLiquidCarvers.put(biome.getClass(), defaultLiquidCarvers);
            biome.field_201871_ag = Maps.newHashMap();
            ((List)biome.field_201872_ah.get(GenerationStage.Decoration.RAW_GENERATION)).add(0, new ConfiguredFeature((Feature)new CarverFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)new NoFeatureConfig()));
        }
    }

    public static void worldUnload(WorldEvent.Unload event) {
        BetterCaves.LOGGER.debug(String.format("Unloading world: %s (ID %s)", event.getWorld().func_72905_C(), event.getWorld().func_201675_m().func_186058_p().func_186068_a()));
        try {
            String key = Objects.requireNonNull(DimensionType.func_212678_a((DimensionType)event.getWorld().func_201675_m().func_186058_p())).toString();
            BetterCaves.activeCarversMap.remove(key);
        }
        catch (NullPointerException e) {
            BetterCaves.LOGGER.error("ERROR: Unable to unload carver for dimension!");
        }
    }

    public static void configChanged(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == Configuration.SPEC) {
            String rawStringofList = (String)Configuration.whitelistedDimensions.get();
            int strLen = rawStringofList.length();
            if (strLen < 2 || rawStringofList.charAt(0) != '[' || rawStringofList.charAt(strLen - 1) != ']') {
                BetterCaves.LOGGER.error("INVALID VALUE FOR SETTING 'Whitelisted Dimension IDs'. Using empty list instead...");
                BetterCaves.whitelistedDimensions = Lists.newArrayList();
                return;
            }
            ArrayList inputListOfDimensionStrings = Lists.newArrayList((Object[])rawStringofList.substring(1, strLen - 1).split(",\\s*"));
            Set existingDimensionNames = Stream.concat(Registry.field_212622_k.func_148742_b().stream(), ForgeRegistries.MOD_DIMENSIONS.getKeys().stream()).map(ResourceLocation::toString).collect(Collectors.toSet());
            ArrayList whitelistedDimensions = Lists.newArrayList();
            for (String dimensionName : inputListOfDimensionStrings) {
                if (existingDimensionNames.contains(dimensionName)) {
                    whitelistedDimensions.add(dimensionName);
                    continue;
                }
                BetterCaves.LOGGER.error(String.format("INVALID DIMENSION ENTRY: %s - Skipping...", dimensionName));
            }
            BetterCaves.whitelistedDimensions = whitelistedDimensions;
        }
    }
}

