/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.vanilla;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.util.ColPos;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ICarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.vanilla.VanillaCaveCarverBuilder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class VanillaCaveCarver
implements ICarver {
    private int bottomY;
    private int topY;
    private int density;
    private int priority;
    private int liquidAltitude;
    private BlockState debugBlock;
    private boolean isDebugVisualizerEnabled;
    private boolean isReplaceGravelEnabled;
    private boolean isFloodedUndergroundEnabled;
    private Random rand = new Random();
    private IWorld world;
    private int range = 8;

    public VanillaCaveCarver(VanillaCaveCarverBuilder builder) {
        this.bottomY = builder.getBottomY();
        this.topY = builder.getTopY();
        this.density = builder.getDensity();
        this.priority = builder.getPriority();
        this.liquidAltitude = builder.getLiquidAltitude();
        this.debugBlock = builder.getDebugBlock();
        this.isDebugVisualizerEnabled = builder.isDebugVisualizerEnabled();
        this.isReplaceGravelEnabled = builder.isReplaceGravel();
        this.isFloodedUndergroundEnabled = builder.isFloodedUndergroundEnabled();
        if (this.bottomY > this.topY) {
            BetterCaves.LOGGER.warn("Warning: Min altitude for vanilla caves should not be greater than max altitude.");
            BetterCaves.LOGGER.warn("Using default values...");
            this.bottomY = 40;
            this.topY = 128;
        }
    }

    public void generate(IWorld worldIn, int chunkX, int chunkZ, IChunk primer, boolean addRooms, BlockState[][] liquidBlocks, Map<Long, Biome> biomeMap, boolean[][] validPositions, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        int chunkRadius = this.range;
        this.world = worldIn;
        this.rand.setSeed(worldIn.func_72905_C());
        long j = this.rand.nextLong();
        long k = this.rand.nextLong();
        for (int currChunkX = chunkX - chunkRadius; currChunkX <= chunkX + chunkRadius; ++currChunkX) {
            for (int currChunkZ = chunkZ - chunkRadius; currChunkZ <= chunkZ + chunkRadius; ++currChunkZ) {
                long j1 = (long)currChunkX * j;
                long k1 = (long)currChunkZ * k;
                this.rand.setSeed(j1 ^ k1 ^ worldIn.func_72905_C());
                this.recursiveGenerate(worldIn, currChunkX, currChunkZ, chunkX, chunkZ, primer, addRooms, liquidBlocks, biomeMap, validPositions, airCarvingMask, liquidCarvingMask);
            }
        }
    }

    public void generate(IWorld worldIn, int x, int z, IChunk primer, boolean addRooms, BlockState[][] liquidBlocks, Map<Long, Biome> biomeMap, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        boolean[][] validPositions;
        for (boolean[] row : validPositions = new boolean[16][16]) {
            Arrays.fill(row, true);
        }
        this.generate(worldIn, x, z, primer, addRooms, liquidBlocks, biomeMap, validPositions, airCarvingMask, liquidCarvingMask);
    }

    private void recursiveGenerate(IWorld worldIn, int chunkX, int chunkZ, int originalChunkX, int originalChunkZ, @Nonnull IChunk primer, boolean addRooms, BlockState[][] liquidBlocks, Map<Long, Biome> biomeMap, boolean[][] validPositions, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        int numAttempts = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(15) + 1) + 1);
        if (this.rand.nextInt(100) > this.density) {
            numAttempts = 0;
        }
        for (int i = 0; i < numAttempts; ++i) {
            double caveStartX = chunkX * 16 + this.rand.nextInt(16);
            double caveStartY = this.rand.nextInt(this.topY - this.bottomY) + this.bottomY;
            double caveStartZ = chunkZ * 16 + this.rand.nextInt(16);
            int numAddTunnelCalls = 1;
            if (addRooms && this.rand.nextInt(4) == 0) {
                this.addRoom(worldIn, this.rand.nextLong(), originalChunkX, originalChunkZ, primer, caveStartX, caveStartY, caveStartZ, liquidBlocks, biomeMap, validPositions, airCarvingMask, liquidCarvingMask);
                numAddTunnelCalls += this.rand.nextInt(4);
            }
            for (int j = 0; j < numAddTunnelCalls; ++j) {
                float yaw = this.rand.nextFloat() * ((float)Math.PI * 2);
                float pitch = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float width = this.rand.nextFloat() * 2.0f + this.rand.nextFloat();
                if (addRooms && this.rand.nextInt(10) == 0) {
                    width *= this.rand.nextFloat() * this.rand.nextFloat() * 3.0f + 1.0f;
                }
                this.addTunnel(worldIn, this.rand.nextLong(), originalChunkX, originalChunkZ, primer, caveStartX, caveStartY, caveStartZ, width, yaw, pitch, 0, 0, 1.0, liquidBlocks, biomeMap, validPositions, airCarvingMask, liquidCarvingMask);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getTopY() {
        return this.topY;
    }

    private void addRoom(IWorld worldIn, long seed, int originChunkX, int originChunkZ, IChunk primer, double caveStartX, double caveStartY, double caveStartZ, BlockState[][] liquidBlocks, Map<Long, Biome> biomeMap, boolean[][] validPositions, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        this.addTunnel(worldIn, seed, originChunkX, originChunkZ, primer, caveStartX, caveStartY, caveStartZ, 1.0f + this.rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5, liquidBlocks, biomeMap, validPositions, airCarvingMask, liquidCarvingMask);
    }

    protected void addTunnel(IWorld worldIn, long seed, int originChunkX, int originChunkZ, IChunk chunk, double caveStartX, double caveStartY, double caveStartZ, float width, float yaw, float pitch, int startCounter, int endCounter, double heightModifier, BlockState[][] liquidBlocks, Map<Long, Biome> biomeMap, boolean[][] validPositions, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        Random random = new Random(seed);
        double originBlockX = originChunkX * 16 + 8;
        double originBlockZ = originChunkZ * 16 + 8;
        float yawModifier = 0.0f;
        float pitchModifier = 0.0f;
        if (endCounter <= 0) {
            int i = this.range * 16 - 16;
            endCounter = i - random.nextInt(i / 4);
        }
        boolean comesFromRoom = false;
        if (startCounter == -1) {
            startCounter = endCounter / 2;
            comesFromRoom = true;
        }
        int randomCounterValue = random.nextInt(endCounter / 2) + endCounter / 4;
        while (startCounter < endCounter) {
            boolean flag;
            double xzOffset = 1.5 + (double)(MathHelper.func_76126_a((float)((float)startCounter * (float)Math.PI / (float)endCounter)) * width);
            double yOffset = xzOffset * heightModifier;
            float pitchXZ = MathHelper.func_76134_b((float)pitch);
            float pitchY = MathHelper.func_76126_a((float)pitch);
            caveStartX += (double)(MathHelper.func_76134_b((float)yaw) * pitchXZ);
            caveStartY += (double)pitchY;
            caveStartZ += (double)(MathHelper.func_76126_a((float)yaw) * pitchXZ);
            boolean bl = flag = random.nextInt(6) == 0;
            pitch = flag ? (pitch *= 0.92f) : (pitch *= 0.7f);
            pitch += pitchModifier * 0.1f;
            yaw += yawModifier * 0.1f;
            pitchModifier *= 0.9f;
            yawModifier *= 0.75f;
            pitchModifier += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            yawModifier += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!comesFromRoom && startCounter == randomCounterValue && width > 1.0f && endCounter > 0) {
                this.addTunnel(worldIn, random.nextLong(), originChunkX, originChunkZ, chunk, caveStartX, caveStartY, caveStartZ, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, startCounter, endCounter, 1.0, liquidBlocks, biomeMap, validPositions, airCarvingMask, liquidCarvingMask);
                this.addTunnel(worldIn, random.nextLong(), originChunkX, originChunkZ, chunk, caveStartX, caveStartY, caveStartZ, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, startCounter, endCounter, 1.0, liquidBlocks, biomeMap, validPositions, airCarvingMask, liquidCarvingMask);
                return;
            }
            if (comesFromRoom || random.nextInt(4) != 0) {
                double caveStartXOffsetFromCenter = caveStartX - originBlockX;
                double caveStartZOffsetFromCenter = caveStartZ - originBlockZ;
                double distanceToEnd = endCounter - startCounter;
                double d7 = width + 2.0f + 16.0f;
                if (caveStartXOffsetFromCenter * caveStartXOffsetFromCenter + caveStartZOffsetFromCenter * caveStartZOffsetFromCenter - distanceToEnd * distanceToEnd > d7 * d7) {
                    return;
                }
                if (caveStartX >= originBlockX - 16.0 - xzOffset * 2.0 && caveStartZ >= originBlockZ - 16.0 - xzOffset * 2.0 && caveStartX <= originBlockX + 16.0 + xzOffset * 2.0 && caveStartZ <= originBlockZ + 16.0 + xzOffset * 2.0) {
                    int minX = MathHelper.func_76128_c((double)(caveStartX - xzOffset)) - originChunkX * 16 - 1;
                    int minY = MathHelper.func_76128_c((double)(caveStartY - yOffset)) - 1;
                    int minZ = MathHelper.func_76128_c((double)(caveStartZ - xzOffset)) - originChunkZ * 16 - 1;
                    int maxX = MathHelper.func_76128_c((double)(caveStartX + xzOffset)) - originChunkX * 16 + 1;
                    int maxY = MathHelper.func_76128_c((double)(caveStartY + yOffset)) + 1;
                    int maxZ = MathHelper.func_76128_c((double)(caveStartZ + xzOffset)) - originChunkZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (minY < 1) {
                        minY = 1;
                    }
                    if (maxY > 248) {
                        maxY = 248;
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    for (int currX = minX; currX < maxX; ++currX) {
                        double xAxisDist = ((double)(currX + originChunkX * 16) + 0.5 - caveStartX) / xzOffset;
                        for (int currZ = minZ; currZ < maxZ; ++currZ) {
                            double zAxisDist = ((double)(currZ + originChunkZ * 16) + 0.5 - caveStartZ) / xzOffset;
                            if (!validPositions[currX][currZ] || !(xAxisDist * xAxisDist + zAxisDist * zAxisDist < 1.0)) continue;
                            for (int currY = maxY; currY > minY; --currY) {
                                double yAxisDist = ((double)(currY - 1) + 0.5 - caveStartY) / yOffset;
                                if (yAxisDist > -0.7 && xAxisDist * xAxisDist + yAxisDist * yAxisDist + zAxisDist * zAxisDist < 1.0) {
                                    BlockState liquidBlock = liquidBlocks[BetterCavesUtils.getLocal(currX)][BetterCavesUtils.getLocal(currZ)];
                                    if (this.isDebugVisualizerEnabled) {
                                        CarverUtils.debugCarveBlock(chunk, currX, currY, currZ, this.debugBlock, true);
                                        continue;
                                    }
                                    this.digBlock(worldIn, chunk, originChunkX, originChunkZ, currX, currY, currZ, liquidBlock, biomeMap, airCarvingMask, liquidCarvingMask);
                                    continue;
                                }
                                if (!this.isDebugVisualizerEnabled) continue;
                                CarverUtils.debugCarveBlock(chunk, currX, currY, currZ, this.debugBlock, false);
                            }
                        }
                    }
                    if (comesFromRoom) break;
                }
            }
            ++startCounter;
        }
    }

    private void digBlock(IWorld worldIn, IChunk chunkIn, int chunkX, int chunkZ, int localX, int y, int localZ, BlockState liquidBlockState, Map<Long, Biome> biomeMap, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        boolean flooded;
        int bitIndex = localX | localZ << 4 | y << 8;
        if (airCarvingMask.get(bitIndex) || liquidCarvingMask.get(bitIndex)) {
            return;
        }
        BlockPos blockPos = new BlockPos(chunkX * 16 + localX, y, chunkZ * 16 + localZ);
        ColPos.Mutable mutableColPos = new ColPos.Mutable(blockPos);
        boolean bl = flooded = this.isFloodedUndergroundEnabled && !this.isDebugVisualizerEnabled && biomeMap.get(mutableColPos.toLong()).func_201856_r() == Biome.Category.OCEAN;
        if (flooded) {
            if (y >= worldIn.func_181545_F()) {
                return;
            }
            if (BetterCavesUtils.isPosInWorld(mutableColPos.setPos(blockPos).move(Direction.EAST), this.world) && biomeMap.get(mutableColPos.setPos(blockPos).move(Direction.EAST).toLong()).func_201856_r() != Biome.Category.OCEAN || BetterCavesUtils.isPosInWorld(mutableColPos.setPos(blockPos).move(Direction.WEST), this.world) && biomeMap.get(mutableColPos.setPos(blockPos).move(Direction.WEST).toLong()).func_201856_r() != Biome.Category.OCEAN || BetterCavesUtils.isPosInWorld(mutableColPos.setPos(blockPos).move(Direction.NORTH), this.world) && biomeMap.get(mutableColPos.setPos(blockPos).move(Direction.NORTH).toLong()).func_201856_r() != Biome.Category.OCEAN || BetterCavesUtils.isPosInWorld(mutableColPos.setPos(blockPos).move(Direction.SOUTH), this.world) && biomeMap.get(mutableColPos.setPos(blockPos).move(Direction.SOUTH).toLong()).func_201856_r() != Biome.Category.OCEAN) {
                return;
            }
        }
        if (flooded) {
            CarverUtils.carveFloodedBlock(chunkIn, this.rand, new BlockPos.Mutable(blockPos), liquidBlockState, this.liquidAltitude, liquidCarvingMask);
        } else {
            CarverUtils.carveBlock(chunkIn, blockPos, liquidBlockState, this.liquidAltitude, this.isReplaceGravelEnabled, airCarvingMask);
        }
    }

    public void setWorld(IWorld worldIn) {
        this.world = worldIn;
    }
}

