/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.ModelProvider;
import org.apache.commons.lang3.StringUtils;

public abstract class ItemModelProvider
extends ModelProvider<ItemModelBuilder> {
    protected static final ModelFile.UncheckedModelFile GENERATED = new ModelFile.UncheckedModelFile("item/generated");
    protected static final ModelFile.UncheckedModelFile HANDHELD = new ModelFile.UncheckedModelFile("item/handheld");

    public ItemModelProvider(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, "item", WrappedItemModelBuilder::new, existingFileHelper);
    }

    protected String name(IItemProvider item) {
        return item.func_199767_j().getRegistryName().func_110623_a();
    }

    protected ResourceLocation itemTexture(IItemProvider item) {
        return this.itemTexture(item, "");
    }

    protected ResourceLocation itemTexture(Supplier<? extends Item> item) {
        return this.itemTexture(item, "");
    }

    protected ResourceLocation itemTexture(IItemProvider item, String folder) {
        String f = "";
        if (!StringUtils.isEmpty((CharSequence)folder)) {
            f = StringUtils.appendIfMissing((String)folder, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return this.modLoc("item/" + f + this.name(item));
    }

    protected ResourceLocation itemTexture(Supplier<? extends Item> item, String folder) {
        return this.itemTexture((IItemProvider)item.get(), folder);
    }

    protected ResourceLocation blockTexture(Block block) {
        return this.itemTexture((IItemProvider)block, "");
    }

    protected ResourceLocation blockTexture(Supplier<? extends Block> block) {
        return this.blockTexture(block, "");
    }

    protected ResourceLocation blockTexture(Block block, String folder) {
        String f = "";
        if (!StringUtils.isEmpty((CharSequence)folder)) {
            f = StringUtils.appendIfMissing((String)folder, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return this.modLoc("block/" + f + this.name((IItemProvider)block));
    }

    protected ResourceLocation blockTexture(Supplier<? extends Block> block, String folder) {
        return this.blockTexture(block.get(), folder);
    }

    protected ItemModelBuilder getBuilder(IItemProvider item) {
        return (ItemModelBuilder)this.getBuilder(this.name(item));
    }

    protected ItemModelBuilder getBuilder(Supplier<? extends Item> item) {
        return (ItemModelBuilder)this.getBuilder(this.name((IItemProvider)item.get()));
    }

    protected SimpleItemModelBuilder getSimple(IItemProvider item) {
        WrappedItemModelBuilder builder = (WrappedItemModelBuilder)this.getBuilder(item);
        if (builder.simpleBuilder == null) {
            builder.simpleBuilder = new SimpleItemModelBuilder(builder, item.func_199767_j());
        }
        return builder.simpleBuilder;
    }

    protected SimpleItemModelBuilder getSimple(Supplier<? extends Item> item) {
        return this.getSimple((IItemProvider)item.get());
    }

    protected SimpleItemModelBuilder generated(IItemProvider item) {
        return this.getSimple(item).parent((ModelFile)GENERATED);
    }

    protected SimpleItemModelBuilder generated(Supplier<? extends Item> item) {
        return this.generated((IItemProvider)item.get());
    }

    protected SimpleItemModelBuilder handheld(IItemProvider item) {
        return this.getSimple(item).parent((ModelFile)HANDHELD);
    }

    protected SimpleItemModelBuilder handheld(Supplier<? extends Item> item) {
        return this.handheld((IItemProvider)item.get());
    }

    protected void simpleItemBlock(Block block) {
        this.getSimple((IItemProvider)block).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((IItemProvider)block)))).texture(null);
    }

    private static class WrappedItemModelBuilder
    extends ItemModelBuilder {
        private SimpleItemModelBuilder simpleBuilder;

        public WrappedItemModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
            super(outputLocation, existingFileHelper);
        }

        public JsonObject toJson() {
            if (this.simpleBuilder != null) {
                this.simpleBuilder.build();
            }
            return super.toJson();
        }
    }

    public class SimpleItemModelBuilder {
        private final ItemModelBuilder builder;
        private final Item item;
        private ModelFile parent;
        private ResourceLocation texture;
        private boolean noTexture = false;
        private String folder = "";
        private boolean built = false;

        protected SimpleItemModelBuilder(ItemModelBuilder builder, Item item) {
            this.builder = builder;
            this.item = item;
        }

        public SimpleItemModelBuilder parent(ModelFile parent) {
            this.parent = Objects.requireNonNull(parent);
            return this;
        }

        public SimpleItemModelBuilder texture(ResourceLocation texture) {
            this.texture = texture;
            boolean bl = this.noTexture = texture == null;
            if (!StringUtils.isEmpty((CharSequence)this.folder)) {
                throw new IllegalArgumentException("Adding texture would ignore existing folder.");
            }
            return this;
        }

        public SimpleItemModelBuilder folder(String folder) {
            this.folder = Objects.requireNonNull(folder);
            if (this.texture != null && !this.noTexture) {
                throw new IllegalArgumentException("Folder would be ignored, remove parameter");
            }
            return this;
        }

        private void build() {
            if (!this.built) {
                ResourceLocation texture = this.texture;
                if (texture == null && !this.noTexture) {
                    texture = ItemModelProvider.this.itemTexture((IItemProvider)this.item, this.folder);
                }
                this.builder.parent(this.parent);
                if (texture != null) {
                    this.builder.texture("layer0", texture);
                }
                this.built = true;
            }
        }
    }
}

