/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.MatchTool;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LootTableProvider
implements IDataProvider {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private final Map<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();

    protected LootTableProvider(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    public void func_200398_a(DirectoryCache cache) {
        this.tables.clear();
        Path out = this.dataGenerator.func_200391_b();
        this.registerTables();
        ValidationTracker validator = new ValidationTracker(LootParameterSets.field_216266_g, e -> null, this.tables::get);
        this.tables.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validator, (ResourceLocation)name, (LootTable)table));
        Multimap problems = validator.func_227527_a_();
        if (!problems.isEmpty()) {
            logger.warn("Problems detected for LootTableGenerator: " + this.func_200397_b());
            problems.forEach((name, table) -> logger.warn("Found validation problem in {}: {}", name, table));
            throw new IllegalStateException("Failed to validate loot tables, see logs.");
        }
        this.tables.forEach((name, table) -> {
            Path output = LootTableProvider.getPath(out, name);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)output);
            }
            catch (IOException e) {
                logger.error("Couldn't save loot table {}", (Object)output, (Object)e);
            }
        });
    }

    protected abstract void registerTables();

    protected void registerTable(ResourceLocation name, LootTable table) {
        if (this.tables.put(name, table) != null) {
            throw new IllegalArgumentException("Duplicate loot table registered: " + name);
        }
    }

    private static Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.func_110624_b() + "/loot_tables/" + id.func_110623_a() + ".json");
    }

    public static abstract class BlockLootProvider
    extends LootTableProvider {
        protected static final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
        protected static final ILootCondition.IBuilder NO_SILK_TOUCH = SILK_TOUCH.func_216298_a();

        protected BlockLootProvider(DataGenerator dataGenerator) {
            super(dataGenerator);
        }

        protected LootPool.Builder singleItem(IItemProvider item) {
            return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item));
        }

        protected LootPool.Builder singleItemOr(IItemProvider failDrop, ILootCondition.IBuilder condition, LootEntry.Builder<?> passDrop) {
            return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)failDrop).func_212840_b_(condition)).func_216080_a(passDrop));
        }

        protected LootPool.Builder singleItemOrSilk(IItemProvider silk, LootEntry.Builder<?> drop) {
            return this.singleItemOr(silk, SILK_TOUCH, drop);
        }

        protected LootPool.Builder singleItemOrSilk(IItemProvider silk, IItemProvider drop) {
            return this.singleItemOrSilk(silk, (LootEntry.Builder<?>)ItemLootEntry.func_216168_a((IItemProvider)drop));
        }

        protected LootPool.Builder valueRange(IItemProvider item, int min, int max) {
            return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)min, (float)max))));
        }

        protected LootPool.Builder valueRangeOrSilk(IItemProvider silk, IItemProvider drop, int min, int max) {
            return this.singleItemOr(silk, SILK_TOUCH, (LootEntry.Builder<?>)ItemLootEntry.func_216168_a((IItemProvider)drop).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)min, (float)max))));
        }

        protected LootPool.Builder valueRangeOrSilkWithFortune(IItemProvider silk, IItemProvider drop, int min, int max) {
            return this.singleItemOr(silk, SILK_TOUCH, (LootEntry.Builder<?>)ItemLootEntry.func_216168_a((IItemProvider)drop).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange((float)min, (float)max))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t)));
        }

        protected void register(Block block, LootPool.Builder ... pools) {
            LootTable.Builder builder = LootTable.func_216119_b();
            for (LootPool.Builder pool : pools) {
                builder.func_216040_a(pool);
            }
            this.register(block, builder);
        }

        protected void register(Block block, LootTable.Builder builder) {
            this.register(block.getRegistryName(), builder);
        }

        protected void register(ResourceLocation name, LootTable.Builder builder) {
            this.registerTable(new ResourceLocation(name.func_110624_b(), "blocks/" + name.func_110623_a()), builder.func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
    }
}

