/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapelessRecipeBuilder
extends AbstractItemStackRecipeBuilder<ShapelessRecipeBuilder> {
    private static final Logger logger = LogManager.getLogger();
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    protected ShapelessRecipeBuilder(IRecipeSerializer<?> serializer, ResourceLocation id, ItemStack result) {
        super(serializer, id, result);
    }

    public static ShapelessRecipeBuilder builder(IItemProvider result) {
        return ShapelessRecipeBuilder.builder(result, 1);
    }

    public static ShapelessRecipeBuilder builder(IItemProvider result, int count) {
        return ShapelessRecipeBuilder.builder(new ItemStack(result, count));
    }

    public static ShapelessRecipeBuilder builder(IItemProvider result, int count, ResourceLocation id) {
        return ShapelessRecipeBuilder.builder(new ItemStack(result, count), id);
    }

    public static ShapelessRecipeBuilder builder(ItemStack result) {
        return ShapelessRecipeBuilder.builder(result, result.func_77973_b().getRegistryName());
    }

    public static ShapelessRecipeBuilder builder(ItemStack result, ResourceLocation id) {
        return new ShapelessRecipeBuilder(IRecipeSerializer.field_222158_b, id, result);
    }

    public ShapelessRecipeBuilder addIngredient(Tag<Item> tag) {
        return this.addIngredient(tag, 1);
    }

    public ShapelessRecipeBuilder addIngredient(Tag<Item> tag, int quantity) {
        this.addAutoCriteria(tag);
        Ingredient ingredient = Ingredient.func_199805_a(tag);
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder addIngredient(IItemProvider item) {
        return this.addIngredient(item, 1);
    }

    public ShapelessRecipeBuilder addIngredient(IItemProvider item, int quantity) {
        this.addAutoCriteria(item);
        Ingredient ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public ShapelessRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        if (this.generateCriteria) {
            logger.warn("Criteria not automatically generated for raw ingredient.", new Throwable("Here, have a stack trace"));
        }
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    @Override
    public AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe _build() {
        return new FinishedShapelessRecipe();
    }

    public class FinishedShapelessRecipe
    extends AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe {
        @Override
        public void func_218610_a(JsonObject json) {
            super.func_218610_a(json);
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : ShapelessRecipeBuilder.this.ingredients) {
                ingredients.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)ingredients);
        }
    }
}

