/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.raytracer.VoxelShapeRayTraceResult;
import codechicken.lib.util.SneakyUtils;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;

public class MultiIndexedVoxelShape
extends VoxelShape {
    private final VoxelShape merged;
    private final ImmutableSet<IndexedVoxelShape> shapes;

    public MultiIndexedVoxelShape(ImmutableSet<IndexedVoxelShape> shapes) {
        this(VoxelShapeCache.merge((ImmutableSet<VoxelShape>)((ImmutableSet)SneakyUtils.unsafeCast(shapes))), shapes);
    }

    public MultiIndexedVoxelShape(VoxelShape merged, ImmutableSet<IndexedVoxelShape> shapes) {
        super(merged.field_197768_g);
        this.merged = merged;
        this.shapes = shapes;
    }

    public DoubleList func_197757_a(Direction.Axis axis) {
        return this.merged.func_197757_a(axis);
    }

    @Nullable
    public VoxelShapeRayTraceResult rayTrace(Vec3d start, Vec3d end, BlockPos pos) {
        VoxelShapeRayTraceResult closest = null;
        double dist = Double.MAX_VALUE;
        for (IndexedVoxelShape shape : this.shapes) {
            VoxelShapeRayTraceResult hit = shape.rayTrace(start, end, pos);
            if (hit == null || !(dist >= hit.dist)) continue;
            closest = hit;
            dist = hit.dist;
        }
        return closest;
    }
}

