/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.client;

import cityofskytcd.chineseworkshop.client.StackButton;
import cityofskytcd.chineseworkshop.library.Selection;
import cityofskytcd.chineseworkshop.library.Selections;
import cityofskytcd.chineseworkshop.network.ConvertItemPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class ConvertScreen
extends Screen {
    private static final ITextComponent TITLE = new TranslationTextComponent("chineseworkshop.gui.convert", new Object[0]);
    private final ItemStack stack;
    private StackButton selectedButton;
    private float alpha;
    private boolean closing;

    protected ConvertScreen(ItemStack stack) {
        super(TITLE);
        this.stack = stack;
    }

    protected void init() {
        if (this.stack.func_190926_b()) {
            return;
        }
        Selection selection = Selections.find(this.stack);
        if (selection == null) {
            return;
        }
        int xStart = this.minecraft.func_228018_at_().func_198107_o() / 2 - 30;
        int yStart = this.minecraft.func_228018_at_().func_198087_p() / 2 - 90;
        int size = selection.size();
        for (int i = 0; i < size; ++i) {
            int j = i;
            ItemStack substack = new ItemStack((IItemProvider)selection.get(i));
            substack.func_77982_d(this.stack.func_77978_p());
            StackButton button = new StackButton(xStart + i % 5 * 45, yStart + i / 5 * 45, substack, btn -> {
                new ConvertItemPacket(j).send();
                this.onClose();
            });
            if (this.selectedButton == null) {
                boolean bl = button.selected = substack.func_77973_b() == this.stack.func_77973_b();
                if (button.selected) {
                    this.selectedButton = button;
                }
            }
            this.addButton((Widget)button);
        }
        if (this.alpha == 0.0f && this.selectedButton != null) {
            double d0 = (double)(this.selectedButton.x + 35) * (double)this.minecraft.func_228018_at_().func_198105_m() / (double)this.minecraft.func_228018_at_().func_198107_o();
            double d1 = (double)(this.selectedButton.y + 30) * (double)this.minecraft.func_228018_at_().func_198083_n() / (double)this.minecraft.func_228018_at_().func_198087_p();
            GLFW.glfwSetCursorPos((long)this.minecraft.func_228018_at_().func_198092_i(), (double)d0, (double)d1);
        }
    }

    public void tick() {
        ItemStack held = this.minecraft.field_71439_g.func_184614_ca();
        if (this.stack.func_190926_b() || held.func_190926_b() || !ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)held)) {
            this.onClose();
        }
    }

    public void render(int mouseX, int mouseY, float pTicks) {
        this.alpha += this.closing ? -pTicks * 0.4f : pTicks * 0.2f;
        if (this.closing && this.alpha <= 0.0f) {
            Minecraft.func_71410_x().func_147108_a(null);
            return;
        }
        this.alpha = MathHelper.func_76131_a((float)this.alpha, (float)0.0f, (float)1.0f);
        this.renderBackground();
        if (this.alpha < 0.5f) {
            return;
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            Widget widget = (Widget)this.buttons.get(i);
            widget.render(mouseX, mouseY, pTicks);
            if (!widget.isHovered() || widget.getClass() != StackButton.class) continue;
            this.selectedButton = (StackButton)widget;
        }
        int x = this.minecraft.func_228018_at_().func_198107_o() / 2 - 150;
        int y = this.minecraft.func_228018_at_().func_198087_p() / 2 - 75;
        ItemStack stackMain = this.selectedButton == null ? this.stack : this.selectedButton.stack;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)5.0f, (float)5.0f, (float)5.0f);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
        itemRenderer.func_175042_a(stackMain, 0, 0);
        RenderSystem.popMatrix();
        this.drawCenteredString(this.font, stackMain.func_200301_q().func_150254_d(), x += 42, y += 92, -1);
    }

    public void renderBackground(int p_renderBackground_1_) {
        int textColor1 = (int)(this.alpha * 160.0f) << 24;
        int textColor2 = (int)(this.alpha * 112.0f) << 24;
        this.fillGradient(0, 0, this.width, (int)((double)this.height * 0.125), textColor1, textColor2);
        this.fillGradient(0, (int)((double)this.height * 0.125), this.width, (int)((double)this.height * 0.875), textColor2, textColor2);
        this.fillGradient(0, (int)((double)this.height * 0.875), this.width, this.height, textColor2, textColor1);
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this));
    }

    public void onClose() {
        this.closing = true;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

