/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.jei;

import cityofskytcd.chineseworkshop.BlockModule;
import cityofskytcd.chineseworkshop.library.Selection;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class SelectionCategory
implements IRecipeCategory<Selection> {
    public static final ResourceLocation UID = new ResourceLocation("chineseworkshop", "selection");
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable slotBackground;
    private final String localizedName;

    public SelectionCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlockModule.LOGO));
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = I18n.func_135052_a((String)"chineseworkshop.gui.convert", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class getRecipeClass() {
        return Selection.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(Selection selection, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)selection.getMainItem()));
        LinkedList items = Lists.newLinkedList(selection.getSubItems());
        items.add(selection.getMainItem());
        List outputs = items.stream().map(ItemStack::new).collect(Collectors.toList());
        ingredients.setOutputs(VanillaTypes.ITEM, outputs);
    }

    public void setRecipe(IRecipeLayout layout, Selection selection, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        int count = ingredients.getOutputs(VanillaTypes.ITEM).size();
        int h = 36 + 18 * (count / 6 + 1);
        int x = 71;
        int y = (125 - h) / 2;
        guiItemStacks.init(0, true, x, y);
        guiItemStacks.setBackground(0, this.slotBackground);
        int j = 0;
        y += 36;
        while (count > 0) {
            x = 26;
            for (int i = 0; i < 6; ++i) {
                guiItemStacks.init(++j, false, x, y);
                guiItemStacks.setBackground(j, this.slotBackground);
                x += 18;
                --count;
            }
            y += 18;
        }
        guiItemStacks.set(ingredients);
    }
}

