/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.items.RsItem;

public class ItemSwitchLinkPearl
extends RsItem {
    public ItemSwitchLinkPearl(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        int distance;
        SwitchLink link = SwitchLink.fromItemStack(stack);
        if (ModAuxiliaries.Tooltip.addInformation(stack, (IBlockReader)world, tooltip, flag, !link.valid)) {
            return;
        }
        if (!link.valid) {
            return;
        }
        Block targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(link.block_name));
        if (targetBlock != null) {
            tooltip.add((ITextComponent)ModAuxiliaries.localizable("switchlinking.switchlink_pearl.tooltip.linkedblock", TextFormatting.GRAY, new TranslationTextComponent(targetBlock.func_149739_a(), new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.YELLOW))));
        }
        if (Minecraft.func_71410_x().field_71439_g != null && (distance = link.distance(Minecraft.func_71410_x().field_71439_g.func_180425_c())) >= 0) {
            tooltip.add((ITextComponent)new StringTextComponent(ModAuxiliaries.localizable("switchlinking.switchlink_pearl.tooltip.linkeddistance", TextFormatting.GRAY, distance).func_150254_d() + (distance <= ModConfig.max_switch_linking_distance || ModConfig.max_switch_linking_distance <= 0 ? "" : " " + ModAuxiliaries.localizable("switchlinking.switchlink_pearl.tooltip.toofaraway", TextFormatting.DARK_RED, new Object[0]).func_150254_d())));
        }
        tooltip.add((ITextComponent)ModAuxiliaries.localizable("switchlinking.relayconfig.confval" + Integer.toString(link.relay()), TextFormatting.ITALIC, new Object[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.func_201670_d() || !player.func_225608_bj_()) {
            return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
        }
        ItemSwitchLinkPearl.usePearl(world, player);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public static final void usePearl(World world, PlayerEntity player) {
        switch (SwitchLink.fromPlayerActiveItem(world, player).request(1, world, player.func_180425_c(), player)) {
            case OK: {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_SUCCESS.play(world, player.func_180425_c());
                return;
            }
            case TOO_FAR: 
            case BLOCK_UNLOADED: {
                ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchlinking.switchlink_pearl.use.toofaraway", TextFormatting.DARK_RED, new Object[0]));
                break;
            }
            case TARGET_GONE: {
                ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchlinking.switchlink_pearl.use.targetgone", TextFormatting.DARK_RED, new Object[0]));
                break;
            }
        }
        ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, player.func_180425_c());
    }

    @Nullable
    public static final ItemStack createFromEnderPearl(World world, BlockPos pos, PlayerEntity player) {
        if (world == null || player == null || pos == null) {
            return null;
        }
        if (player.field_71071_by == null || player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() != Items.field_151079_bi) {
            return null;
        }
        BlockState state = world.func_180495_p(pos);
        if (state == null || !(state.func_177230_c() instanceof BlockSwitch)) {
            return null;
        }
        int rl = (((BlockSwitch)state.func_177230_c()).config & 0x20000000L) != 0L ? 1 : 0;
        ItemStack stack = new ItemStack((IItemProvider)ModContent.SWITCH_LINK_PEARL, player.field_71071_by.func_70448_g().func_190916_E());
        stack.func_77982_d(SwitchLink.fromTargetPosition(world, pos).with_relay(rl).toNbt());
        return stack;
    }

    public static final ItemStack getCycledRelay(ItemStack stack, World world, BlockPos target_pos) {
        if (world == null || stack == null || stack.func_77973_b() != ModContent.SWITCH_LINK_PEARL) {
            return stack;
        }
        SwitchLink current_link = SwitchLink.fromItemStack(stack);
        if (!target_pos.equals((Object)current_link.target_position)) {
            return stack;
        }
        BlockState state = world.func_180495_p(current_link.target_position);
        if (state == null || !(state.func_177230_c() instanceof BlockSwitch)) {
            return stack;
        }
        BlockSwitch block = (BlockSwitch)state.func_177230_c();
        int next = current_link.relay() + 1;
        if ((block.config & 0x20000000L) != 0L && (next < 1 || next > 3)) {
            next = 1;
        }
        SwitchLink lnk = current_link.with_relay(next < 5 ? next : 0);
        if (!lnk.valid) {
            return stack;
        }
        stack.func_77982_d(lnk.toNbt());
        return stack;
    }

    public static class SwitchLink {
        public static final long SWITCHLINK_CONFIG_DEFAULT = 0L;
        public static final long SWITCHLINK_CONFIG_RELAY_MASK = 7L;
        public static final int SWITCHLINK_RELAY_STATE = 0;
        public static final int SWITCHLINK_RELAY_ACTIVATE = 1;
        public static final int SWITCHLINK_RELAY_DEACTIVATE = 2;
        public static final int SWITCHLINK_RELAY_TOGGLE = 3;
        public static final int SWITCHLINK_RELAY_STATE_INV = 4;
        public static final int SWITCHLINK_RELAY_EOL = 5;
        public final BlockPos target_position;
        public final String block_name;
        public final long config;
        public final boolean valid;

        public SwitchLink() {
            this.target_position = BlockPos.field_177992_a;
            this.block_name = "";
            this.config = 0L;
            this.valid = false;
        }

        public SwitchLink(BlockPos pos, String name, long cfg) {
            this.target_position = pos;
            this.block_name = name;
            this.config = cfg;
            this.valid = !this.block_name.isEmpty() && pos.func_218275_a() != 0L;
        }

        public String toString() {
            return "SwitchLink{pos=" + this.target_position.toString() + ", block='" + this.block_name + "', config=" + Long.toString(this.config) + "}";
        }

        public int relay() {
            int r = (int)(this.config & 7L);
            return r < 5 ? r : 0;
        }

        public SwitchLink with_relay(int conf) {
            return new SwitchLink(this.target_position, this.block_name, this.config & 0xFFFFFFFFFFFFFFF8L | (long)conf & 7L);
        }

        public static SwitchLink fromNbt(CompoundNBT nbt) {
            return nbt == null ? new SwitchLink() : new SwitchLink(BlockPos.func_218283_e((long)nbt.func_74763_f("p")), nbt.func_74779_i("b"), nbt.func_74763_f("t"));
        }

        public static SwitchLink fromItemStack(ItemStack stack) {
            return stack == null || stack.func_190926_b() || stack.func_77973_b() != ModContent.SWITCH_LINK_PEARL ? new SwitchLink() : SwitchLink.fromNbt(stack.func_77978_p());
        }

        public static SwitchLink fromTargetPosition(World world, BlockPos targetPos) {
            if (targetPos == null) {
                return new SwitchLink();
            }
            BlockState state = world.func_180495_p(targetPos);
            if (state == null || !(state.func_177230_c() instanceof BlockSwitch)) {
                return new SwitchLink();
            }
            BlockSwitch block = (BlockSwitch)state.func_177230_c();
            if ((block.config & 0x200000000000000L) == 0L) {
                return new SwitchLink();
            }
            return new SwitchLink(targetPos, block.getRegistryName().toString(), 0L);
        }

        public static SwitchLink fromPlayerActiveItem(World world, PlayerEntity player) {
            if (player == null || world.field_72995_K || player.field_71071_by == null || player.field_71071_by.func_70448_g() == null) {
                return new SwitchLink();
            }
            if (player.field_71071_by.func_70448_g().func_77973_b() != ModContent.SWITCH_LINK_PEARL) {
                return null;
            }
            return SwitchLink.fromNbt(player.field_71071_by.func_70448_g().func_77978_p());
        }

        public CompoundNBT toNbt() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("b", this.block_name);
            nbt.func_74772_a("t", this.config);
            nbt.func_74772_a("p", this.target_position.func_218275_a());
            return nbt;
        }

        public ItemStack toSwitchLinkPearl() {
            ItemStack stack = new ItemStack((IItemProvider)ModContent.SWITCH_LINK_PEARL);
            stack.func_190920_e(1);
            stack.func_77982_d(this.toNbt());
            return stack;
        }

        public int distance(@Nullable BlockPos pos) {
            return pos == null || !this.valid ? -1 : (int)Math.sqrt(this.target_position.func_177951_i((Vec3i)pos));
        }

        public boolean isTooFar(BlockPos pos) {
            return ModConfig.max_switch_linking_distance > 0 && this.distance(pos) > ModConfig.max_switch_linking_distance;
        }

        public RequestResult request(int req, World world, BlockPos source_pos, @Nullable PlayerEntity player) {
            if (ModConfig.without_switch_linking) {
                return RequestResult.REJECTED;
            }
            if (!this.valid) {
                return RequestResult.INVALID_LINKDATA;
            }
            if (this.isTooFar(source_pos)) {
                return RequestResult.TOO_FAR;
            }
            if (!world.func_175667_e(this.target_position)) {
                return RequestResult.BLOCK_UNLOADED;
            }
            BlockState target_state = world.func_180495_p(this.target_position);
            if (target_state == null) {
                return RequestResult.BLOCK_UNLOADED;
            }
            Block block = target_state.func_177230_c();
            if (!(block instanceof BlockSwitch) || !block.getRegistryName().toString().equals(this.block_name)) {
                return RequestResult.TARGET_GONE;
            }
            BlockSwitch target_block = (BlockSwitch)block;
            if (player == null) {
                switch (this.relay()) {
                    case 0: 
                    case 4: {
                        boolean powered = (Boolean)target_state.func_177229_b((IProperty)BlockSwitch.POWERED);
                        if (this.relay() == 4) {
                            boolean bl = powered = !powered;
                        }
                        if (req == 1) {
                            if (!powered) break;
                            return RequestResult.NOT_MATCHED;
                        }
                        if (req != 2) break;
                        if (!powered) {
                            return RequestResult.NOT_MATCHED;
                        }
                        if ((target_block.config & 0x20000000L) == 0L) break;
                        return RequestResult.NOT_MATCHED;
                    }
                    case 1: {
                        if (req == 1) break;
                        return RequestResult.NOT_MATCHED;
                    }
                    case 2: {
                        if (req == 2) break;
                        return RequestResult.NOT_MATCHED;
                    }
                    case 3: {
                        if (req == 1 || req == 2) break;
                        return RequestResult.NOT_MATCHED;
                    }
                }
            }
            return target_block.onLinkRequest(this, req, world, this.target_position, player) ? RequestResult.OK : RequestResult.REJECTED;
        }

        public static enum RequestResult {
            OK,
            NOT_MATCHED,
            INVALID_LINKDATA,
            TOO_FAR,
            BLOCK_UNLOADED,
            TARGET_GONE,
            REJECTED;

        }
    }
}

