/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.beacon;

import com.teammetallurgy.atum.blocks.beacon.tileentity.RadiantBeaconTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BeaconBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBeaconBeamColorProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class RadiantBeaconBlock
extends BeaconBlock {
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.func_177709_a((String)"color", DyeColor.class);

    public RadiantBeaconBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(3.0f).func_200951_a(15).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(COLOR, (Comparable)DyeColor.WHITE));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader reader) {
        return new RadiantBeaconTileEntity();
    }

    @Nonnull
    public MaterialColor func_180659_g(BlockState state, IBlockReader world, BlockPos pos) {
        return ((DyeColor)state.func_177229_b(COLOR)).func_196055_e();
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_190926_b()) {
            return ActionResultType.FAIL;
        }
        Block block = Block.func_149634_a((Item)heldStack.func_77973_b());
        if (!world.field_72995_K) {
            DyeColor color = null;
            Block beacon = AtumBlocks.RADIANT_BEACON;
            if (block.func_149739_a().contains("framed")) {
                beacon = AtumBlocks.RADIANT_BEACON_FRAMED;
            }
            if (block.func_203417_a(Tags.Blocks.GLASS_COLORLESS) || block.func_203417_a(Tags.Blocks.GLASS_PANES_COLORLESS)) {
                color = DyeColor.WHITE;
            } else if (block instanceof IBeaconBeamColorProvider) {
                color = ((IBeaconBeamColorProvider)block).func_196457_d();
            }
            if (color != null && color != state.func_177229_b(COLOR)) {
                if (beacon == this) {
                    world.func_184133_a(null, pos, SoundEvents.field_206940_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                world.func_175656_a(pos, (BlockState)beacon.func_176223_P().func_206870_a(COLOR, (Comparable)color));
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new IProperty[]{COLOR});
    }
}

