/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone;

import com.teammetallurgy.atum.blocks.machines.KilnBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class LimestoneBrickBlock
extends Block {
    public static final BooleanProperty UNBREAKABLE = BooleanProperty.func_177716_a((String)"unbreakable");

    public LimestoneBrickBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151658_d).func_200948_a(1.5f, 8.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)UNBREAKABLE, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (state.func_177230_c() == AtumBlocks.LIMESTONE_BRICK_SMALL) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos checkPos = pos.func_177982_a(dx, dy, dz);
                        BlockState kilnState = world.func_180495_p(checkPos);
                        if (kilnState.func_177230_c() != AtumBlocks.KILN) continue;
                        KilnBlock kiln = (KilnBlock)kilnState.func_177230_c();
                        kiln.tryMakeMultiblock(world, checkPos, kilnState);
                    }
                }
            }
        }
    }

    public float func_176195_g(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)UNBREAKABLE) != false ? -1.0f : super.func_176195_g(state, world, pos);
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)UNBREAKABLE) != false ? 6000000.0f : super.getExplosionResistance(state, world, pos, exploder, explosion);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new IProperty[]{UNBREAKABLE});
    }
}

