/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity;

import com.teammetallurgy.atum.blocks.base.tileentity.ChestBaseTileEntity;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.SarcophagusBlock;
import com.teammetallurgy.atum.entity.undead.PharaohEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumSounds;
import com.teammetallurgy.atum.init.AtumTileEntities;
import com.teammetallurgy.atum.network.NetworkHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class SarcophagusTileEntity
extends ChestBaseTileEntity {
    public static final String SARCOPHAGUS_CONTAINER = "atum.container.sarcophagus";
    public boolean hasSpawned = false;
    public boolean isOpenable = false;

    public SarcophagusTileEntity() {
        super(AtumTileEntities.SARCOPHAGUS, false, true, AtumBlocks.SARCOPHAGUS);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TranslationTextComponent(SARCOPHAGUS_CONTAINER, new Object[0]);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        super.onDataPacket(manager, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        this.hasSpawned = compound.func_74767_n("spawned");
        this.isOpenable = compound.func_74767_n("openable");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("spawned", this.hasSpawned);
        compound.func_74757_a("openable", this.isOpenable);
        return compound;
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        return this.isOpenable && super.func_70300_a(player);
    }

    public void setOpenable() {
        this.isOpenable = true;
        this.func_70296_d();
        if (this.field_145850_b instanceof ServerWorld) {
            SUpdateTileEntityPacket packet = this.func_189518_D_();
            NetworkHandler.sendToTracking((ServerWorld)this.field_145850_b, this.field_174879_c, packet, false);
        }
    }

    public void spawn(PlayerEntity player, DifficultyInstance difficulty) {
        if (!this.field_145850_b.field_72995_K) {
            PharaohEntity pharaoh = (PharaohEntity)AtumEntities.PHARAOH.func_200721_a(this.field_145850_b);
            pharaoh.func_213386_a((IWorld)this.field_145850_b, difficulty, SpawnReason.TRIGGERED, null, null);
            Direction blockFacing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)SarcophagusBlock.field_176459_a);
            pharaoh.func_70012_b(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p(), blockFacing.func_185119_l() + 90.0f, 0.0f);
            pharaoh.field_70759_as = blockFacing.func_185119_l() + 90.0f;
            pharaoh.setSarcophagusPos(this.field_174879_c);
            this.field_145850_b.func_217376_c((Entity)pharaoh);
            pharaoh.spawnGuards(pharaoh.func_180425_c().func_177967_a(blockFacing, 1).func_177977_b());
            pharaoh.func_70656_aK();
            this.hasSpawned = true;
            if (this.field_145850_b instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
                for (ServerPlayerEntity playerMP : serverWorld.func_73046_m().func_184103_al().func_181057_v()) {
                    playerMP.func_145747_a(new StringTextComponent(PharaohEntity.God.getGod(pharaoh.getVariant()).getColor() + pharaoh.func_200200_C_().func_150254_d()).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("chat.atum.summon_pharaoh", new Object[0])).func_150258_a(" " + player.func_146103_bH().getName()));
                }
            }
        }
        this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), AtumSounds.PHARAOH_SPAWN, SoundCategory.HOSTILE, 0.8f, 1.0f, true);
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return this.isOpenable && super.func_94041_b(index, stack);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return this.isOpenable ? super.func_70298_a(index, count) : ItemStack.field_190927_a;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nonnull Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.isOpenable ? super.getCapability(capability, direction) : LazyOptional.empty();
        }
        return super.getCapability(capability, direction);
    }
}

