/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client;

import com.teammetallurgy.atum.blocks.wood.AtumTorchUnlitBlock;
import com.teammetallurgy.atum.client.gui.block.KilnScreen;
import com.teammetallurgy.atum.client.gui.block.TrapScreen;
import com.teammetallurgy.atum.client.gui.entity.AlphaDesertWolfScreen;
import com.teammetallurgy.atum.client.gui.entity.CamelScreen;
import com.teammetallurgy.atum.client.model.SeparatePerspectiveModel;
import com.teammetallurgy.atum.client.model.entity.BonestormModel;
import com.teammetallurgy.atum.client.model.entity.ForsakenModel;
import com.teammetallurgy.atum.client.model.entity.MonsterModel;
import com.teammetallurgy.atum.client.model.entity.NomadModel;
import com.teammetallurgy.atum.client.render.entity.HeartOfRaRender;
import com.teammetallurgy.atum.client.render.entity.TefnutsCallRender;
import com.teammetallurgy.atum.client.render.entity.mobs.AtumBipedRender;
import com.teammetallurgy.atum.client.render.entity.mobs.AtumMobRender;
import com.teammetallurgy.atum.client.render.entity.mobs.CamelRender;
import com.teammetallurgy.atum.client.render.entity.mobs.DesertRabbitRender;
import com.teammetallurgy.atum.client.render.entity.mobs.DesertWolfRender;
import com.teammetallurgy.atum.client.render.entity.mobs.ScarabRender;
import com.teammetallurgy.atum.client.render.entity.mobs.StonewardenRender;
import com.teammetallurgy.atum.client.render.entity.mobs.TarantulaRender;
import com.teammetallurgy.atum.client.render.tileentity.CrateRender;
import com.teammetallurgy.atum.client.render.tileentity.HeartOfRaBaseRender;
import com.teammetallurgy.atum.client.render.tileentity.QuernRender;
import com.teammetallurgy.atum.client.render.tileentity.RadiantBeaconRender;
import com.teammetallurgy.atum.client.render.tileentity.SarcophagusRender;
import com.teammetallurgy.atum.client.render.tileentity.TileChestRender;
import com.teammetallurgy.atum.entity.projectile.arrow.CustomArrow;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumGuis;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumTileEntities;
import com.teammetallurgy.atum.items.DyeableTexturedArmor;
import com.teammetallurgy.atum.misc.AtumRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.LlamaSpitRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    private static final List<ResourceLocation> CHEST_ATLAS_TEXTURES = new ArrayList<ResourceLocation>();
    private static final List<ResourceLocation> SHIELD_ATLAS_TEXTURES = new ArrayList<ResourceLocation>();

    public static void init() {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("atum", "separate_perspective"), (IModelLoader)SeparatePerspectiveModel.Loader.INSTANCE);
        ScreenManager.func_216911_a(AtumGuis.ALPHA_DESERT_WOLF, AlphaDesertWolfScreen::new);
        ScreenManager.func_216911_a(AtumGuis.CAMEL, CamelScreen::new);
        ScreenManager.func_216911_a(AtumGuis.KILN, KilnScreen::new);
        ScreenManager.func_216911_a(AtumGuis.TRAP, TrapScreen::new);
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColor = Minecraft.func_71410_x().getItemColors();
        itemColor.func_199877_a((stack, tintIndex) -> {
            BlockState state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            return Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, tintIndex);
        }, new IItemProvider[]{AtumBlocks.PALM_LEAVES, AtumBlocks.DEADWOOD_LEAVES});
        blockColors.func_186722_a((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.func_228361_b_((ILightReader)world, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{AtumBlocks.PALM_LEAVES, AtumBlocks.DEADWOOD_LEAVES});
        itemColor.func_199877_a((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableTexturedArmor)stack.func_77973_b()).func_200886_f(stack), new IItemProvider[]{AtumItems.WANDERER_HELMET, AtumItems.WANDERER_CHEST, AtumItems.WANDERER_LEGS, AtumItems.WANDERER_BOOTS, AtumItems.DESERT_HELMET_IRON, AtumItems.DESERT_CHEST_IRON, AtumItems.DESERT_LEGS_IRON, AtumItems.DESERT_BOOTS_IRON, AtumItems.DESERT_HELMET_GOLD, AtumItems.DESERT_CHEST_GOLD, AtumItems.DESERT_LEGS_GOLD, AtumItems.DESERT_BOOTS_GOLD, AtumItems.DESERT_HELMET_DIAMOND, AtumItems.DESERT_CHEST_DIAMOND, AtumItems.DESERT_LEGS_DIAMOND, AtumItems.DESERT_BOOTS_DIAMOND});
        itemColor.func_199877_a((stack, tintIndex) -> {
            BlockState blockState = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            return blockColors.func_228054_a_(blockState, null, null, tintIndex);
        }, new IItemProvider[]{AtumBlocks.DEAD_GRASS});
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (world != null && pos != null) {
                return BiomeColors.func_228358_a_((ILightReader)world, (BlockPos)pos);
            }
            return 12889745;
        }, new Block[]{AtumBlocks.DEAD_GRASS});
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        RenderType cutoutMipped = RenderType.func_228641_d_();
        RenderType translucent = RenderType.func_228645_f_();
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.ANPUTS_FINGERS, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.OASIS_GRASS, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.DEAD_GRASS, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.SHRUB, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.WEED, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.OPHIDIAN_TONGUE, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.BONE_LADDER, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.RADIANT_BEACON, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.RADIANT_BEACON_FRAMED, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_WHITE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_ORANGE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_MAGENTA_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_LIGHT_BLUE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_YELLOW_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_LIME_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_PINK_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_GRAY_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_LIGHT_GRAY_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_CYAN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_PURPLE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_BLUE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_BROWN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_GREEN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_RED_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.CRYSTAL_BLACK_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_WHITE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_ORANGE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_MAGENTA_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_LIGHT_BLUE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_YELLOW_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_LIME_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_PINK_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_GRAY_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_LIGHT_GRAY_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_CYAN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_PURPLE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_BLUE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_BROWN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_GREEN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_RED_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_CRYSTAL_BLACK_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_WHITE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_ORANGE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_MAGENTA_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_LIGHT_BLUE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_YELLOW_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_LIME_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_PINK_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_GRAY_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_LIGHT_GRAY_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_CYAN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_PURPLE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_BLUE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_BROWN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_GREEN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_RED_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FRAMED_BLACK_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_WHITE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_ORANGE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_MAGENTA_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_LIGHT_BLUE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_YELLOW_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_LIME_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_PINK_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_GRAY_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_LIGHT_GRAY_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_CYAN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_PURPLE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_BLUE_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_BROWN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_GREEN_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_RED_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.THIN_FRAMED_BLACK_STAINED_GLASS, (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.PALM_SAPLING, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.PALM_LEAVES, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.DEADWOOD_LEAVES, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.PALM_LADDER, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.DEADWOOD_LADDER, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.DEADWOOD_HATCH, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.DEADWOOD_DOOR, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.PAPYRUS, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.FLAX, (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)AtumBlocks.EMMER_WHEAT, (RenderType)cutoutMipped);
        for (Block block : AtumTorchUnlitBlock.ALL_TORCHES) {
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)cutoutMipped);
        }
        ClientRegistry.bindTileEntityRenderer(AtumTileEntities.CHEST_SPAWNER, TileChestRender::new);
        ClientRegistry.bindTileEntityRenderer(AtumTileEntities.LIMESTONE_CHEST, TileChestRender::new);
        ClientRegistry.bindTileEntityRenderer(AtumTileEntities.SARCOPHAGUS, SarcophagusRender::new);
        ClientRegistry.bindTileEntityRenderer(AtumTileEntities.CRATE, CrateRender::new);
        ClientRegistry.bindTileEntityRenderer(AtumTileEntities.HEART_OF_RA, HeartOfRaBaseRender::new);
        ClientRegistry.bindTileEntityRenderer(AtumTileEntities.RADIANT_BEACON, RadiantBeaconRender::new);
        ClientRegistry.bindTileEntityRenderer(AtumTileEntities.QUERN, QuernRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.TARANTULA, TarantulaRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.ASSASSIN, AtumBipedRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.SERGEANT, AtumBipedRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.BRIGAND, AtumBipedRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.BARBARIAN, AtumBipedRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.NOMAD, manager -> new AtumBipedRender(manager, new NomadModel(), new NomadModel(0.5f), new NomadModel(1.0f)));
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.BANDIT_WARLORD, AtumBipedRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.PHARAOH, AtumBipedRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.MUMMY, manager -> new AtumBipedRender(manager, new MonsterModel(0.0f, false), new MonsterModel(0.5f, false), new MonsterModel(1.0f, false)));
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.FORSAKEN, manager -> new AtumBipedRender(manager, new ForsakenModel(), new ForsakenModel(0.5f), new ForsakenModel(1.0f)));
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.WRAITH, manager -> new AtumBipedRender(manager, new MonsterModel(0.0f, false), new MonsterModel(0.5f, false), new MonsterModel(1.0f, false)));
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.SUNSPEAKER, AtumBipedRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.BONESTORM, manager -> new AtumMobRender(manager, new BonestormModel()));
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.STONEGUARD, AtumBipedRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.STONEWARDEN, StonewardenRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.STONEGUARD_FRIENDLY, AtumBipedRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.STONEWARDEN_FRIENDLY, StonewardenRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.DESERT_WOLF, DesertWolfRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.CAMEL, CamelRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.SCARAB, ScarabRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.DESERT_RABBIT, DesertRabbitRender::new);
        for (EntityType entityType : AtumRegistry.ARROWS) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entityType, manager -> new ArrowRenderer<CustomArrow>(manager){

                @Nonnull
                public ResourceLocation getEntityTexture(@Nonnull CustomArrow entity) {
                    return entity.getTexture();
                }
            });
        }
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.SMALL_BONE, manager -> new SpriteRenderer(manager, itemRenderer, 0.35f, true));
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.TEFNUTS_CALL, TefnutsCallRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.HEART_OF_RA, HeartOfRaRender::new);
        RenderingRegistry.registerEntityRenderingHandler(AtumEntities.CAMEL_SPIT, LlamaSpitRenderer::new);
    }

    public static void addToChestAtlas(ResourceLocation location) {
        if (!CHEST_ATLAS_TEXTURES.contains(location)) {
            CHEST_ATLAS_TEXTURES.add(location);
        }
    }

    public static void addToShieldAtlas(ResourceLocation location) {
        if (!SHIELD_ATLAS_TEXTURES.contains(location)) {
            SHIELD_ATLAS_TEXTURES.add(location);
        }
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            for (ResourceLocation location : CHEST_ATLAS_TEXTURES) {
                event.addSprite(location);
            }
        }
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228745_d_)) {
            for (ResourceLocation location : SHIELD_ATLAS_TEXTURES) {
                event.addSprite(location);
            }
        }
    }
}

