/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.entity.ITexture;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AtumBipedRender<T extends MobEntity, M extends BipedModel<T>>
extends BipedRenderer<T, M> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();

    public AtumBipedRender(EntityRendererManager manager) {
        this(manager, new PlayerModel(0.0f, false), new PlayerModel(0.5f, false), new PlayerModel(1.0f, false));
    }

    public AtumBipedRender(EntityRendererManager renderManager, M model, M modelArmorHalf, M modelArmorFull) {
        super(renderManager, model, 0.5f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, modelArmorHalf, modelArmorFull));
    }

    @Nonnull
    public ResourceLocation func_110775_a(T entity) {
        String texture = ((ITexture)entity).getTexture();
        ResourceLocation location = CACHE.get(texture);
        if (location == null) {
            location = new ResourceLocation(texture);
            CACHE.put(texture, location);
        }
        return location;
    }
}

