/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.ai.goal;

import com.teammetallurgy.atum.entity.animal.DesertWolfEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class BegGoal
extends Goal {
    private final DesertWolfEntity desertWolf;
    private PlayerEntity player;
    private final World world;
    private final float minPlayerDistance;
    private int timeoutCounter;
    private final EntityPredicate predicate;

    public BegGoal(DesertWolfEntity desertWolf, float minDistance) {
        this.desertWolf = desertWolf;
        this.world = desertWolf.field_70170_p;
        this.minPlayerDistance = minDistance;
        this.predicate = new EntityPredicate().func_221013_a((double)minDistance).func_221008_a().func_221011_b().func_221009_d();
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        this.player = this.world.func_217370_a(this.predicate, (LivingEntity)this.desertWolf);
        return this.player != null && this.hasTemptationItemInHand(this.player);
    }

    public boolean func_75253_b() {
        if (!this.player.func_70089_S()) {
            return false;
        }
        if (this.desertWolf.func_70068_e((Entity)this.player) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        return this.timeoutCounter > 0 && this.hasTemptationItemInHand(this.player);
    }

    public void func_75249_e() {
        this.desertWolf.setBegging(true);
        this.timeoutCounter = 40 + this.desertWolf.func_70681_au().nextInt(40);
    }

    public void func_75251_c() {
        this.desertWolf.setBegging(false);
        this.player = null;
    }

    public void func_75246_d() {
        this.desertWolf.func_70671_ap().func_75650_a(this.player.func_226277_ct_(), this.player.func_226278_cu_() + (double)this.player.func_70047_e(), this.player.func_226281_cx_(), 10.0f, (float)this.desertWolf.func_70646_bf());
        --this.timeoutCounter;
    }

    private boolean hasTemptationItemInHand(PlayerEntity player) {
        for (Hand hand : Hand.values()) {
            ItemStack heldStack = player.func_184586_b(hand);
            if (this.desertWolf.func_70909_n() && heldStack.func_77973_b().func_206844_a(Tags.Items.BONES)) {
                return true;
            }
            if (!this.desertWolf.func_70877_b(heldStack)) continue;
            return true;
        }
        return false;
    }
}

