/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.efreet;

import com.teammetallurgy.atum.entity.ITexture;
import com.teammetallurgy.atum.entity.ai.goal.OpenAnyDoorGoal;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EfreetBaseEntity
extends AgeableEntity
implements ITexture {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EfreetBaseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private String texturePath;
    protected int angerLevel;
    protected UUID angerTargetUUID;

    public EfreetBaseEntity(EntityType<? extends EfreetBaseEntity> entityType, World world) {
        super(entityType, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new OpenAnyDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.func_175456_n();
    }

    protected void getSuperGoals() {
        super.func_184651_r();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (Goal)new AIHurtByAggressor(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new AITargetAggressor(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        if (this.hasSkinVariants()) {
            this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        }
    }

    protected int getVariantAmount() {
        return 3;
    }

    protected boolean hasSkinVariants() {
        return this.getVariantAmount() > 0;
    }

    protected void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            String entityName = Objects.requireNonNull(this.func_200600_R().getRegistryName()).func_110623_a();
            this.texturePath = this.hasSkinVariants() ? new ResourceLocation("atum", "textures/entity/" + entityName + "_" + this.getVariant()) + ".png" : new ResourceLocation("atum", "textures/entity/" + entityName) + ".png";
        }
        return this.texturePath;
    }

    @Nonnull
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_193787_df;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219688_iu;
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT nbt) {
        livingdata = super.func_213386_a(world, difficulty, spawnReason, livingdata, nbt);
        this.func_180481_a(difficulty);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        if (this.hasSkinVariants()) {
            int variant = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)this.getVariantAmount());
            this.setVariant(variant);
        }
        return livingdata;
    }

    protected void func_180481_a(@Nonnull DifficultyInstance difficulty) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return this.isAngry();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_70619_bc() {
        LivingEntity revengeTarget = this.func_70643_av();
        if (this.isAngry()) {
            LivingEntity livingEntity;
            --this.angerLevel;
            LivingEntity livingEntity2 = livingEntity = revengeTarget != null ? revengeTarget : this.func_70638_az();
            if (!this.isAngry() && livingEntity != null) {
                if (!this.func_70685_l((Entity)livingEntity)) {
                    this.func_70604_c(null);
                    this.func_70624_b(null);
                } else {
                    this.angerLevel = this.getAngryAmount();
                }
            }
        }
        if (this.isAngry() && this.angerTargetUUID != null && revengeTarget == null) {
            PlayerEntity player = this.field_70170_p.func_217371_b(this.angerTargetUUID);
            this.func_70604_c((LivingEntity)player);
            this.field_70717_bb = player;
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof PlayerEntity && !((PlayerEntity)entity).func_184812_l_() && this.func_70685_l(entity)) {
            this.becomeAngryAt((LivingEntity)entity);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70604_c(@Nullable LivingEntity livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    private boolean becomeAngryAt(LivingEntity livingEntity) {
        this.angerLevel = this.getAngryAmount();
        this.func_70604_c(livingEntity);
        return true;
    }

    private int getAngryAmount() {
        return 250 + this.field_70146_Z.nextInt(400);
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.hasSkinVariants()) {
            compound.func_74768_a("Variant", this.getVariant());
        }
        compound.func_74777_a("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.hasSkinVariants()) {
            this.setVariant(compound.func_74762_e("Variant"));
        }
        this.angerLevel = compound.func_74765_d("Anger");
        String hurtBy = compound.func_74779_i("HurtBy");
        if (!hurtBy.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(hurtBy);
            PlayerEntity player = this.field_70170_p.func_217371_b(this.angerTargetUUID);
            if (player != null) {
                this.func_70604_c((LivingEntity)player);
                this.field_70717_bb = player;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        boolean attackEntity;
        int fireAspect;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float knockback = (float)this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111126_e();
        if (entity instanceof LivingEntity) {
            attackDamage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entity).func_70668_bt());
            knockback += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((fireAspect = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entity.func_70015_d(fireAspect * 4);
        }
        if (attackEntity = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), attackDamage)) {
            if (knockback > 0.0f && entity instanceof LivingEntity) {
                ((LivingEntity)entity).func_70653_a((Entity)this, knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            this.func_174815_a((LivingEntity)this, entity);
        }
        return attackEntity;
    }

    static class AITargetAggressor
    extends NearestAttackableTargetGoal<PlayerEntity> {
        AITargetAggressor(EfreetBaseEntity efreet) {
            super((MobEntity)efreet, PlayerEntity.class, true);
        }

        public boolean func_75250_a() {
            EfreetBaseEntity efreet = (EfreetBaseEntity)this.field_75299_d;
            return efreet.isAngry() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            EfreetBaseEntity efreet = (EfreetBaseEntity)this.field_75299_d;
            return efreet.isAngry() && super.func_75253_b();
        }
    }

    static class AIHurtByAggressor
    extends HurtByTargetGoal {
        AIHurtByAggressor(EfreetBaseEntity efreet) {
            super((CreatureEntity)efreet, new Class[0]);
            this.func_220794_a(new Class[0]);
        }

        protected void func_220793_a(@Nonnull MobEntity entity, @Nonnull LivingEntity living) {
            if (entity instanceof EfreetBaseEntity && this.field_75299_d.func_70685_l((Entity)living) && ((EfreetBaseEntity)entity).becomeAngryAt(living)) {
                entity.func_70624_b(living);
            }
        }

        public boolean func_75253_b() {
            EfreetBaseEntity efreet = (EfreetBaseEntity)this.field_75299_d;
            return efreet.isAngry() && super.func_75253_b();
        }
    }
}

