/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.projectile;

import com.teammetallurgy.atum.entity.animal.CamelEntity;
import com.teammetallurgy.atum.init.AtumEntities;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class CamelSpitEntity
extends LlamaSpitEntity {
    private CamelEntity owner;
    private CompoundNBT ownerNbt;

    public CamelSpitEntity(FMLPlayMessages.SpawnEntity spawnPacket, World world) {
        this(AtumEntities.CAMEL_SPIT, world);
    }

    public CamelSpitEntity(EntityType<? extends CamelSpitEntity> entityType, World world) {
        super(entityType, world);
    }

    public CamelSpitEntity(World world, CamelEntity camel) {
        this(AtumEntities.CAMEL_SPIT, world);
        this.owner = camel;
        this.func_70107_b(camel.func_226277_ct_() - (double)(camel.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(camel.field_70761_aq * ((float)Math.PI / 180))), camel.func_226278_cu_() + (double)camel.func_70047_e() - (double)0.1f, camel.func_226281_cx_() + (double)(camel.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(camel.field_70761_aq * ((float)Math.PI / 180))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public CamelSpitEntity(World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this(AtumEntities.CAMEL_SPIT, world);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            world.func_195594_a((IParticleData)ParticleTypes.field_197602_M, x, y, z, xSpeed * d0, ySpeed, zSpeed * d0);
        }
        this.func_213293_j(xSpeed, ySpeed, zSpeed);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.ownerNbt != null) {
            this.restoreOwnerFromSave();
        }
        Vec3d motion = this.func_213322_ci();
        RayTraceResult raytrace = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(motion).func_186662_g(1.0), e -> !e.func_175149_v() && e != this.owner, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true);
        if (raytrace != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytrace)) {
            this.func_190536_a(raytrace);
        }
        double x = this.func_226277_ct_() + motion.field_72450_a;
        double y = this.func_226278_cu_() + motion.field_72448_b;
        double z = this.func_226281_cx_() + motion.field_72449_c;
        float f = MathHelper.func_76133_a((double)CamelSpitEntity.func_213296_b((Vec3d)motion));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (!this.field_70170_p.func_72875_a(this.func_174813_aQ(), Material.field_151579_a)) {
            this.func_70106_y();
        } else if (this.func_203005_aq()) {
            this.func_70106_y();
        } else {
            this.func_213317_d(motion.func_186678_a((double)0.99f));
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.06f, 0.0));
            }
            this.func_70107_b(x, y, z);
        }
    }

    public void func_190536_a(RayTraceResult rayTrace) {
        RayTraceResult.Type type = rayTrace.func_216346_c();
        if (type == RayTraceResult.Type.ENTITY && this.owner != null) {
            ((EntityRayTraceResult)rayTrace).func_216348_a().func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.owner).func_76349_b(), 1.0f);
        } else if (type == RayTraceResult.Type.BLOCK && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Owner", 10)) {
            this.ownerNbt = compound.func_74775_l("Owner");
        }
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        if (this.owner != null) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            UUID uuid = this.owner.func_110124_au();
            nbttagcompound.func_186854_a("OwnerUUID", uuid);
            compound.func_218657_a("Owner", (INBT)nbttagcompound);
        }
    }

    private void restoreOwnerFromSave() {
        if (this.ownerNbt != null && this.ownerNbt.func_186855_b("OwnerUUID")) {
            UUID uuid = this.ownerNbt.func_186857_a("OwnerUUID");
            for (CamelEntity entitycamel : this.field_70170_p.func_217357_a(CamelEntity.class, this.func_174813_aQ().func_186662_g(15.0))) {
                if (!entitycamel.func_110124_au().equals(uuid)) continue;
                this.owner = entitycamel;
                break;
            }
        }
        this.ownerNbt = null;
    }
}

