/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.blocks.trap.tileentity.TrapTileEntity;
import com.teammetallurgy.atum.inventory.container.block.KilnContainer;
import com.teammetallurgy.atum.inventory.container.block.TrapContainer;
import com.teammetallurgy.atum.inventory.container.entity.AlphaDesertWolfContainer;
import com.teammetallurgy.atum.inventory.container.entity.CamelContainer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="atum")
public class AtumGuis {
    public static List<ContainerType<?>> CONTAINERS = Lists.newArrayList();
    public static final ContainerType<AlphaDesertWolfContainer> ALPHA_DESERT_WOLF = AtumGuis.register(IForgeContainerType.create((windowID, inv, data) -> {
        int entityID = data.readInt();
        return new AlphaDesertWolfContainer(windowID, inv, entityID);
    }), "alpha_desert_wolf");
    public static final ContainerType<CamelContainer> CAMEL = AtumGuis.register(IForgeContainerType.create((windowID, inv, data) -> {
        int entityID = data.readInt();
        return new CamelContainer(windowID, inv, entityID);
    }), "camel");
    public static final ContainerType<KilnContainer> KILN = AtumGuis.register(IForgeContainerType.create((windowID, inv, data) -> new KilnContainer(windowID, inv, data.func_179259_c())), "kiln");
    public static final ContainerType<TrapContainer> TRAP = AtumGuis.register(IForgeContainerType.create((windowID, inv, data) -> {
        TrapTileEntity trap = (TrapTileEntity)inv.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return new TrapContainer(windowID, inv, trap);
    }), "trap");

    private static <T extends Container> ContainerType<T> register(@Nonnull ContainerType<T> container, @Nonnull String name) {
        container.setRegistryName(new ResourceLocation("atum", name));
        CONTAINERS.add(container);
        return container;
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        for (ContainerType<?> container : CONTAINERS) {
            event.getRegistry().register(container);
        }
    }
}

