/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.jei.categories;

import com.teammetallurgy.atum.api.recipe.recipes.SpinningWheelRecipe;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.integration.jei.JEIIntegration;
import java.awt.Color;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SpinningWheelRecipeCategory
implements IRecipeCategory<SpinningWheelRecipe> {
    public static final ResourceLocation SPINNING_WHEEL_GUI = new ResourceLocation("atum", "textures/gui/spinning_wheel.png");
    private final IDrawableStatic background;
    private final IDrawable icon;

    public SpinningWheelRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SPINNING_WHEEL_GUI, 0, -6, 68, 32);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)AtumBlocks.SPINNING_WHEEL));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return JEIIntegration.SPINNING_WHEEL;
    }

    @Nonnull
    public Class<? extends SpinningWheelRecipe> getRecipeClass() {
        return SpinningWheelRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return new TranslationTextComponent("atum." + this.getUid().func_110623_a(), new Object[0]).func_150254_d();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull SpinningWheelRecipe recipe, @Nonnull IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull SpinningWheelRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 10);
        guiItemStacks.init(1, false, 46, 10);
        guiItemStacks.set(ingredients);
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == 1) {
                boolean showAdvanced;
                boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.hasShiftDown();
                if (showAdvanced) {
                    tooltip.add(new TranslationTextComponent("jei.tooltip.recipe.id", new Object[]{recipe.func_199560_c()}).func_211709_a(new TextFormatting[]{TextFormatting.DARK_GRAY}).func_150254_d());
                }
            }
        });
    }

    public void draw(SpinningWheelRecipe recipe, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_211126_b(new TranslationTextComponent("gui.atum.rotations", new Object[]{recipe.getRotations()}).func_150254_d(), 25.0f, 0.0f, Color.gray.getRGB());
    }
}

