/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.inventory.container.block;

import com.teammetallurgy.atum.api.recipe.IAtumRecipeType;
import com.teammetallurgy.atum.blocks.machines.tileentity.KilnTileEntity;
import com.teammetallurgy.atum.init.AtumGuis;
import com.teammetallurgy.atum.inventory.container.slot.FuelSlot;
import com.teammetallurgy.atum.inventory.container.slot.KilnOutputSlot;
import com.teammetallurgy.atum.misc.recipe.RecipeHelper;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class KilnContainer
extends Container {
    public KilnTileEntity kilnInventory;
    private IIntArray kilnData;

    public KilnContainer(int windowID, PlayerInventory playerInventory, BlockPos pos) {
        super(AtumGuis.KILN, windowID);
        int slot;
        int row;
        PlayerEntity player = playerInventory.field_70458_d;
        this.kilnInventory = (KilnTileEntity)player.field_70170_p.func_175625_s(pos);
        KilnContainer.func_216962_a((IInventory)this.kilnInventory, (int)this.kilnInventory.func_70302_i_());
        IIntArray kilnData = this.kilnInventory.kilnData;
        KilnContainer.func_216959_a((IIntArray)kilnData, (int)kilnData.func_221478_a());
        this.kilnData = kilnData;
        for (row = 0; row < 2; ++row) {
            for (slot = 0; slot < 2; ++slot) {
                this.func_75146_a(new Slot((IInventory)this.kilnInventory, slot + row * 2, 71 + slot * 18, 15 + row * 18));
            }
        }
        this.func_75146_a(new FuelSlot((IInventory)this.kilnInventory, 4, 36, 48));
        for (row = 0; row < 2; ++row) {
            for (slot = 0; slot < 2; ++slot) {
                this.func_75146_a(new KilnOutputSlot(player, (IInventory)this.kilnInventory, 5 + (slot + row * 2), 71 + slot * 18, 63 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (slot = 0; slot < 9; ++slot) {
                this.func_75146_a(new Slot((IInventory)playerInventory, slot + row * 9 + 9, 8 + slot * 18, 84 + row * 18 + 26));
            }
        }
        for (int slot2 = 0; slot2 < 9; ++slot2) {
            this.func_75146_a(new Slot((IInventory)playerInventory, slot2, 8 + slot2 * 18, 168));
        }
        this.func_216961_a(kilnData);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        int slotFuel = 4;
        int internalStart = 0;
        int internalEnd = 3;
        int outputStart = 5;
        int outputEnd = 8;
        int playerStart = 9;
        int playerEnd = 35;
        int hotbarStart = 36;
        int hotbarEnd = 44;
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index == slotFuel) {
                if (!this.func_75135_a(slotStack, playerStart, hotbarEnd + 1, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotStack, stack);
            } else if (!(index >= internalStart && index <= internalEnd || index >= outputStart && index <= outputEnd) ? (this.getRecipe(slotStack) ? !this.func_75135_a(slotStack, internalStart, internalEnd + 1, false) : (AbstractFurnaceTileEntity.func_213991_b((ItemStack)slotStack) ? !this.func_75135_a(slotStack, slotFuel, slotFuel + 1, false) : (index >= playerStart && index <= playerEnd ? !this.func_75135_a(slotStack, hotbarStart, hotbarEnd + 1, false) : index >= hotbarStart && index <= hotbarEnd && !this.func_75135_a(slotStack, playerStart, playerEnd + 1, false)))) : !this.func_75135_a(slotStack, playerStart, hotbarEnd + 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return stack;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.kilnInventory.func_70300_a(player);
    }

    protected boolean getRecipe(@Nonnull ItemStack stack) {
        World world = this.kilnInventory.func_145831_w();
        RecipeManager recipeManager = world.func_199532_z();
        return recipeManager.func_215371_a(IAtumRecipeType.KILN, (IInventory)new Inventory(new ItemStack[]{stack}), world).isPresent() || RecipeHelper.isValidRecipeInput(RecipeHelper.getKilnRecipesFromFurnace(recipeManager), stack) != false;
    }

    public int getCookProgressionScaled() {
        int cookTime = this.kilnData.func_221476_a(2);
        int cookTimeTotal = this.kilnData.func_221476_a(3);
        return cookTimeTotal != 0 && cookTime != 0 ? cookTime * 8 / cookTimeTotal : 0;
    }

    public int getBurnLeftScaled() {
        int recipesUsed = this.kilnData.func_221476_a(1);
        if (recipesUsed == 0) {
            recipesUsed = 200;
        }
        return this.kilnData.func_221476_a(0) * 13 / recipesUsed;
    }

    public boolean isBurning() {
        return this.kilnData.func_221476_a(0) > 0;
    }
}

