/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.anubis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.entity.stone.StoneBaseEntity;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.misc.StackHelper;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class AnubisWrathItem
extends SwordItem {
    private static final Object2FloatMap<PlayerEntity> COOLDOWN = new Object2FloatOpenHashMap();
    private float attackDamage = 5.0f;

    public AnubisWrathItem() {
        super((IItemTier)ItemTier.DIAMOND, 0, 0.0f, new Item.Properties().func_208103_a(Rarity.RARE).func_200916_a(Atum.GROUP));
        this.func_185043_a(new ResourceLocation("tier"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(@Nonnull ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
                return AnubisWrathItem.getTier(stack);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return true;
    }

    public float func_200894_d() {
        return this.attackDamage;
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return !InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) ? super.showDurabilityBar(stack) : AnubisWrathItem.getSouls(stack) > 0;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return !InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) ? super.getDurabilityForDisplay(stack) : (double)(AnubisWrathItem.getSoulUpgradeTier(AnubisWrathItem.getTier(stack)) - Math.min(AnubisWrathItem.getSouls(stack), 500)) / (double)AnubisWrathItem.getSoulUpgradeTier(AnubisWrathItem.getTier(stack));
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return !InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) ? super.getRGBDurabilityForDisplay(stack) : 12452784;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAttack(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.func_184614_ca().func_77973_b() == AtumItems.ANUBIS_WRATH && AnubisWrathItem.getTier(player.func_184614_ca()) == 3 && event.getTarget() instanceof LivingEntity && ((LivingEntity)event.getTarget()).func_70668_bt() != CreatureAttribute.field_223223_b_ && !(event.getTarget() instanceof StoneBaseEntity)) {
            COOLDOWN.put((Object)player, player.func_184825_o(0.5f));
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource instanceof PlayerEntity && COOLDOWN.containsKey((Object)trueSource)) {
            if (COOLDOWN.getFloat((Object)trueSource) == 1.0f) {
                event.setAmount(event.getAmount() * 2.0f);
                LivingEntity entity = event.getEntityLiving();
                double y = MathHelper.func_82716_a((Random)field_77697_d, (double)0.02, (double)0.1);
                if (entity.field_70170_p instanceof ServerWorld) {
                    ServerWorld serverWorld = (ServerWorld)entity.field_70170_p;
                    serverWorld.func_195598_a((IParticleData)AtumParticles.ANUBIS, entity.func_226277_ct_() + (field_77697_d.nextDouble() - 0.5) * (double)entity.func_213311_cf(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_() + (field_77697_d.nextDouble() - 0.5) * (double)entity.func_213311_cf(), 5, 0.0, y, 0.0, 0.04);
                }
            }
            COOLDOWN.removeFloat((Object)trueSource);
        }
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        PlayerEntity player;
        PlayerInventory inv;
        Entity source = event.getSource().func_76346_g();
        if (source instanceof LivingEntity && ((LivingEntity)source).func_184614_ca().func_77973_b() == AtumItems.ANUBIS_WRATH) {
            ItemStack heldStack = ((LivingEntity)source).func_184614_ca();
            CompoundNBT tag = StackHelper.getTag(heldStack);
            tag.func_74768_a("souls", AnubisWrathItem.getSouls(heldStack) + 1);
            if (AnubisWrathItem.getSouls(heldStack) == 50 || AnubisWrathItem.getSouls(heldStack) == 150 || AnubisWrathItem.getSouls(heldStack) == 500) {
                source.field_70170_p.func_184133_a(null, source.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 0.0f);
                if (source instanceof PlayerEntity) {
                    ((PlayerEntity)source).func_146105_b(new TranslationTextComponent(heldStack.func_77977_a() + ".levelup", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
                }
            }
        }
        if (event.getEntityLiving() instanceof PlayerEntity && (inv = player.field_71071_by).func_70431_c(AnubisWrathItem.findAnubisWrath(player = (PlayerEntity)event.getEntityLiving()))) {
            CompoundNBT tag = StackHelper.getTag(AnubisWrathItem.findAnubisWrath(player));
            tag.func_74768_a("souls", AnubisWrathItem.getSouls(AnubisWrathItem.findAnubisWrath(player)) / 2);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187553_bI, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Nonnull
    private static ItemStack findAnubisWrath(PlayerEntity player) {
        if (player.func_184586_b(Hand.OFF_HAND).func_77973_b() == AtumItems.ANUBIS_WRATH) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == AtumItems.ANUBIS_WRATH) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != AtumItems.ANUBIS_WRATH) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, @Nonnull ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            int tier = AnubisWrathItem.getTier(stack);
            this.attackDamage = tier == 3 ? 9.0f : (float)tier + 5.0f;
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_200894_d(), AttributeModifier.Operation.ADDITION));
            double speed = tier == 0 ? 0.6 : (tier == 1 ? 0.7 : (tier == 2 ? 0.8 : (tier == 3 ? 1.0 : 0.0)));
            map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", speed - 3.0, AttributeModifier.Operation.ADDITION));
        }
        return map;
    }

    private static int getSouls(@Nonnull ItemStack stack) {
        return StackHelper.hasKey(stack, "souls") && stack.func_77978_p() != null ? stack.func_77978_p().func_74762_e("souls") : 0;
    }

    private static int getTier(@Nonnull ItemStack stack) {
        int souls = AnubisWrathItem.getSouls(stack);
        return souls < 50 ? 0 : (souls < 150 ? 1 : (souls < 500 ? 2 : 3));
    }

    private static int getSoulUpgradeTier(int tier) {
        return tier == 0 ? 50 : (tier == 1 ? 150 : (tier == 2 ? 500 : 500));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag tooltipType) {
        String itemIdentifier = "atum." + Objects.requireNonNull(stack.func_77973_b().getRegistryName()).func_110623_a() + ".tooltip";
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340)) {
            tooltip.add(new TranslationTextComponent(itemIdentifier + ".line1" + (AnubisWrathItem.getTier(stack) == 3 ? ".soul_unraveler" : ".soul_drinker"), new Object[0]).func_211708_a(TextFormatting.DARK_PURPLE));
            tooltip.add(new TranslationTextComponent(itemIdentifier + ".line2" + (AnubisWrathItem.getTier(stack) == 3 ? ".soul_unraveler" : ".soul_drinker"), new Object[0]).func_211708_a(TextFormatting.DARK_PURPLE));
        } else {
            tooltip.add(new TranslationTextComponent(itemIdentifier + (AnubisWrathItem.getTier(stack) == 3 ? ".soul_unraveler" : ".soul_drinker"), new Object[0]).func_150258_a(" ").func_150257_a(new TranslationTextComponent("atum.tooltip.shift", new Object[0]).func_211708_a(TextFormatting.DARK_GRAY)));
        }
        if (tooltipType.func_194127_a()) {
            tooltip.add(new TranslationTextComponent(itemIdentifier + ".kills", new Object[]{AnubisWrathItem.getSouls(stack)}).func_211708_a(TextFormatting.DARK_RED));
        }
    }
}

