/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc.datagenerator;

import com.teammetallurgy.atum.blocks.wood.AtumTorchUnlitBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStatesGenerator
extends BlockStateProvider {
    public BlockStatesGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "atum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.generateTorch(AtumBlocks.PALM_TORCH);
        this.generateTorch(AtumBlocks.DEADWOOD_TORCH);
        this.generateTorch(AtumBlocks.LIMESTONE_TORCH);
        this.generateTorch(AtumBlocks.BONE_TORCH);
        this.generateTorch(AtumBlocks.PHARAOH_TORCH);
    }

    private void generateTorch(Block torch) {
        String torchName = torch.getRegistryName().func_110623_a();
        this.simpleBlock(torch, (ModelFile)this.models().torch(torchName, new ResourceLocation("atum", "block/" + torchName)));
        this.simpleBlock(AtumTorchUnlitBlock.UNLIT.get(torch), (ModelFile)this.models().torch(torchName + "_unlit", new ResourceLocation("atum", "block/" + torchName + "_unlit")));
        this.horizontalBlock((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("atum", "wall_" + torchName)), (ModelFile)this.models().torchWall("wall_" + torchName, new ResourceLocation("atum", "block/" + torchName)), 90);
        this.horizontalBlock((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("atum", "wall_" + torchName + "_unlit")), (ModelFile)this.models().torchWall("wall_" + torchName + "_unlit", new ResourceLocation("atum", "block/" + torchName + "_unlit")), 90);
    }
}

