/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.items.artifacts.atum.EyesOfAtumItem;
import com.teammetallurgy.atum.items.artifacts.nuit.NuitsVanishingItem;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.dimension.AtumDimension;
import com.teammetallurgy.atum.world.dimension.AtumDimensionType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum", value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation MUMMY_BLUR_TEXTURE = new ResourceLocation("atum", "textures/hud/mummyblur.png");
    private static final ResourceLocation SAND_BLUR_TEXTURE = new ResourceLocation("atum", "textures/hud/sandstormwip.png");
    private static float intensity = 1.0f;

    @SubscribeEvent
    public static void renderlast(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_71093_bK.func_186068_a() == AtumDimensionType.ATUM.func_186068_a()) {
            if (Minecraft.func_71410_x().field_71474_y.field_74319_N) {
                ClientEvents.renderSand(event.getPartialTicks(), 1, 2, 3, 4, 5, 6);
            } else {
                ClientEvents.renderSand(event.getPartialTicks(), 1, 2, 3, 4, 5, 6);
            }
        }
    }

    private static void renderSand(float partialTicks, int ... layers) {
        float baseDarkness = (float)((Integer)AtumConfig.SANDSTORM.sandDarkness.get()).intValue() / 100.0f;
        float baseAlpha = (float)((Integer)AtumConfig.SANDSTORM.sandAlpha.get()).intValue() / 100.0f;
        float eyesOfAtumAlpha = (float)((Integer)AtumConfig.SANDSTORM.sandEyesAlpha.get()).intValue() / 100.0f;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        Dimension dimension = player.field_70170_p.func_201675_m();
        if (dimension instanceof AtumDimension && player.field_71093_bK.func_186068_a() == AtumDimensionType.ATUM.func_186068_a() && mc.field_71441_e != null) {
            AtumDimension atum = (AtumDimension)dimension;
            ClientWorld world = mc.field_71441_e;
            float stormStrength = atum.stormStrength;
            if (stormStrength < 1.0E-4f) {
                return;
            }
            float light = ClientEvents.getSunBrightness(dimension, (World)world, partialTicks);
            RenderSystem.pushMatrix();
            RenderSystem.pushTextureAttributes();
            RenderSystem.matrixMode((int)5889);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)mc.func_228018_at_().func_198107_o(), (double)mc.func_228018_at_().func_198087_p(), (double)0.0, (double)1000.0, (double)3000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.disableAlphaTest();
            mc.func_110434_K().func_110577_a(SAND_BLUR_TEXTURE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            BlockPos playerPos = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            boolean sky = player.field_70170_p.func_175710_j(playerPos);
            if (!sky || player.field_70170_p.func_226691_t_(playerPos) == AtumBiomes.OASIS) {
                intensity -= 0.001f * partialTicks;
                intensity = Math.max(0.0f, intensity);
            } else {
                intensity += 0.01f * partialTicks;
                intensity = Math.min(stormStrength, intensity);
            }
            for (int i : layers) {
                float scale = 0.2f / (float)i;
                float alpha = (float)Math.pow(intensity - baseAlpha, i) * intensity;
                ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
                if (helmet.func_77973_b() instanceof EyesOfAtumItem) {
                    alpha *= eyesOfAtumAlpha;
                }
                RenderSystem.color4f((float)(baseDarkness * light), (float)(baseDarkness * light), (float)(baseDarkness * light), (float)alpha);
                double scaleX = (double)(0.01f * (float)mc.func_228018_at_().func_198087_p() * scale) * mc.func_228018_at_().func_198100_s();
                double scaleY = (double)(0.01f * (float)mc.func_228018_at_().func_198107_o() * scale) * mc.func_228018_at_().func_198100_s();
                float speed = 500.0f - (float)(i * 15);
                float movement = (float)(-(System.currentTimeMillis() % (long)((int)speed))) / speed;
                float yaw = 0.25f * (player.field_70177_z % 360.0f / 360.0f) / scale;
                float pitch = 0.5f * (player.field_70125_A % 360.0f / 360.0f) / scale;
                bufferbuilder.func_225582_a_(0.0, (double)mc.func_228018_at_().func_198087_p(), 90.0).func_225583_a_(movement + yaw, (float)(1.0 / scaleY + (double)pitch)).func_181675_d();
                bufferbuilder.func_225582_a_((double)mc.func_228018_at_().func_198107_o(), (double)mc.func_228018_at_().func_198087_p(), 90.0).func_225583_a_((float)(1.0 / scaleX + (double)movement + (double)yaw), (float)(1.0 / scaleY + (double)pitch)).func_181675_d();
                bufferbuilder.func_225582_a_((double)mc.func_228018_at_().func_198107_o(), 0.0, 90.0).func_225583_a_((float)(1.0 / scaleX + (double)movement + (double)yaw), 0.0f + pitch).func_181675_d();
                bufferbuilder.func_225582_a_(0.0, 0.0, 90.0).func_225583_a_(movement + yaw, 0.0f + pitch).func_181675_d();
            }
            tessellator.func_78381_a();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.enableAlphaTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.popMatrix();
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
            RenderSystem.popAttributes();
            RenderSystem.popMatrix();
        }
    }

    public static float getSunBrightness(Dimension dimension, World world, float partialTicks) {
        float celestialAngle = dimension.func_76563_a(world.func_72820_D(), partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(world.func_72867_j(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(world.func_72819_i(partialTicks) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    @SubscribeEvent
    public static void renderFog(EntityViewRenderEvent.RenderFogEvent event) {
        float sandstormFog = ((Integer)AtumConfig.SANDSTORM.sandstormFog.get()).intValue();
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayer == null) {
            return;
        }
        Dimension dimension = clientPlayer.field_70170_p.field_73011_w;
        Entity entity = event.getInfo().func_216773_g();
        if (dimension instanceof AtumDimension && entity.field_71093_bK.func_186068_a() == AtumDimensionType.ATUM.func_186068_a() && ((Boolean)AtumConfig.GENERAL.fogEnabled.get()).booleanValue()) {
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            float fogDensity = 0.08f;
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
                if (player.func_180425_c().func_177956_o() <= 60) {
                    fogDensity += (float)(62 - player.func_180425_c().func_177956_o()) * 0.005f;
                }
                if (helmet.func_77973_b() instanceof EyesOfAtumItem) {
                    fogDensity /= 3.0f;
                }
                if (helmet.func_77973_b() == AtumItems.WANDERER_HELMET || helmet.func_77973_b() == AtumItems.DESERT_HELMET_IRON || helmet.func_77973_b() == AtumItems.DESERT_HELMET_GOLD || helmet.func_77973_b() == AtumItems.DESERT_HELMET_DIAMOND) {
                    fogDensity /= 1.5f;
                }
                if (player.func_226278_cu_() >= (double)(player.field_70170_p.func_181545_F() - 8)) {
                    AtumDimension providerAtum = (AtumDimension)dimension;
                    fogDensity *= 1.0f + sandstormFog - (sandstormFog - sandstormFog * providerAtum.stormStrength);
                }
                RenderSystem.fogDensity((float)fogDensity);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public static void onRender(RenderPlayerEvent.Pre event) {
        PlayerEntity player;
        Hand hand = (player = event.getPlayer()).func_184586_b(Hand.OFF_HAND).func_77973_b() == AtumItems.NUITS_VANISHING ? Hand.OFF_HAND : Hand.MAIN_HAND;
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == AtumItems.NUITS_VANISHING && !NuitsVanishingItem.isPlayerMoving(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderMummyHelmet(RenderGameOverlayEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Minecraft mc = Minecraft.func_71410_x();
        if (player != null && mc.field_71474_y.field_74320_O == 0 && event.getType() == RenderGameOverlayEvent.ElementType.HELMET && player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == AtumItems.MUMMY_HELMET) {
            int width = mc.func_228018_at_().func_198107_o();
            int height = mc.func_228018_at_().func_198087_p();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableAlphaTest();
            mc.func_110434_K().func_110577_a(MUMMY_BLUR_TEXTURE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_225582_a_(0.0, (double)height, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)width, (double)height, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)width, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.enableAlphaTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

