/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.network.packet;

import com.teammetallurgy.atum.world.dimension.AtumDimension;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.dimension.Dimension;
import net.minecraftforge.fml.network.NetworkEvent;

public class WeatherPacket {
    private final boolean isStorming;
    private final int stormTime;

    public WeatherPacket(boolean isStorming, int stormTime) {
        this.isStorming = isStorming;
        this.stormTime = stormTime;
    }

    public static void encode(WeatherPacket packet, PacketBuffer buf) {
        buf.writeBoolean(packet.isStorming);
        buf.writeInt(packet.stormTime);
    }

    public static WeatherPacket decode(PacketBuffer buf) {
        return new WeatherPacket(buf.readBoolean(), buf.readInt());
    }

    public static class Handler {
        public static void handle(WeatherPacket message, Supplier<NetworkEvent.Context> ctx) {
            Dimension dimension = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w;
            if (dimension instanceof AtumDimension) {
                AtumDimension providerAtum = (AtumDimension)dimension;
                AtumDimension.DATA.setStorming(message.isStorming);
                providerAtum.stormTime = message.stormTime;
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

