/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen;

import com.teammetallurgy.atum.init.AtumFeatures;
import com.teammetallurgy.atum.world.gen.AtumGenSettings;
import com.teammetallurgy.atum.world.spawner.BanditPatrolSpawner;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.server.ServerWorld;

public class AtumChunkGenerator
extends NoiseChunkGenerator<AtumGenSettings> {
    private static final float[] BIOME_WEIGHTS = (float[])Util.func_200696_a((Object)new float[25], weights -> {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                float weight;
                weights[x + 2 + (z + 2) * 5] = weight = 10.0f / MathHelper.func_76129_c((float)((float)(x * x + z * z) + 0.2f));
            }
        }
    });
    private final OctavesNoiseGenerator depthNoise;
    private final BanditPatrolSpawner banditSpawner = new BanditPatrolSpawner();

    public AtumChunkGenerator(IWorld world, BiomeProvider biomeProvider, AtumGenSettings settings) {
        super(world, biomeProvider, 4, 8, 256, (GenerationSettings)settings, true);
        this.depthNoise = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);
    }

    public IWorld getWorld() {
        return this.field_222540_a;
    }

    @Nonnull
    protected double[] func_222549_a(int noiseX, int noiseZ) {
        double[] noise = new double[2];
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int seaLevel = this.func_222530_f();
        float biomeNoise = this.field_222542_c.func_225526_b_(noiseX, seaLevel, noiseZ).func_185355_j();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                Biome biome = this.field_222542_c.func_225526_b_(noiseX + x, seaLevel, noiseZ + z);
                float depth = biome.func_185355_j();
                float scale = biome.func_185360_m();
                float weight = BIOME_WEIGHTS[x + 2 + (z + 2) * 5] / (depth + 2.0f);
                if (biome.func_185355_j() > biomeNoise) {
                    weight /= 2.0f;
                }
                f += scale * weight;
                f1 += depth * weight;
                f2 += weight;
            }
        }
        f /= f2;
        f1 /= f2;
        f = f * 0.9f + 0.1f;
        f1 = (f1 * 4.0f - 1.0f) / 8.0f;
        noise[0] = (double)f1 + this.getNoiseDepthAt(noiseX, noiseZ);
        noise[1] = f;
        return noise;
    }

    private double getNoiseDepthAt(int x, int z) {
        double depth = this.depthNoise.func_215462_a((double)(x * 200), 10.0, (double)(z * 200), 1.0, 0.0, true) * 65535.0 / 8000.0;
        if (depth < 0.0) {
            depth = -depth * 0.3;
        }
        if ((depth = depth * 3.0 - 2.0) < 0.0) {
            depth /= 28.0;
        } else {
            if (depth > 1.0) {
                depth = 1.0;
            }
            depth /= 40.0;
        }
        return depth;
    }

    protected double func_222545_a(double depth, double scale, int yy) {
        double baseSize = 8.5;
        double yOffset = ((double)yy - (baseSize + depth * baseSize / 8.0 * 4.0)) * 12.0 * 128.0 / 256.0 / scale;
        if (yOffset < 0.0) {
            yOffset *= 4.0;
        }
        return yOffset;
    }

    protected void func_222548_a(@Nonnull double[] noiseColumn, int noiseX, int noiseZ) {
        double xzScale = 684.412f;
        double yScale = 684.412f;
        double xzOtherScale = 8.555149841308594;
        double yOtherScale = 4.277574920654297;
        this.func_222546_a(noiseColumn, noiseX, noiseZ, xzScale, yScale, xzOtherScale, yOtherScale, 3, -10);
    }

    public int func_205470_d() {
        return 64;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EntityClassification type, @Nonnull BlockPos pos) {
        if (AtumFeatures.LIGHTHOUSE.func_175796_a(this.field_222540_a, pos) && type == EntityClassification.AMBIENT) {
            return AtumFeatures.LIGHTHOUSE.func_202279_e();
        }
        return super.func_177458_a(type, pos);
    }

    public void func_203222_a(@Nonnull ServerWorld serverWorld, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        this.banditSpawner.tick(serverWorld, spawnHostileMobs);
    }
}

