/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import com.teammetallurgy.atum.blocks.vegetation.DateBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.gen.feature.config.PalmConfig;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.VineBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class PalmFeature
extends AbstractSmallTreeFeature<PalmConfig> {
    public PalmFeature(Function<Dynamic<?>, ? extends PalmConfig> dynamicFunction) {
        super(dynamicFunction);
    }

    protected boolean place(@Nonnull IWorldGenerationReader genReader, Random rand, @Nonnull BlockPos pos, @Nonnull Set<BlockPos> logs, @Nonnull Set<BlockPos> leaves, @Nonnull MutableBoundingBox mutableBox, PalmConfig config) {
        int foliagePlacer;
        int trunkHeight;
        int baseHeight = config.field_227371_p_ + rand.nextInt(config.field_227328_b_ + 1) + rand.nextInt(config.field_227329_c_ + 1);
        Optional<BlockPos> optional = this.func_227212_a_(genReader, baseHeight, trunkHeight = config.field_227330_d_ >= 0 ? config.field_227330_d_ + rand.nextInt(config.field_227331_f_ + 1) : baseHeight - (config.field_227334_i_ + rand.nextInt(config.field_227335_j_ + 1)), foliagePlacer = config.field_227327_a_.func_225573_a_(rand, trunkHeight, baseHeight, (TreeFeatureConfig)config), pos, config);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos posOptional = optional.get();
        this.setFertileSoilAt(genReader, posOptional.func_177977_b(), posOptional);
        int height = baseHeight - rand.nextInt(4) - 1;
        int i1 = 3 - rand.nextInt(3);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        int x = posOptional.func_177958_n();
        int z = posOptional.func_177952_p();
        int y = 0;
        for (int h = 0; h < baseHeight; ++h) {
            int treeHeight = posOptional.func_177956_o() + h;
            if (h >= height && i1 > 0) {
                --i1;
            }
            if (!this.func_227216_a_(genReader, rand, (BlockPos)mutablePos.func_181079_c(x, treeHeight, z), logs, mutableBox, (BaseTreeFeatureConfig)config)) continue;
            y = treeHeight;
        }
        BlockPos leafPos = new BlockPos(x, y, z);
        this.generateLeaf(genReader, leafPos.func_177984_a(), rand, config);
        for (BlockPos baseLeafPos : BlockPos.Mutable.func_218278_a((BlockPos)leafPos.func_177982_a(-1, 0, -1), (BlockPos)leafPos.func_177982_a(1, 0, 1))) {
            this.generateLeaf(genReader, baseLeafPos, rand, config);
        }
        this.generateLeaf(genReader, leafPos.func_177982_a(2, 0, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(-2, 0, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, 0, 2), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, 0, -2), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, -1, -2), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, -1, 2), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(2, -1, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(-2, -1, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, -1, -3), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, -1, 3), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(3, -1, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(-3, -1, 0), rand, config);
        if (config.dateChance > 0.0) {
            BlockPos datePos = leafPos.func_177977_b().func_177972_a(Direction.Plane.HORIZONTAL.func_179518_a(rand));
            if (rand.nextDouble() <= config.dateChance) {
                genReader.func_180501_a(datePos, (BlockState)AtumBlocks.DATE_BLOCK.func_176223_P().func_206870_a((IProperty)DateBlock.AGE, (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)rand, (int)0, (int)7))), 2);
                if (rand.nextDouble() <= 0.25) {
                    datePos = leafPos.func_177977_b().func_177972_a(Direction.Plane.HORIZONTAL.func_179518_a(rand));
                    genReader.func_180501_a(datePos, (BlockState)AtumBlocks.DATE_BLOCK.func_176223_P().func_206870_a((IProperty)DateBlock.AGE, (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)rand, (int)0, (int)7))), 2);
                }
            }
        }
        if (config.ophidianTongueChance > 0.0 && rand.nextDouble() <= config.ophidianTongueChance) {
            BlockPos genPos;
            HashSet set = Sets.newHashSet();
            if (rand.nextInt(4) == 0 && AbstractTreeFeature.func_214574_b((IWorldGenerationBaseReader)genReader, (BlockPos)(genPos = pos.func_177976_e()))) {
                this.addOphidianTongueToTree(genReader, genPos, VineBlock.field_176278_M, set, mutableBox);
            }
            if (rand.nextInt(4) == 0 && AbstractTreeFeature.func_214574_b((IWorldGenerationBaseReader)genReader, (BlockPos)(genPos = pos.func_177974_f()))) {
                this.addOphidianTongueToTree(genReader, genPos, VineBlock.field_176280_O, set, mutableBox);
            }
            if (rand.nextInt(4) == 0 && AbstractTreeFeature.func_214574_b((IWorldGenerationBaseReader)genReader, (BlockPos)(genPos = pos.func_177978_c()))) {
                this.addOphidianTongueToTree(genReader, genPos, VineBlock.field_176279_N, set, mutableBox);
            }
            if (rand.nextInt(4) == 0 && AbstractTreeFeature.func_214574_b((IWorldGenerationBaseReader)genReader, (BlockPos)(genPos = pos.func_177968_d()))) {
                this.addOphidianTongueToTree(genReader, genPos, VineBlock.field_176273_b, set, mutableBox);
            }
        }
        return true;
    }

    @Nonnull
    public Optional<BlockPos> func_227212_a_(@Nonnull IWorldGenerationReader genReader, int baseHeight, int trunkHeight, int foliagePlacer, BlockPos pos, TreeFeatureConfig config) {
        BlockPos blockpos;
        if (!config.field_227372_q_) {
            int i = genReader.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos).func_177956_o();
            int j = genReader.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o();
            blockpos = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            if (j - i > config.field_227336_k_) {
                return Optional.empty();
            }
        } else {
            blockpos = pos;
        }
        if (blockpos.func_177956_o() >= 1 && blockpos.func_177956_o() + baseHeight + 1 <= genReader.getMaxHeight()) {
            for (int i1 = 0; i1 <= baseHeight + 1; ++i1) {
                int j1 = config.field_227327_a_.func_225570_a_(trunkHeight, baseHeight, foliagePlacer, i1);
                BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                for (int k = -j1; k <= j1; ++k) {
                    for (int l = -j1; l <= j1; ++l) {
                        if (i1 + blockpos.func_177956_o() >= 0 && i1 + blockpos.func_177956_o() < genReader.getMaxHeight()) {
                            blockpos$mutable.func_181079_c(k + blockpos.func_177958_n(), i1 + blockpos.func_177956_o(), l + blockpos.func_177952_p());
                            if (PalmFeature.func_214587_a((IWorldGenerationBaseReader)genReader, (BlockPos)blockpos$mutable) && (config.field_227337_l_ || !PalmFeature.func_227222_d_((IWorldGenerationBaseReader)genReader, (BlockPos)blockpos$mutable))) {
                                continue;
                            }
                            return Optional.empty();
                        }
                        return Optional.empty();
                    }
                }
            }
            return PalmFeature.isSoilOrFarm((IWorldGenerationBaseReader)genReader, blockpos.func_177977_b(), config.getSapling()) && blockpos.func_177956_o() < genReader.getMaxHeight() - baseHeight - 1 ? Optional.of(blockpos) : Optional.empty();
        }
        return Optional.empty();
    }

    protected static boolean isSoilOrFarm(IWorldGenerationBaseReader reader, @Nonnull BlockPos pos, IPlantable sapling) {
        if (!(reader instanceof IBlockReader) || sapling == null) {
            return PalmFeature.func_214585_i((IWorldGenerationBaseReader)reader, (BlockPos)pos) || reader.func_217375_a(pos, state -> state.func_177230_c() == AtumBlocks.LIMESTONE_GRAVEL);
        }
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, sapling));
    }

    protected void setFertileSoilAt(IWorldGenerationReader reader, BlockPos pos, BlockPos origin) {
        if (!(reader instanceof IWorld)) {
            this.setFertileSoil(reader, pos);
            return;
        }
        ((IWorld)reader).func_180495_p(pos).onPlantGrow((IWorld)reader, pos, origin);
    }

    protected void setFertileSoil(IWorldGenerationReader genReader, BlockPos pos) {
        if (!PalmFeature.isFertileSoil((IWorldGenerationBaseReader)genReader, pos)) {
            this.func_202278_a((IWorldWriter)genReader, pos, AtumBlocks.FERTILE_SOIL.func_176223_P());
        }
    }

    protected static boolean isFertileSoil(IWorldGenerationBaseReader genReader, BlockPos pos) {
        return genReader.func_217375_a(pos, p -> p.func_177230_c() != AtumBlocks.FERTILE_SOIL);
    }

    private void generateLeaf(IWorldGenerationReader genReader, BlockPos pos, Random rand, PalmConfig config) {
        if (AbstractTreeFeature.func_214572_g((IWorldGenerationBaseReader)genReader, (BlockPos)pos)) {
            genReader.func_180501_a(pos, config.field_227369_n_.func_225574_a_(rand, pos), 19);
        }
    }

    private void addOphidianTongueToTree(IWorldGenerationReader genReader, BlockPos pos, BooleanProperty booleanProperty, Set<BlockPos> positions, MutableBoundingBox mutableBox) {
        this.generateOphidianTongue((IWorldWriter)genReader, pos, booleanProperty, positions, mutableBox);
        pos = pos.func_177977_b();
        for (int i = 4; AbstractTreeFeature.func_214574_b((IWorldGenerationBaseReader)genReader, (BlockPos)pos) && i > 0; --i) {
            this.generateOphidianTongue((IWorldWriter)genReader, pos, booleanProperty, positions, mutableBox);
            pos = pos.func_177977_b();
        }
    }

    protected void generateOphidianTongue(IWorldWriter world, BlockPos pos, BooleanProperty booleanProperty, Set<BlockPos> positions, MutableBoundingBox mutableBox) {
        this.setOphidianTongue(world, pos, (BlockState)AtumBlocks.OPHIDIAN_TONGUE.func_176223_P().func_206870_a((IProperty)booleanProperty, (Comparable)Boolean.valueOf(true)), positions, mutableBox);
    }

    protected void setOphidianTongue(IWorldWriter worldWriter, BlockPos pos, BlockState state, Set<BlockPos> positions, MutableBoundingBox mutableBox) {
        worldWriter.func_180501_a(pos, state, 19);
        positions.add(pos);
        mutableBox.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
    }
}

