/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.mineshaft;

import com.mojang.datafixers.Dynamic;
import com.teammetallurgy.atum.init.AtumFeatures;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.AtumMineshaftConfig;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.AtumMineshaftPieces;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class AtumMineshaftStructure
extends Structure<AtumMineshaftConfig> {
    public AtumMineshaftStructure(Function<Dynamic<?>, ? extends AtumMineshaftConfig> config) {
        super(config);
    }

    public boolean func_225558_a_(@Nonnull BiomeManager biomeManager, ChunkGenerator<?> generator, @Nonnull Random rand, int chunkX, int chunkZ, @Nonnull Biome biome) {
        ((SharedSeedRandom)rand).func_202425_c(generator.func_202089_c(), chunkX, chunkZ);
        if (generator.func_202094_a(biome, (Structure)this)) {
            AtumMineshaftConfig config = (AtumMineshaftConfig)generator.func_202087_b(biome, (Structure)this);
            if (config != null) {
                double probability = config.probability;
                return rand.nextDouble() < probability;
            }
            return false;
        }
        return false;
    }

    public boolean place(@Nonnull IWorld world, @Nonnull ChunkGenerator<? extends GenerationSettings> generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull AtumMineshaftConfig config) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (StructureHelper.doesChunkHaveStructure(world, chunkPos.field_77276_a, chunkPos.field_77275_b, AtumFeatures.PYRAMID)) {
            return false;
        }
        return super.func_212245_a(world, generator, rand, pos, (IFeatureConfig)config);
    }

    @Nonnull
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Nonnull
    public String func_143025_a() {
        return String.valueOf(new ResourceLocation("atum", "mineshaft"));
    }

    public int func_202367_b() {
        return 8;
    }

    public static enum Type {
        DEADWOOD("deadwood", false),
        LIMESTONE("limestone", false),
        DEADWOOD_SURFACE("deadwood_surface", true),
        LIMESTONE_SURFACE("limestone_surface", true);

        private static final Map<String, Type> BY_NAME;
        private final String name;
        private final boolean isSurface;

        private Type(String name, boolean isSurface) {
            this.name = name;
            this.isSurface = isSurface;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSurface() {
            return this.isSurface;
        }

        public static Type byName(String name) {
            return BY_NAME.get(name);
        }

        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : DEADWOOD;
        }

        static {
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, type -> type));
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int chunkPosX, int chunkPosZ, MutableBoundingBox box, int references, long seed) {
            super(structure, chunkPosX, chunkPosZ, box, references, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, @Nonnull TemplateManager manager, int chunkX, int chunkZ, @Nonnull Biome biome) {
            AtumMineshaftConfig config = (AtumMineshaftConfig)generator.func_202087_b(biome, AtumFeatures.MINESHAFT);
            if (config != null) {
                AtumMineshaftPieces.Room room = new AtumMineshaftPieces.Room(0, (Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2, config.type);
                this.field_75075_a.add(room);
                room.func_74861_a(room, this.field_75075_a, (Random)this.field_214631_d);
                this.func_202500_a();
                if (config.type.isSurface()) {
                    int y = generator.func_222530_f() - this.field_75074_b.field_78894_e + this.field_75074_b.func_78882_c() / 2 - -5;
                    this.field_75074_b.func_78886_a(0, y, 0);
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        structurepiece.func_181138_a(0, y, 0);
                    }
                } else {
                    this.func_214628_a(generator.func_222530_f(), (Random)this.field_214631_d, 10);
                }
            }
        }
    }
}

