/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.tomb;

import com.mojang.datafixers.Dynamic;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import com.teammetallurgy.atum.world.gen.structure.tomb.TombPieces;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class TombStructure
extends Structure<NoFeatureConfig> {
    public TombStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    @Nonnull
    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int spacing = 13;
        int separation = 11;
        int k = x + spacing * spacingOffsetsX;
        int l = z + spacing * spacingOffsetsZ;
        int i1 = k < 0 ? k - spacing + 1 : k;
        int j1 = l < 0 ? l - spacing + 1 : l;
        int k1 = i1 / spacing;
        int l1 = j1 / spacing;
        ((SharedSeedRandom)random).func_202425_c(chunkGenerator.func_202089_c(), k1, l1);
        k1 *= spacing;
        l1 *= spacing;
        return new ChunkPos(k1 += (random.nextInt(spacing - separation) + random.nextInt(spacing - separation)) / 2, l1 += (random.nextInt(spacing - separation) + random.nextInt(spacing - separation)) / 2);
    }

    public boolean func_225558_a_(@Nonnull BiomeManager manager, @Nonnull ChunkGenerator<?> generator, @Nonnull Random rand, int chunkX, int chunkZ, @Nonnull Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(generator, rand, chunkX, chunkZ, 0, 0);
        if (chunkX == chunkpos.field_77276_a && chunkZ == chunkpos.field_77275_b) {
            if (!generator.func_202094_a(biome, (Structure)this)) {
                return false;
            }
            return StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, null) <= 55;
        }
        return false;
    }

    @Nonnull
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Nonnull
    public String func_143025_a() {
        return String.valueOf(TombPieces.TOMB);
    }

    public int func_202367_b() {
        return 1;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int chunkPosX, int chunkPosZ, MutableBoundingBox box, int references, long seed) {
            super(structure, chunkPosX, chunkPosZ, box, references, seed);
        }

        public void func_214625_a(@Nonnull ChunkGenerator<?> generator, @Nonnull TemplateManager manager, int chunkX, int chunkZ, @Nonnull Biome biome) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int y = MathHelper.func_76136_a((Random)this.field_214631_d, (int)6, (int)55);
            BlockPos pos = new BlockPos(chunkX * 16 + 8, y, chunkZ * 16 + 8);
            if (y < 60) {
                TombPieces.TombTemplate tomb = new TombPieces.TombTemplate(manager, pos, rotation);
                this.field_75075_a.add(tomb);
                this.func_202500_a();
            }
        }
    }
}

