/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.teleporter;

import com.teammetallurgy.atum.init.AtumFeatures;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.dimension.AtumDimension;
import com.teammetallurgy.atum.world.dimension.AtumDimensionType;
import com.teammetallurgy.atum.world.teleporter.TeleporterAtum;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class TeleporterAtumStart
implements ITeleporter {
    private static WorldSettings worldSettings;

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        if (!AtumDimension.DATA.hasStartStructureSpawned()) {
            this.onAtumJoining(destWorld, entity, yaw);
            AtumDimension.DATA.setHasStartStructureSpawned(true);
            return repositionEntity.apply(false);
        }
        return entity;
    }

    private void onAtumJoining(ServerWorld world, Entity entity, float yaw) {
        if (world.field_73011_w.func_186058_p() == AtumDimensionType.ATUM) {
            BlockPos spawnPos = new BlockPos(world.func_72912_H().func_76079_c(), world.func_72912_H().func_76075_d(), world.func_72912_H().func_76074_e());
            if (((Boolean)AtumConfig.ATUM_START.startInAtumPortal.get()).booleanValue()) {
                TeleporterAtum.makePortal(world, entity);
                TeleporterAtum.placeInPortal(world, entity, yaw);
            } else {
                entity.field_70177_z = yaw;
                entity.func_225653_b_((double)spawnPos.func_177958_n(), (double)(spawnPos.func_177956_o() + 1), (double)spawnPos.func_177952_p());
            }
            if (((Boolean)AtumConfig.ATUM_START.startInAtumPortal.get()).booleanValue()) {
                spawnPos = spawnPos.func_177982_a(4, 0, 4);
            }
            if (!((String)AtumConfig.ATUM_START.atumStartStructure.get()).isEmpty()) {
                ConfiguredFeature startStructure = AtumFeatures.START_STRUCTURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
                startStructure.func_222734_a((IWorld)world, world.func_72863_F().func_201711_g(), world.field_73012_v, spawnPos);
            }
            if (worldSettings != null && worldSettings.func_77167_c()) {
                ConfiguredFeature bonusCrate = AtumFeatures.BONUS_CRATE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
                bonusCrate.func_222734_a((IWorld)world, world.func_72863_F().func_201711_g(), world.field_73012_v, spawnPos);
            }
        }
    }

    @SubscribeEvent
    public static void onCreateSpawnPos(WorldEvent.CreateSpawnPosition event) {
        worldSettings = event.getSettings();
    }
}

