/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.handler;

import hellfirepvp.astralsorcery.client.effect.EffectProperties;
import hellfirepvp.astralsorcery.client.effect.EffectType;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.effect.handler.EffectRegistrar;
import hellfirepvp.astralsorcery.client.effect.source.FXSource;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.Vec3i;

public final class EffectHelper {
    public static <T extends EntityVisualFX, C extends BatchRenderContext<T>> void refresh(T vfx, C context) {
        EffectHelper.refresh(vfx, EffectHelper.of(context));
    }

    public static <T extends EntityVisualFX> void refresh(T vfx, EffectProperties<T> properties) {
        if (vfx.isRemoved()) {
            EffectRegistrar.registerFX(vfx, properties);
        }
    }

    public static <T extends EntityVisualFX, C extends BatchRenderContext<T>> Builder<T> of(C ctx) {
        return new Builder(ctx);
    }

    public static <E extends EntityVisualFX, T extends BatchRenderContext<E>, S extends FXSource<E, T>> S spawnSource(S src) {
        return EffectRegistrar.registerSource(src);
    }

    public static class Builder<T extends EntityVisualFX>
    extends EffectProperties<T> {
        public Builder(BatchRenderContext<T> ctx) {
            super(ctx);
        }

        @Override
        public Builder<T> setOwner(@Nullable UUID owner) {
            return (Builder)super.setOwner(owner);
        }

        @Override
        public Builder<T> setType(@Nullable EffectType type) {
            return (Builder)super.setType(type);
        }

        @Override
        public Builder<T> setPosition(@Nonnull Vec3i position) {
            return (Builder)super.setPosition(position);
        }

        @Override
        public Builder<T> setIgnoreLimit(boolean ignoreLimit) {
            return (Builder)super.setIgnoreLimit(ignoreLimit);
        }

        public T spawn(@Nonnull Vector3 spawnPos) {
            this.setPosition((Vec3i)spawnPos.toBlockPos());
            return EffectRegistrar.registerFX(this.getContext().makeParticle(spawnPos), this);
        }
    }
}

