/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.vfx;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.util.math.MathHelper;

public class FXLightning
extends EntityVisualFX {
    private static final float optimalLightningLength = 7.0f;
    private static final float growSpeed = 0.09f;
    private static final float fadeTime = 0.03f;
    private static final float defaultMinJitterDst = 0.2f;
    private static final float defaultMaxJitterDst = 0.7f;
    private static final float defaultForkChance = 1.0f;
    private static final float defaultMinForkAngleDeg = 15.0f;
    private static final float defaultMaxForkAngleDeg = 35.0f;
    private LightningVertex root = null;
    private float buildSpeed = 0.2f;
    private float buildWaitTime = 0.01f;
    private float bufRenderDepth = -1.0f;

    public FXLightning(Vector3 pos) {
        super(pos);
    }

    public FXLightning setBuildSpeed(float buildSpeed) {
        this.buildSpeed = buildSpeed;
        return this;
    }

    public FXLightning setBuildWaitTime(float buildWaitTime) {
        this.buildWaitTime = buildWaitTime;
        return this;
    }

    public FXLightning makeDefault(Vector3 to) {
        double dstLength = to.clone().subtract(this.getPosition()).length();
        float perc = 1.0f;
        if (dstLength > 7.0) {
            perc = MathHelper.func_76133_a((double)(dstLength / 7.0));
        } else if (dstLength < 7.0) {
            perc = (float)Math.pow(dstLength / 7.0, 2.0);
        }
        this.make(rand.nextLong(), this.getPosition(), to, 0.2f * perc, 0.7f * perc, 1.0f, 15.0f, 35.0f);
        this.setBuildSpeed(Math.max(0.01f, 0.09f * perc));
        this.setBuildWaitTime(Math.max(0.0067f, 0.03f * perc));
        return this;
    }

    private void make(long seed, Vector3 source, Vector3 destination, float minJitterDistance, float maxJitterDistance, float forkChance, float minForkAngle, float maxForkAngle) {
        Vector3 directionVector = destination.clone().subtract(source);
        Random lightningSeed = new Random(seed);
        LinkedList<LightningVertex> rootVertices = Lists.newLinkedList();
        this.root = new LightningVertex(source);
        this.root.next.add(new LightningVertex(destination));
        rootVertices.add(this.root);
        double l = directionVector.length();
        int iterations = Math.min(MathHelper.func_76141_d((float)Math.round(Math.sqrt(l))), 200);
        for (int i = 0; i < iterations; ++i) {
            LinkedList<LightningVertex> newRootVertices = new LinkedList<LightningVertex>();
            for (LightningVertex sourceVertex : rootVertices) {
                LinkedList<LightningVertex> newNext = new LinkedList<LightningVertex>();
                for (LightningVertex nextVertex : Lists.newArrayList((Iterable)sourceVertex.next)) {
                    Vector3 direction = nextVertex.offset.clone().subtract(sourceVertex.offset);
                    Vector3 split = direction.clone().multiply(0.5f).add(sourceVertex.offset);
                    float jitDst = (minJitterDistance + (maxJitterDistance - minJitterDistance) * lightningSeed.nextFloat()) * ((float)(iterations - i) / (float)iterations);
                    Vector3 axPerp = direction.clone().perpendicular().rotate((double)(lightningSeed.nextFloat() * 2.0f) * Math.PI, direction).normalize().multiply(jitDst);
                    split.add(axPerp);
                    LightningVertex newVertex = new LightningVertex(split);
                    newVertex.next.add(nextVertex);
                    newNext.add(newVertex);
                    if (lightningSeed.nextFloat() < forkChance) {
                        Vector3 dirFork = split.clone().subtract(sourceVertex.offset);
                        float forkAngle = minForkAngle + (maxForkAngle - minForkAngle) * lightningSeed.nextFloat();
                        forkAngle = (float)Math.toRadians(forkAngle);
                        Vector3 perpAxis = dirFork.clone().perpendicular().rotate((double)(lightningSeed.nextFloat() * 2.0f) * Math.PI, dirFork);
                        Vector3 dirPos = dirFork.clone().rotate(forkAngle, perpAxis).normalize().multiply(dirFork.length() * 3.0 / 4.0).add(split);
                        LightningVertex forkVertex = new LightningVertex(dirPos);
                        newVertex.next.add(forkVertex);
                    }
                    newRootVertices.add(newVertex);
                }
                sourceVertex.next = newNext;
                newRootVertices.add(sourceVertex);
            }
            rootVertices = newRootVertices;
        }
    }

    @Override
    public <T extends EntityVisualFX> void render(BatchRenderContext<T> ctx, MatrixStack renderStack, IVertexBuilder vb, float pTicks) {
        if (this.root == null) {
            return;
        }
        Color c = this.getColor(pTicks);
        this.bufRenderDepth = Math.min(1.0f, ((float)this.age + pTicks) / (this.buildSpeed * 20.0f));
        this.renderRec(this.root, vb, renderStack, pTicks, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
    }

    private void renderRec(LightningVertex root, IVertexBuilder vb, MatrixStack renderStack, float pTicks, float r, float g, float b) {
        int allDepth = root.followingDepth;
        boolean mayRenderNext = 1.0f - (float)root.followingDepth / (float)allDepth <= this.bufRenderDepth;
        Vector3 playerOffset = RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks);
        for (LightningVertex next : root.next) {
            Vector3 from = root.offset.clone().subtract(playerOffset);
            Vector3 to = next.offset.clone().subtract(playerOffset);
            this.drawLine(from, to, vb, renderStack, r, g, b);
            if (!mayRenderNext) continue;
            this.renderRec(next, vb, renderStack, pTicks, r, g, b);
        }
    }

    private void drawLine(Vector3 from, Vector3 to, IVertexBuilder vb, MatrixStack renderStack, float r, float g, float b) {
        this.renderCurrentTextureAroundAxis(from, to, Math.toRadians(0.0), 0.035f, vb, renderStack, r, g, b);
        this.renderCurrentTextureAroundAxis(from, to, Math.toRadians(90.0), 0.035f, vb, renderStack, r, g, b);
    }

    private void renderCurrentTextureAroundAxis(Vector3 from, Vector3 to, double angle, double size, IVertexBuilder buf, MatrixStack renderStack, float r, float g, float b) {
        Vector3 aim = to.clone().subtract(from).normalize();
        Vector3 aimPerp = aim.clone().perpendicular().normalize();
        Vector3 perp = aimPerp.clone().rotate(angle, aim).normalize();
        Vector3 perpFrom = perp.clone().multiply(size);
        Vector3 perpTo = perp.multiply(size);
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        Vector3 vec = from.clone().add(perpFrom.clone().multiply(-1));
        vec.drawPos(matr, buf).func_227885_a_(r, g, b, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        vec = from.clone().add(perpFrom);
        vec.drawPos(matr, buf).func_227885_a_(r, g, b, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        vec = to.clone().add(perpTo);
        vec.drawPos(matr, buf).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        vec = to.clone().add(perpTo.clone().multiply(-1));
        vec.drawPos(matr, buf).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
    }

    @Override
    public boolean canRemove() {
        return Math.max((this.buildSpeed + this.buildWaitTime) * 20.0f, 1.0f) < (float)this.age;
    }

    private static class LightningVertex {
        private final Vector3 offset;
        private List<LightningVertex> next = new LinkedList<LightningVertex>();
        private int followingDepth = -1;

        private LightningVertex(Vector3 offset) {
            this.offset = offset;
        }

        public void calcDepthRec() {
            if (this.next.isEmpty()) {
                this.followingDepth = 0;
            } else {
                for (LightningVertex vertex : this.next) {
                    vertex.calcDepthRec();
                }
                this.followingDepth = MiscUtils.getMaxEntry(this.next, (Function<LightningVertex, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$calcDepthRec$0(hellfirepvp.astralsorcery.client.effect.vfx.FXLightning$LightningVertex ), (Lhellfirepvp/astralsorcery/client/effect/vfx/FXLightning$LightningVertex;)Ljava/lang/Integer;)()).followingDepth + 1;
            }
        }

        private static /* synthetic */ Integer lambda$calcDepthRec$0(LightningVertex v) {
            return v.followingDepth;
        }
    }
}

