/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.event;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.event.effect.GatewayUIRenderHandler;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.GatewayUI;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.client.PktRequestTeleport;
import hellfirepvp.astralsorcery.common.network.play.client.PktRevokeGatewayAccess;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.util.ColorUtils;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.PlayerReference;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;

public class GatewayInteractionHandler {
    private static final Random rand = new Random();
    public static GatewayUI.GatewayEntry focusingEntry = null;
    public static int focusTicks = 0;
    private static double fovPre = 0.0;

    public static void attachEventListeners(IEventBus eventBus) {
        eventBus.addListener(GatewayInteractionHandler::clientTick);
        eventBus.addListener(EventPriority.LOWEST, GatewayInteractionHandler::renderTick);
        eventBus.addListener(GatewayInteractionHandler::onAccessRevoke);
    }

    private static void onAccessRevoke(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        if (player == null || world == null || !world.func_201670_d() || event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        GatewayUI ui = GatewayUIRenderHandler.getInstance().getCurrentUI();
        if (ui == null) {
            return;
        }
        GatewayCache.GatewayNode node = ui.getThisGatewayNode();
        if (node == null || !node.isLocked() || node.getOwner() == null || node.getAllowedUsers().isEmpty()) {
            return;
        }
        TileCelestialGateway gateway = MiscUtils.getTileAt((IBlockReader)world, Vector3.atEntityCorner((Entity)player).toBlockPos(), TileCelestialGateway.class, true);
        if (gateway == null || !gateway.hasMultiblock() || !gateway.doesSeeSky()) {
            return;
        }
        BlockPos clickedPos = event.getPos();
        MapStream.of(node.getAllowedUsers()).filter((Predicate<Tuple<Integer, PlayerReference>>)((Predicate<Tuple>)tpl -> TileCelestialGateway.getAllowedUserOffset((Integer)tpl.func_76341_a()).func_177971_a((Vec3i)node.getPos()).func_177977_b().equals((Object)clickedPos))).findAny().map(Tuple::func_76340_b).ifPresent(playerRef -> {
            PktRevokeGatewayAccess pkt = new PktRevokeGatewayAccess(world.func_201675_m().func_186058_p(), gateway.func_174877_v(), playerRef.getPlayerUUID());
            PacketChannel.CHANNEL.sendToServer(pkt);
        });
    }

    private static void clientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (player == null || world == null) {
            focusingEntry = null;
            focusTicks = 0;
            return;
        }
        GatewayUI ui = GatewayUIRenderHandler.getInstance().getCurrentUI();
        if (ui == null) {
            focusingEntry = null;
            focusTicks = 0;
            return;
        }
        TileCelestialGateway gateway = MiscUtils.getTileAt((IBlockReader)world, Vector3.atEntityCorner((Entity)player).toBlockPos(), TileCelestialGateway.class, true);
        if (gateway == null || !gateway.hasMultiblock() || !gateway.doesSeeSky()) {
            focusingEntry = null;
            focusTicks = 0;
            return;
        }
        GatewayUI.GatewayEntry entry = GatewayUIRenderHandler.getInstance().findMatchingEntry(MathHelper.func_76142_g((float)player.field_70177_z), MathHelper.func_76142_g((float)player.field_70125_A));
        if (entry == null) {
            focusingEntry = null;
            focusTicks = 0;
            return;
        }
        if (!Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && !Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151470_d()) {
            focusingEntry = null;
            focusTicks = 0;
            return;
        }
        if (focusingEntry != null && !entry.equals(focusingEntry)) {
            focusingEntry = null;
            focusTicks = 0;
            return;
        }
        focusingEntry = entry;
        Vector3 dir = focusingEntry.getRelativePos().clone().add(ui.getRenderCenter()).subtract(player.func_174824_e(1.0f));
        Vector3 mov = dir.clone().normalize().multiply(0.25f).negate();
        Vector3 pos = focusingEntry.getRelativePos().clone().add(ui.getRenderCenter());
        DyeColor nodeColor = focusingEntry.getNode().getColor();
        Color gatewayColor = ColorUtils.flareColorFromDye(nodeColor == null ? DyeColor.YELLOW : nodeColor);
        if (++focusTicks <= 40) {
            Vector3 to;
            FXFacingParticle p;
            Vector3 at;
            Color color;
            float pc;
            int i;
            pos = focusingEntry.getRelativePos().clone().multiply(0.8).add(ui.getRenderCenter());
            float perc = (float)focusTicks / 40.0f;
            List<Vector3> positions = MiscUtils.getCirclePositions(pos, dir.clone().negate(), (double)rand.nextFloat() * 0.2 + 0.4, rand.nextInt(6) + 25);
            for (i = 0; i < positions.size(); ++i) {
                pc = (float)i / (float)positions.size();
                if (pc >= perc) continue;
                color = MiscUtils.eitherOf(rand, Color.WHITE, gatewayColor, gatewayColor.brighter());
                at = positions.get(i);
                p = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_GATEWAY_PARTICLE).spawn(at)).setScaleMultiplier(0.08f)).color(VFXColorFunction.constant(color));
                if (rand.nextInt(3) != 0) continue;
                to = pos.clone().subtract(at);
                to.normalize().multiply(0.02);
                ((EntityVisualFX)p.setMotion(to)).setAlphaMultiplier(0.1f);
            }
            positions = MiscUtils.getCirclePositions(pos, dir, (double)rand.nextFloat() * 0.2 + 0.4, rand.nextInt(6) + 25);
            Collections.reverse(positions);
            for (i = 0; i < positions.size(); ++i) {
                pc = (float)i / (float)positions.size();
                if (pc >= perc) continue;
                color = MiscUtils.eitherOf(rand, Color.WHITE, gatewayColor, gatewayColor.brighter());
                at = positions.get(i);
                p = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_GATEWAY_PARTICLE).spawn(at)).setScaleMultiplier(0.08f)).color(VFXColorFunction.constant(color));
                if (rand.nextInt(3) != 0) continue;
                to = pos.clone().subtract(at);
                to.normalize().multiply(0.02);
                ((EntityVisualFX)p.setMotion(to)).setAlphaMultiplier(0.1f);
            }
        } else {
            for (Vector3 v : MiscUtils.getCirclePositions(pos, dir, (double)rand.nextFloat() * 0.3 + 0.2, rand.nextInt(20) + 30)) {
                Color color = MiscUtils.eitherOf(rand, Color.WHITE, gatewayColor, gatewayColor.brighter());
                Vector3 m = mov.clone().multiply(0.5 + (double)rand.nextFloat() * 0.5);
                ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_GATEWAY_PARTICLE).spawn(v)).setScaleMultiplier(0.1f)).setMotion(m)).color(VFXColorFunction.constant(color));
            }
        }
        if (focusTicks > 95) {
            Minecraft.func_71410_x().field_71439_g.func_226284_e_(false);
            PktRequestTeleport pkt = new PktRequestTeleport(focusingEntry.getNodeDimension(), focusingEntry.getNode().getPos());
            PacketChannel.CHANNEL.sendToServer(pkt);
            focusingEntry = null;
            focusTicks = 0;
        }
    }

    private static void renderTick(TickEvent.RenderTickEvent event) {
        GatewayUI ui = GatewayUIRenderHandler.getInstance().getCurrentUI();
        if (ui == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            fovPre = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            if (focusTicks < 80) {
                return;
            }
            float percDone = 1.0f - ((float)focusTicks - 80.0f + event.renderTickTime) / 15.0f;
            percDone = (float)Math.pow(percDone, 2.4f);
            float targetFov = 10.0f;
            double diff = fovPre - (double)targetFov;
            Minecraft.func_71410_x().field_71474_y.field_74334_X = Math.max((double)targetFov, (double)targetFov + diff * (double)percDone);
        } else {
            Minecraft.func_71410_x().field_71474_y.field_74334_X = fovPre;
        }
    }
}

