/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.event.effect;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.GatewayUI;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.util.ColorUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;

public class GatewayUIRenderHandler
implements ITickHandler {
    private static final GatewayUIRenderHandler INSTANCE = new GatewayUIRenderHandler();
    private GatewayUI currentUI = null;

    private GatewayUIRenderHandler() {
    }

    public static GatewayUIRenderHandler getInstance() {
        return INSTANCE;
    }

    public GatewayUI getOrCreateUI(IWorld world, BlockPos pos, Vector3 renderPos) {
        if (this.currentUI == null || !this.currentUI.getDimType().equals((Object)world.func_201675_m().func_186058_p().getRegistryName()) || !this.currentUI.getPos().equals((Object)pos)) {
            this.currentUI = GatewayUI.create(world, pos, renderPos, 5.5);
        }
        if (this.currentUI != null) {
            this.currentUI.refreshView();
        }
        return this.currentUI;
    }

    public GatewayUI getCurrentUI() {
        return this.currentUI;
    }

    private boolean validate() {
        TileCelestialGateway gateway;
        if (this.currentUI == null) {
            return true;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (!(world != null && this.currentUI.getVisibleTicks() > 0 && this.currentUI.getDimType().equals((Object)world.func_201675_m().func_186058_p().getRegistryName()) && (gateway = MiscUtils.getTileAt((IBlockReader)world, this.currentUI.getPos(), TileCelestialGateway.class, true)) != null && gateway.doesSeeSky() && gateway.hasMultiblock())) {
            this.currentUI = null;
        }
        return this.currentUI == null;
    }

    void render(RenderWorldLastEvent event) {
        ClientPlayerEntity player;
        if (this.validate()) {
            return;
        }
        float pTicks = event.getPartialTicks();
        MatrixStack renderStack = event.getMatrixStack();
        Vector3 renderOffset = this.currentUI.getRenderCenter();
        double dst = renderOffset.distance(Vector3.atEntityCorner((Entity)(player = Minecraft.func_71410_x().field_71439_g)).addY(1.5));
        if (dst > 3.0) {
            return;
        }
        this.renderGatewayShieldOverlay(renderStack, renderOffset, dst, pTicks);
        this.renderGatewayFocusedEntry(renderStack, renderOffset, pTicks);
        this.renderGatewayAllowedPlayers(renderStack, renderOffset, dst, pTicks);
    }

    private void renderGatewayAllowedPlayers(MatrixStack renderStack, Vector3 renderOffset, double distance, float pTicks) {
        GatewayCache.GatewayNode node = this.currentUI.getThisGatewayNode();
        if (node == null || !node.isLocked() || node.getOwner() == null || node.getAllowedUsers().isEmpty()) {
            return;
        }
        UUID currentUUID = Minecraft.func_71410_x().field_71439_g != null ? Minecraft.func_71410_x().field_71439_g.func_110124_au() : null;
        RayTraceResult mouseOverRtr = Minecraft.func_71410_x().field_71476_x;
        BlockPos blockSelected = mouseOverRtr != null && mouseOverRtr.func_216346_c() == RayTraceResult.Type.BLOCK && mouseOverRtr instanceof BlockRayTraceResult ? ((BlockRayTraceResult)mouseOverRtr).func_216350_a().func_177984_a() : null;
        Color c = ColorsAS.CONSTELLATION_TYPE_MAJOR;
        float alpha = MathHelper.func_76131_a((float)(1.0f - (float)(distance / 2.0)), (float)0.0f, (float)1.0f);
        IRenderTypeBuffer.Impl drawBuffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        node.getAllowedUsers().forEach((index, playerRef) -> {
            BlockPos drawPos = TileCelestialGateway.getAllowedUserOffset(index).func_177971_a((Vec3i)node.getPos());
            Vector3 at = new Vector3((Vec3i)drawPos).add(0.5, 0.001, 0.5).subtract(RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks));
            IConstellation cst = this.getCurrentUI().getGeneratedConstellation(playerRef.getPlayerUUID());
            if (cst != null) {
                RenderingConstellationUtils.renderConstellationIntoWorldFlat(c, cst, renderStack, (IRenderTypeBuffer)drawBuffers, at, 1.2, 1.0, alpha);
                UUID targetUUID = playerRef.getPlayerUUID();
                if ((node.getOwner().getPlayerUUID().equals(currentUUID) || targetUUID.equals(currentUUID)) && drawPos.equals((Object)blockSelected)) {
                    RenderingUtils.renderInWorldText(playerRef.getPlayerName().func_150254_d(), c, 0.020833334f, at.clone().addY(0.2), renderStack, pTicks, true);
                }
            }
        });
        drawBuffers.func_228461_a_();
    }

    private void renderGatewayFocusedEntry(MatrixStack renderStack, Vector3 renderOffset, float pTicks) {
        ITextComponent display;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        GatewayUI.GatewayEntry entry = this.findMatchingEntry(MathHelper.func_76142_g((float)player.field_70177_z), MathHelper.func_76142_g((float)player.field_70125_A));
        if (entry != null && (display = entry.getNode().getDisplayName()) != null && !display.func_150254_d().isEmpty()) {
            String text = display.func_150254_d();
            Vector3 at = entry.getRelativePos().clone().add(renderOffset).addY(0.4f).subtract(RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks));
            Color c = ColorsAS.CONSTELLATION_SINGLE_STAR;
            DyeColor nodeColor = entry.getNode().getColor();
            if (nodeColor != null) {
                c = ColorUtils.flareColorFromDye(nodeColor);
            }
            RenderingUtils.renderInWorldText(text, c, at, renderStack, pTicks, true);
        }
    }

    private void renderGatewayShieldOverlay(MatrixStack renderStack, Vector3 renderOffset, double distance, float pTicks) {
        float alpha = MathHelper.func_76131_a((float)(1.0f - (float)(distance / 2.0)), (float)0.0f, (float)1.0f);
        Color c = ColorsAS.CONSTELLATION_SINGLE_STAR;
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        long seed = -6376616654017193693L;
        seed |= (long)this.currentUI.getPos().func_177958_n() << 48;
        seed |= (long)this.currentUI.getPos().func_177956_o() << 24;
        Random rand = new Random(seed |= (long)this.currentUI.getPos().func_177952_p());
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderSystem.enableTexture();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        TexturesAS.TEX_STAR_1.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            for (int i = 0; i < 300; ++i) {
                Vector3 dir = Vector3.random(rand).normalize().multiply(this.currentUI.getSphereRadius() * 0.9);
                float a = RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), pTicks, rand.nextInt(7) + 6);
                RenderingDrawUtils.renderFacingFullQuadVB((IVertexBuilder)buf, renderStack, renderOffset.getX() + dir.getX(), renderOffset.getY() + dir.getY(), renderOffset.getZ() + dir.getZ(), 0.07f, 0.0f, 255, 255, 255, (int)((a *= alpha) * 255.0f));
            }
            for (GatewayUI.GatewayEntry entry : this.currentUI.getGatewayEntries()) {
                int r = red;
                int g = green;
                int b = blue;
                DyeColor nodeColor = entry.getNode().getColor();
                if (nodeColor != null) {
                    if (nodeColor == DyeColor.BLACK) {
                        nodeColor = DyeColor.GRAY;
                    }
                    Color ovr = ColorUtils.flareColorFromDye(nodeColor);
                    r = ovr.getRed();
                    g = ovr.getGreen();
                    b = ovr.getBlue();
                }
                float a = RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), pTicks, rand.nextInt(7) + 6);
                a = 0.4f + 0.6f * a;
                RenderingDrawUtils.renderFacingFullQuadVB((IVertexBuilder)buf, renderStack, renderOffset.getX() + entry.getRelativePos().getX(), renderOffset.getY() + entry.getRelativePos().getY(), renderOffset.getZ() + entry.getRelativePos().getZ(), 0.16f, 0.0f, r, g, b, (int)((a *= alpha) * 255.0f));
            }
        });
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    @Nullable
    public GatewayUI.GatewayEntry findMatchingEntry(float yaw, float pitch) {
        float matchAccurancy = 4.0f;
        for (GatewayUI.GatewayEntry entry : this.currentUI.getGatewayEntries()) {
            if (!(Math.abs(entry.getPitch() - pitch) < matchAccurancy) || !(Math.abs(entry.getYaw() - yaw) <= matchAccurancy) && !(Math.abs(entry.getYaw() - yaw - 360.0f) <= matchAccurancy)) continue;
            return entry;
        }
        return null;
    }

    public void tick(TickEvent.Type type, Object ... context) {
        if (this.currentUI != null) {
            this.currentUI.decrementVisibleTicks();
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "GatewayUI Render Handler";
    }
}

