/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.entity.technical.EntityGrapplingHook;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderEntityGrapplingHook
extends EntityRenderer<EntityGrapplingHook> {
    protected RenderEntityGrapplingHook(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(EntityGrapplingHook entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        int alphaMultiplier = entity.isDespawning() ? MathHelper.func_76125_a((int)(127 - (int)(entity.despawnPercentage(partialTicks) * 255.0f)), (int)0, (int)255) : 255;
        if ((double)alphaMultiplier <= 1.0E-4) {
            return;
        }
        Vector3 entityPos = RenderingVectorUtils.interpolatePosition((Entity)entity, partialTicks);
        List<Vector3> line = entity.buildLine(partialTicks);
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderSystem.disableCull();
        SpritesAS.SPR_GRAPPLING_HOOK.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingDrawUtils.renderFacingSpriteVB((IVertexBuilder)buf, matrixStack, entityPos.getX(), entityPos.getY(), entityPos.getZ(), 2.5f, 0.0f, SpritesAS.SPR_GRAPPLING_HOOK, ClientScheduler.getClientTick() + (long)entity.field_70173_aa, 255, 255, 255, alphaMultiplier));
        TexturesAS.TEX_PARTICLE_LARGE.bindTexture();
        Blending.ADDITIVE_ALPHA.apply();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            for (Vector3 pos : line) {
                Vector3 at = pos.multiply(2).add(entityPos);
                RenderingDrawUtils.renderFacingFullQuadVB((IVertexBuilder)buf, matrixStack, at.getX(), at.getY(), at.getZ(), 0.5f, 0.0f, 50, 40, 180, (int)((float)alphaMultiplier * 0.8f));
            }
        });
        RenderSystem.enableCull();
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    public ResourceLocation getEntityTexture(EntityGrapplingHook entity) {
        return AtlasTexture.field_110575_b;
    }

    public static class Factory
    implements IRenderFactory<EntityGrapplingHook> {
        public EntityRenderer<? super EntityGrapplingHook> createRenderFor(EntityRendererManager manager) {
            return new RenderEntityGrapplingHook(manager);
        }
    }
}

