/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.resource;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BindableResource
extends AbstractRenderableTexture.Full {
    private Texture resource = null;
    private String path;

    public BindableResource(String path) {
        super(AstralSorcery.key(path.replaceAll("[^a-zA-Z0-9\\.\\-]", "_")));
        this.path = path;
        this.allocateGlId();
    }

    public String getPath() {
        return this.path;
    }

    public boolean isInitialized() {
        return this.resource != null;
    }

    public Texture getResource() {
        return this.resource;
    }

    public SpriteSheetResource asSpriteSheet(int rows, int columns) {
        return new SpriteSheetResource(this, rows, columns);
    }

    void invalidateAndReload() {
        Minecraft.func_71410_x().func_110434_K().func_147645_c(this.getKey());
        this.resource = null;
    }

    private void allocateGlId() {
        if (this.resource != null || AssetLibrary.isReloading()) {
            return;
        }
        TextureManager mgr = Minecraft.func_71410_x().func_110434_K();
        this.resource = mgr.func_229267_b_(this.getKey());
        if (this.resource == null) {
            mgr.func_229263_a_(this.getKey(), (Texture)new SimpleTexture(new ResourceLocation(this.getPath())));
            this.resource = mgr.func_229267_b_(this.getKey());
        }
    }

    @Override
    public void bindTexture() {
        if (AssetLibrary.isReloading()) {
            return;
        }
        if (this.resource == null) {
            this.allocateGlId();
        }
        RenderSystem.bindTexture((int)this.resource.func_110552_b());
    }

    @Override
    public RenderState.TextureState asState() {
        return new RenderState.TextureState(this.getKey(), false, false){

            public void func_228547_a_() {
                RenderSystem.enableTexture();
                BindableResource.this.bindTexture();
                BindableResource.this.resource.setBlurMipmap(false, false);
            }
        };
    }
}

