/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.TileEntityScreen;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.DrawnConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.engraving.EngravedStarMap;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.ItemInfusedGlass;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.client.PktEngraveGlass;
import hellfirepvp.astralsorcery.common.tile.TileRefractionTable;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class ScreenRefractionTable
extends TileEntityScreen<TileRefractionTable> {
    private static final Rectangle PLACEMENT_GRID = new Rectangle(98, 75, 60, 60);
    private Map<Rectangle, IConstellation> mapRenderedConstellations = new HashMap<Rectangle, IConstellation>();
    private List<DrawnConstellation> currentlyDrawnConstellations = new ArrayList<DrawnConstellation>();
    private IConstellation dragging = null;

    public ScreenRefractionTable(TileRefractionTable tile) {
        super(tile, 188, 256);
    }

    public void render(int mouseX, int mouseY, float pTicks) {
        RenderSystem.enableDepthTest();
        super.render(mouseX, mouseY, pTicks);
        this.mapRenderedConstellations.clear();
        if (((TileRefractionTable)this.getTile()).hasParchment()) {
            this.drawWHRect(TexturesAS.TEX_GUI_REFRACTION_TABLE_PARCHMENT);
        } else {
            this.drawWHRect(TexturesAS.TEX_GUI_REFRACTION_TABLE_EMPTY);
        }
        if ((double)DayTimeHelper.getCurrentDaytimeDistribution(((TileRefractionTable)this.getTile()).func_145831_w()) <= 0.05 || !((TileRefractionTable)this.getTile()).hasParchment()) {
            this.currentlyDrawnConstellations.clear();
            this.dragging = null;
        }
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        FontRenderer tooltipRenderer = Minecraft.func_71410_x().field_71466_p;
        tooltipRenderer = this.renderTileItems(mouseX, mouseY, tooltip, tooltipRenderer);
        this.renderConstellationOptions(mouseX, mouseY, tooltip);
        this.renderRunningHalo();
        this.renderInputItem();
        this.renderDrawnConstellations(mouseX, mouseY, tooltip);
        this.renderDraggedConstellations();
        this.renderDragging(mouseX, mouseY);
        if (!tooltip.isEmpty()) {
            List<String> localized = tooltip.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
            this.setBlitOffset(510);
            RenderingDrawUtils.renderBlueTooltipString(mouseX, mouseY, this.getGuiZLevel(), localized, tooltipRenderer, true);
            this.setBlitOffset(0);
        }
    }

    private void renderDragging(int mouseX, int mouseY) {
        if (this.dragging == null) {
            return;
        }
        int whDrawn = 30;
        Point offset = new Point(mouseX, mouseY);
        offset.translate(-whDrawn, -whDrawn);
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderingConstellationUtils.renderConstellationIntoGUI(this.dragging, offset.x, offset.y, this.getGuiZLevel(), whDrawn * 2, whDrawn * 2, 1.4f, () -> Float.valueOf(DayTimeHelper.getCurrentDaytimeDistribution(((TileRefractionTable)this.getTile()).func_145831_w())), true, false);
        RenderSystem.disableBlend();
        this.renderBox(offset.x, offset.y, whDrawn * 2, whDrawn * 2, this.dragging.getTierRenderColor());
        Rectangle r = new Rectangle(PLACEMENT_GRID);
        r.grow(30, 30);
        r.translate(this.guiLeft, this.guiTop);
        this.renderBox(r.x, r.y, r.width, r.height, this.dragging.getTierRenderColor());
    }

    private void renderDraggedConstellations() {
        int whDrawn = 30;
        for (DrawnConstellation dragged : this.currentlyDrawnConstellations) {
            Point offset = new Point(dragged.getPoint());
            offset.translate(this.guiLeft, this.guiTop);
            offset.translate(ScreenRefractionTable.PLACEMENT_GRID.x, ScreenRefractionTable.PLACEMENT_GRID.y);
            offset.translate(-whDrawn, -whDrawn);
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            RenderingConstellationUtils.renderConstellationIntoGUI(dragged.getConstellation(), offset.x, offset.y, this.getGuiZLevel(), whDrawn * 2, whDrawn * 2, 1.4f, () -> Float.valueOf(DayTimeHelper.getCurrentDaytimeDistribution(((TileRefractionTable)this.getTile()).func_145831_w())), true, false);
            RenderSystem.disableBlend();
        }
    }

    private void renderInputItem() {
        if (((TileRefractionTable)this.getTile()).getInputStack().func_190926_b() || ((TileRefractionTable)this.getTile()).hasParchment()) {
            return;
        }
        this.setBlitOffset(100);
        this.itemRenderer.field_77023_b = 100.0f;
        ItemStack input = ((TileRefractionTable)this.getTile()).getInputStack();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)((double)(this.guiLeft + 63) + 16.25), (double)((double)(this.guiTop + 42) + 16.25), (double)0.0);
        RenderSystem.scaled((double)6.0, (double)6.0, (double)1.0);
        RenderSystem.disableDepthTest();
        RenderingUtils.renderItemStack(this.itemRenderer, input, 0, 0, null);
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
        this.setBlitOffset(0);
        this.itemRenderer.field_77023_b = 0.0f;
    }

    private void renderRunningHalo() {
        if (((TileRefractionTable)this.getTile()).getRunProgress() > 0.0f) {
            SpritesAS.SPR_HALO_INFUSION.bindTexture();
            Tuple<Float, Float> uvFrame = SpritesAS.SPR_HALO_INFUSION.getUVOffset(ClientScheduler.getClientTick());
            float scale = 160.0f;
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            RenderSystem.disableAlphaTest();
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(this.guiWidth / 2), (double)(this.guiHeight / 2 + 10), (double)0.0);
            RenderSystem.translated((double)(-scale / 2.0f), (double)(-scale / 2.0f), (double)0.0);
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, this).dim(scale, scale).color(1.0f, 1.0f, 1.0f, ((TileRefractionTable)this.getTile()).getRunProgress()).tex(((Float)uvFrame.func_76341_a()).floatValue(), ((Float)uvFrame.func_76340_b()).floatValue(), SpritesAS.SPR_HALO_INFUSION.getUWidth(), SpritesAS.SPR_HALO_INFUSION.getVWidth()).draw());
            RenderSystem.popMatrix();
            RenderSystem.enableAlphaTest();
            Blending.DEFAULT.apply();
            RenderSystem.disableBlend();
        }
    }

    private void renderDrawnConstellations(int mouseX, int mouseY, List<ITextComponent> tooltip) {
        ItemStack glass = ((TileRefractionTable)this.getTile()).getGlassStack();
        if (glass.func_190926_b()) {
            return;
        }
        World world = ((TileRefractionTable)this.getTile()).func_145831_w();
        float nightPerc = DayTimeHelper.getCurrentDaytimeDistribution(world);
        WorldContext ctx = SkyHandler.getContext(world, LogicalSide.CLIENT);
        if (ctx == null || !((TileRefractionTable)this.getTile()).doesSeeSky() || nightPerc <= 0.05f) {
            return;
        }
        EngravedStarMap map = ItemInfusedGlass.getEngraving(glass);
        if (map == null) {
            return;
        }
        for (DrawnConstellation cst : map.getDrawnConstellations()) {
            int whDrawn = 30;
            Point offset = new Point(cst.getPoint());
            offset.translate(this.guiLeft, this.guiTop);
            offset.translate(ScreenRefractionTable.PLACEMENT_GRID.x, ScreenRefractionTable.PLACEMENT_GRID.y);
            offset.translate(-whDrawn, -whDrawn);
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            RenderingConstellationUtils.renderConstellationIntoGUI(cst.getConstellation(), offset.x, offset.y, this.getGuiZLevel(), whDrawn * 2, whDrawn * 2, 1.6f, () -> Float.valueOf(DayTimeHelper.getCurrentDaytimeDistribution(world) * 0.8f), true, false);
            RenderSystem.disableBlend();
        }
    }

    private void renderConstellationOptions(int mouseX, int mouseY, List<ITextComponent> tooltip) {
        ItemStack glass = ((TileRefractionTable)this.getTile()).getGlassStack();
        if (glass.func_190926_b()) {
            return;
        }
        World world = ((TileRefractionTable)this.getTile()).func_145831_w();
        float nightPerc = DayTimeHelper.getCurrentDaytimeDistribution(world);
        WorldContext ctx = SkyHandler.getContext(world, LogicalSide.CLIENT);
        if (ctx == null || !((TileRefractionTable)this.getTile()).doesSeeSky() || nightPerc <= 0.05f) {
            return;
        }
        List cstList = ctx.getActiveCelestialsHandler().getActiveConstellations().stream().filter(c -> ResearchHelper.getClientProgress().hasConstellationDiscovered((IConstellation)c)).collect(Collectors.toList());
        for (int i = 0; i < Math.min(cstList.size(), 12); ++i) {
            IConstellation cst = (IConstellation)cstList.get(i);
            int offsetX = this.guiLeft + (i % 2 == 0 ? 8 : 232);
            int offsetY = this.guiTop + (40 + i / 2 * 23);
            Rectangle rct = new Rectangle(offsetX, offsetY, 16, 16);
            this.mapRenderedConstellations.put(rct, cst);
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            RenderingConstellationUtils.renderConstellationIntoGUI(Color.WHITE, cst, offsetX, offsetY, this.getGuiZLevel(), 16.0f, 16.0f, 0.5, () -> Float.valueOf(DayTimeHelper.getCurrentDaytimeDistribution(world)), true, false);
            RenderSystem.disableBlend();
            if (!rct.contains(mouseX, mouseY)) continue;
            tooltip.add(cst.getConstellationName());
        }
    }

    private FontRenderer renderTileItems(int mouseX, int mouseY, List<ITextComponent> tooltip, FontRenderer tooltipRenderer) {
        ItemStack glass;
        this.setBlitOffset(100);
        this.itemRenderer.field_77023_b = 100.0f;
        ItemStack input = ((TileRefractionTable)this.getTile()).getInputStack();
        if (!input.func_190926_b()) {
            Rectangle itemRct = new Rectangle(this.guiLeft + 111, this.guiTop + 8, 16, 16);
            RenderingUtils.renderItemStack(this.itemRenderer, input, itemRct.x, itemRct.y, null);
            if (itemRct.contains(mouseX, mouseY)) {
                FontRenderer custom = input.func_77973_b().getFontRenderer(input);
                if (custom != null) {
                    tooltipRenderer = custom;
                }
                tooltip.addAll(input.func_82840_a((PlayerEntity)this.getMinecraft().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
            }
        }
        if (!(glass = ((TileRefractionTable)this.getTile()).getGlassStack()).func_190926_b()) {
            Rectangle itemRct = new Rectangle(this.guiLeft + 129, this.guiTop + 8, 16, 16);
            RenderingUtils.renderItemStack(this.itemRenderer, glass, itemRct.x, itemRct.y, null);
            if (itemRct.contains(mouseX, mouseY)) {
                FontRenderer custom = glass.func_77973_b().getFontRenderer(glass);
                if (custom != null) {
                    tooltipRenderer = custom;
                }
                tooltip.addAll(glass.func_82840_a((PlayerEntity)this.getMinecraft().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
            }
        }
        this.setBlitOffset(0);
        this.itemRenderer.field_77023_b = 0.0f;
        return tooltipRenderer;
    }

    private void renderBox(float offsetX, float offsetY, float width, float height, Color c) {
        Random rand = new Random(18L);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        Supplier<Float> alpha = () -> Float.valueOf(0.1f + 0.4f * ((MathHelper.func_76126_a((float)((float)rand.nextInt(200) + (float)ClientScheduler.getClientTick() / 20.0f)) + 1.0f) / 2.0f));
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderSystem.disableAlphaTest();
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.disableTexture();
        RenderSystem.disableDepthTest();
        RenderingUtils.draw(1, DefaultVertexFormats.field_181706_f, buf -> {
            buf.func_225582_a_((double)offsetX, (double)offsetY, 0.0).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_225582_a_((double)(offsetX + width), (double)offsetY, 0.0).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_225582_a_((double)(offsetX + width), (double)offsetY, 0.0).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_225582_a_((double)(offsetX + width), (double)(offsetY + height), 0.0).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_225582_a_((double)(offsetX + width), (double)(offsetY + height), 0.0).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_225582_a_((double)offsetX, (double)(offsetY + height), 0.0).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_225582_a_((double)offsetX, (double)(offsetY + height), 0.0).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_225582_a_((double)offsetX, (double)offsetY, 0.0).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
        });
        RenderSystem.enableDepthTest();
        RenderSystem.enableTexture();
        RenderSystem.enableAlphaTest();
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.currentlyDrawnConstellations.size() >= 3) {
            ArrayList<DrawnConstellation> copyList = new ArrayList<DrawnConstellation>(this.currentlyDrawnConstellations);
            PktEngraveGlass engraveGlass = new PktEngraveGlass(((TileRefractionTable)this.getTile()).func_145831_w().func_201675_m().func_186058_p(), ((TileRefractionTable)this.getTile()).func_174877_v(), copyList);
            PacketChannel.CHANNEL.sendToServer(engraveGlass);
            this.currentlyDrawnConstellations.clear();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.dragging == null && ((TileRefractionTable)this.getTile()).hasParchment() && ((TileRefractionTable)this.getTile()).hasUnengravedGlass() && this.currentlyDrawnConstellations.size() < 3) {
            this.tryPick(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int click) {
        if (super.mouseReleased(mouseX, mouseY, click)) {
            return true;
        }
        if (click == 0 && this.dragging != null && ((TileRefractionTable)this.getTile()).hasParchment() && ((TileRefractionTable)this.getTile()).hasUnengravedGlass() && this.currentlyDrawnConstellations.size() < 3) {
            this.tryDrop(mouseX, mouseY);
        }
        return false;
    }

    private void tryDrop(double mouseX, double mouseY) {
        if (this.dragging != null) {
            if (PLACEMENT_GRID.contains(mouseX - (double)this.guiLeft, mouseY - (double)this.guiTop)) {
                Point gridPoint = new Point((int)Math.round(mouseX), (int)Math.round(mouseY));
                gridPoint.translate(-this.guiLeft, -this.guiTop);
                gridPoint.translate(-ScreenRefractionTable.PLACEMENT_GRID.x, -ScreenRefractionTable.PLACEMENT_GRID.y);
                this.currentlyDrawnConstellations.add(new DrawnConstellation(gridPoint, this.dragging));
            }
            this.dragging = null;
        }
    }

    private void tryPick(double mouseX, double mouseY) {
        for (Rectangle r : this.mapRenderedConstellations.keySet()) {
            if (!r.contains(mouseX, mouseY)) continue;
            this.dragging = this.mapRenderedConstellations.get(r);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

