/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.screen.helper.ScalingPoint;
import hellfirepvp.astralsorcery.client.screen.helper.ScreenRenderBoundingBox;
import hellfirepvp.astralsorcery.client.screen.helper.SizeHandler;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournal;
import hellfirepvp.astralsorcery.client.screen.journal.overlay.ScreenJournalOverlayPerkStatistics;
import hellfirepvp.astralsorcery.client.screen.journal.perk.BatchPerkContext;
import hellfirepvp.astralsorcery.client.screen.journal.perk.DynamicPerkRender;
import hellfirepvp.astralsorcery.client.screen.journal.perk.PerkRenderGroup;
import hellfirepvp.astralsorcery.client.screen.journal.perk.PerkTreeSizeHandler;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.ScreenTextEntry;
import hellfirepvp.astralsorcery.client.util.draw.BufferContext;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGem;
import hellfirepvp.astralsorcery.common.item.useables.ItemPerkSeal;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.client.PktPerkGemModification;
import hellfirepvp.astralsorcery.common.network.play.client.PktRequestPerkSealAction;
import hellfirepvp.astralsorcery.common.network.play.client.PktUnlockPerk;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.AllocationStatus;
import hellfirepvp.astralsorcery.common.perk.DynamicModifierHelper;
import hellfirepvp.astralsorcery.common.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.ProgressGatedPerk;
import hellfirepvp.astralsorcery.common.perk.node.GemSlotPerk;
import hellfirepvp.astralsorcery.common.perk.node.RootPerk;
import hellfirepvp.astralsorcery.common.perk.source.AttributeConverterProvider;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.LogicalSide;
import org.lwjgl.opengl.GL11;

public class ScreenJournalPerkTree
extends ScreenJournal {
    private static Rectangle rectSealBox = new Rectangle(29, 16, 16, 16);
    private static Rectangle rectSearchTextEntry = new Rectangle(300, 16, 88, 15);
    private static Long lastPreparedBuffer = null;
    private static BatchPerkContext drawBuffer;
    private static BatchPerkContext.TextureObjectGroup searchContext;
    private static BatchPerkContext.TextureObjectGroup sealContext;
    private SizeHandler sizeHandler;
    private ScreenRenderBoundingBox guiBox;
    private ScalingPoint mousePosition;
    private ScalingPoint previousMousePosition;
    private AbstractPerk unlockPrimed = null;
    private AbstractPerk sealBreakPrimed = null;
    private int tickSealBreak = 0;
    private int guiOffsetX;
    private int guiOffsetY;
    public boolean expectReinit = false;
    private Map<AbstractPerk, Rectangle2D.Float> thisFramePerks = Maps.newHashMap();
    private Map<AbstractPerk, Long> unlockEffects = Maps.newHashMap();
    private Map<AbstractPerk, Long> breakEffects = Maps.newHashMap();
    private ScreenTextEntry searchTextEntry = new ScreenTextEntry();
    private List<AbstractPerk> searchMatches = Lists.newArrayList();
    private GemSlotPerk socketMenu = null;
    private Rectangle2D.Float rSocketMenu = null;
    private Map<Rectangle2D.Float, Integer> slotsSocketMenu = Maps.newHashMap();
    private Rectangle rStatStar = null;
    private ItemStack mouseSealStack = ItemStack.field_190927_a;
    private ItemStack foundSeals = ItemStack.field_190927_a;

    public ScreenJournalPerkTree() {
        super((ITextComponent)new TranslationTextComponent("screen.astralsorcery.tome.perks", new Object[0]), 30);
        this.closeWithInventoryKey = false;
        this.searchTextEntry.setChangeCallback(this::updateSearchHighlight);
        this.buildTree();
    }

    private void buildTree() {
        this.guiBox = new ScreenRenderBoundingBox(10.0, 10.0, this.guiWidth - 10, this.guiHeight - 10);
        this.sizeHandler = new PerkTreeSizeHandler();
        this.sizeHandler.setScaleSpeed(0.04f);
        this.sizeHandler.setMaxScale(1.0f);
        this.sizeHandler.setMinScale(0.1f);
        this.sizeHandler.updateSize();
        this.mousePosition = ScalingPoint.createPoint(0.0f, 0.0f, this.sizeHandler.getScalingFactor(), false);
    }

    public static void refreshDrawBuffer() {
        lastPreparedBuffer = null;
    }

    public static void initializeDrawBuffer() {
        PerkTree.PERK_TREE.getVersion(LogicalSide.CLIENT).ifPresent(version -> {
            if (lastPreparedBuffer == null || version.longValue() != lastPreparedBuffer.longValue()) {
                drawBuffer = new BatchPerkContext();
                searchContext = drawBuffer.addContext(SpritesAS.SPR_PERK_SEARCH, 300);
                sealContext = drawBuffer.addContext(SpritesAS.SPR_PERK_SEAL, 200);
                ArrayList groups = Lists.newArrayList();
                for (PerkTreePoint<?> p : PerkTree.PERK_TREE.getPerkPoints(LogicalSide.CLIENT)) {
                    p.addGroups(groups);
                }
                for (PerkRenderGroup group : groups) {
                    group.batchRegister(drawBuffer);
                }
                lastPreparedBuffer = version;
            }
        });
    }

    @Override
    protected void init() {
        RootPerk root;
        super.init();
        if (this.expectReinit) {
            this.expectReinit = false;
            return;
        }
        this.guiOffsetX = this.guiLeft + 10;
        this.guiOffsetY = this.guiTop + 10;
        boolean shifted = false;
        PlayerProgress progress = ResearchHelper.getClientProgress();
        IMajorConstellation attunement = progress.getAttunedConstellation();
        if (attunement != null && (root = PerkTree.PERK_TREE.getRootPerk(LogicalSide.CLIENT, attunement)) != null) {
            Point2D.Float shift = this.sizeHandler.evRelativePos(root.getOffset());
            this.moveMouse(MathHelper.func_76141_d((float)shift.x), MathHelper.func_76141_d((float)shift.y));
            shifted = true;
        }
        if (!shifted) {
            this.moveMouse(MathHelper.func_76141_d((float)(this.sizeHandler.getTotalWidth() / 2.0f)), MathHelper.func_76141_d((float)(this.sizeHandler.getTotalHeight() / 2.0f)));
        }
        this.applyMovedMouseOffset();
    }

    public void render(int mouseX, int mouseY, float pTicks) {
        ScreenJournalPerkTree.initializeDrawBuffer();
        this.thisFramePerks.clear();
        double guiFactor = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)MathHelper.func_76128_c((double)((double)(this.guiLeft + 27) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.guiTop + 27) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.guiWidth - 54) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.guiHeight - 54) * guiFactor)));
        this.setBlitOffset(-50);
        this.drawBackground();
        this.setBlitOffset(0);
        this.drawPerkTree(pTicks);
        GL11.glDisable((int)3089);
        RenderSystem.depthMask((boolean)false);
        this.drawDefault(TexturesAS.TEX_GUI_BOOK_FRAME_FULL, mouseX, mouseY);
        RenderSystem.depthMask((boolean)true);
        this.drawSearchBox();
        this.drawMiscInfo(mouseX, mouseY, pTicks);
        this.drawSocketContextMenu();
        this.drawSealBox();
        this.setBlitOffset(510);
        this.drawHoverTooltips(mouseX, mouseY);
        this.setBlitOffset(0);
        if (!this.mouseSealStack.func_190926_b()) {
            RenderingUtils.renderItemStack(this.itemRenderer, this.mouseSealStack, mouseX - 8, mouseY - 8, null);
        }
    }

    @Override
    public void tick() {
        int count;
        super.tick();
        this.foundSeals = Minecraft.func_71410_x().field_71439_g != null ? ((count = ItemPerkSeal.getPlayerSealCount((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) > 0 ? new ItemStack((IItemProvider)ItemsAS.PERK_SEAL, count) : ItemStack.field_190927_a) : ItemStack.field_190927_a;
        --this.tickSealBreak;
        if (this.tickSealBreak <= 0) {
            this.tickSealBreak = 0;
            this.sealBreakPrimed = null;
        }
    }

    private void drawSealBox() {
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        TexturesAS.TEX_GUI_MENU_SLOT.bindTexture();
        RenderingGuiUtils.drawTexturedRect(this.guiLeft + ScreenJournalPerkTree.rectSealBox.x - 1, this.guiTop + ScreenJournalPerkTree.rectSealBox.y - 1, this.getGuiZLevel(), ScreenJournalPerkTree.rectSealBox.width + 2, ScreenJournalPerkTree.rectSealBox.height + 2, TexturesAS.TEX_GUI_MENU_SLOT);
        RenderSystem.disableBlend();
        if (!this.foundSeals.func_190926_b()) {
            RenderingUtils.renderItemStack(this.itemRenderer, this.foundSeals, this.guiLeft + ScreenJournalPerkTree.rectSealBox.x, this.guiTop + ScreenJournalPerkTree.rectSealBox.y, null);
        }
    }

    private void drawHoverTooltips(int mouseX, int mouseY) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        for (Rectangle2D.Float float_ : this.slotsSocketMenu.keySet()) {
            if (!float_.contains(mouseX, mouseY)) continue;
            Integer slot = this.slotsSocketMenu.get(float_);
            ItemStack in = player.field_71071_by.func_70301_a(slot.intValue());
            if (!in.func_190926_b()) {
                FontRenderer fr = in.func_77973_b().getFontRenderer(in);
                if (fr == null) {
                    fr = Minecraft.func_71410_x().field_71466_p;
                }
                List toolTip = this.getTooltipFromItem(in);
                RenderingDrawUtils.renderBlueTooltipString(mouseX, mouseY, this.getGuiZLevel(), toolTip, fr, true);
            }
            return;
        }
        if (this.rStatStar.contains(mouseX, mouseY)) {
            RenderingDrawUtils.renderBlueTooltipString(this.rStatStar.x + this.rStatStar.width / 2, this.rStatStar.y + this.rStatStar.height, this.getGuiZLevel(), Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"perk.reader.astralsorcery.infostar", (Object[])new Object[0])}), this.font, false);
            return;
        }
        if (!this.foundSeals.func_190926_b() && rectSealBox.contains(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            List toolTip = this.foundSeals.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            toolTip.add(new StringTextComponent(""));
            toolTip.add(new TranslationTextComponent("perk.info.astralsorcery.sealed.usage", new Object[0]).func_211708_a(TextFormatting.GRAY));
            RenderingDrawUtils.renderBlueTooltipComponents(mouseX, mouseY, this.getGuiZLevel(), toolTip, this.font, false);
        } else {
            for (Map.Entry entry : this.thisFramePerks.entrySet()) {
                Collection<ITextComponent> modInfo;
                if (!((Rectangle2D.Float)entry.getValue()).contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop)) continue;
                LinkedList<ITextComponent> toolTip = new LinkedList<ITextComponent>();
                AbstractPerk perk = (AbstractPerk)entry.getKey();
                PlayerProgress prog = ResearchHelper.getClientProgress();
                perk.getLocalizedTooltip().forEach(line -> {
                    Style style = line.func_150256_b();
                    if (style.func_150215_a() == null) {
                        line.func_211708_a(TextFormatting.GRAY).func_211708_a(TextFormatting.ITALIC);
                    }
                    toolTip.add((ITextComponent)line);
                });
                if (prog.isPerkSealed(perk)) {
                    toolTip.add(new TranslationTextComponent("perk.info.astralsorcery.sealed", new Object[0]).func_211708_a(TextFormatting.RED));
                    toolTip.add(new TranslationTextComponent("perk.info.astralsorcery.sealed.break", new Object[0]).func_211708_a(TextFormatting.RED));
                } else if (prog.hasPerkUnlocked(perk)) {
                    toolTip.add(new TranslationTextComponent("perk.info.astralsorcery.active", new Object[0]).func_211708_a(TextFormatting.GREEN));
                } else if (perk.mayUnlockPerk(prog, (PlayerEntity)player)) {
                    toolTip.add(new TranslationTextComponent("perk.info.astralsorcery.available", new Object[0]).func_211708_a(TextFormatting.BLUE));
                } else {
                    toolTip.add(new TranslationTextComponent("perk.info.astralsorcery.locked", new Object[0]).func_211708_a(TextFormatting.GRAY));
                }
                if (Minecraft.func_71410_x().field_71474_y.field_82882_x && I18n.func_188566_a((String)perk.getCategory().getUnlocalizedName())) {
                    toolTip.add(new StringTextComponent(String.format("[%s]", perk.getCategory().getLocalizedName())).func_211708_a(TextFormatting.GRAY).func_211708_a(TextFormatting.ITALIC));
                }
                if ((modInfo = perk.getSource()) != null) {
                    for (ITextComponent cmp : modInfo) {
                        toolTip.add(cmp.func_211708_a(TextFormatting.BLUE).func_211708_a(TextFormatting.ITALIC));
                    }
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                    toolTip.add((ITextComponent)new StringTextComponent(""));
                    toolTip.add(new StringTextComponent(perk.getRegistryName().toString()).func_211708_a(TextFormatting.GRAY));
                    toolTip.add(new TranslationTextComponent("astralsorcery.misc.ctrlcopy", new Object[0]).func_211708_a(TextFormatting.GRAY));
                }
                RenderingDrawUtils.renderBlueTooltipComponents(mouseX, mouseY, this.getGuiZLevel(), toolTip, this.font, true);
                break;
            }
        }
    }

    private void drawSocketContextMenu() {
        this.rSocketMenu = null;
        this.slotsSocketMenu.clear();
        if (this.socketMenu != null) {
            AbstractPerk sMenuPerk = (AbstractPerk)((Object)this.socketMenu);
            Map<Integer, ItemStack> found = ItemUtils.findItemsIndexedInPlayerInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g, s -> !s.func_190926_b() && s.func_77973_b() instanceof ItemPerkGem && !DynamicModifierHelper.getStaticModifiers(s).isEmpty());
            if (found.isEmpty()) {
                this.closeSocketMenu();
                return;
            }
            Point2D.Float offset = this.sizeHandler.scalePointToGui(this, this.mousePosition, sMenuPerk.getPoint().getOffset());
            float offsetX = MathHelper.func_76141_d((float)offset.x);
            float offsetY = MathHelper.func_76141_d((float)offset.y);
            float scale = this.sizeHandler.getScalingFactor();
            float scaledSlotSize = 18.0f * scale;
            int realWidth = Math.min(5, found.size());
            int realHeight = found.size() / 5 + (found.size() % 5 == 0 ? 0 : 1);
            float width = (float)realWidth * scaledSlotSize;
            float height = (float)realHeight * scaledSlotSize;
            this.rSocketMenu = new Rectangle2D.Float(offsetX + 12.0f * scale - 4.0f, offsetY - 12.0f * scale - 4.0f, width + 4.0f, height + 4.0f);
            if (!this.guiBox.isInBox(this.rSocketMenu.x - (float)this.guiLeft, this.rSocketMenu.y - (float)this.guiTop) || !this.guiBox.isInBox(this.rSocketMenu.x + this.rSocketMenu.width - (float)this.guiLeft, this.rSocketMenu.y + this.rSocketMenu.height - (float)this.guiTop)) {
                this.closeSocketMenu();
                return;
            }
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)offsetX, (double)offsetY, (double)0.0);
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            RenderingDrawUtils.renderBlueTooltipBox(0, 0, realWidth * 18, realHeight * 18);
            RenderSystem.popMatrix();
            float inventoryOffsetX = offsetX + 12.0f * scale;
            float inventoryOffsetY = offsetY - 12.0f * scale;
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            TexturesAS.TEX_GUI_MENU_SLOT_GEM_CONTEXT.bindTexture();
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
                for (int index = 0; index < found.size(); ++index) {
                    float addedX = (float)(index % 5) * scaledSlotSize;
                    float addedY = (float)(index / 5) * scaledSlotSize;
                    RenderingGuiUtils.rect(buf, inventoryOffsetX + addedX, inventoryOffsetY + addedY, this.getGuiZLevel(), scaledSlotSize, scaledSlotSize).draw();
                }
            });
            RenderSystem.disableBlend();
            offsetX += 12.0f * scale;
            offsetY -= 12.0f * scale;
            int index = 0;
            for (Integer slotId : found.keySet()) {
                ItemStack stack = found.get(slotId);
                float addedX = (float)(index % 5) * scaledSlotSize;
                float addedY = (float)(index / 5) * scaledSlotSize;
                Rectangle2D.Float r = new Rectangle2D.Float(offsetX + addedX, offsetY + addedY, scaledSlotSize, scaledSlotSize);
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)(offsetX + addedX + 1.0f), (double)(offsetY + addedY + 1.0f), (double)0.0);
                RenderSystem.scaled((double)scale, (double)scale, (double)scale);
                RenderingUtils.renderItemStack(this.itemRenderer, stack, 0, 0, null);
                RenderSystem.popMatrix();
                this.slotsSocketMenu.put(r, slotId);
                ++index;
            }
        }
    }

    private void drawMiscInfo(int mouseX, int mouseY, float pTicks) {
        int availablePerks;
        PlayerProgress prog = ResearchHelper.getClientProgress();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (prog.getAttunedConstellation() != null && (availablePerks = prog.getAvailablePerkPoints((PlayerEntity)player, LogicalSide.CLIENT)) > 0) {
            RenderingDrawUtils.renderStringAtPos(this.guiLeft + 50, this.guiTop + 18, this.getGuiZLevel(), this.font, I18n.func_135052_a((String)"perk.info.astralsorcery.points", (Object[])new Object[]{availablePerks}), 0xCCCCCC, false);
        }
        MatrixStack renderStack = new MatrixStack();
        renderStack.func_227861_a_((double)(this.guiLeft + 288), (double)(this.guiTop + 20), (double)this.getGuiZLevel());
        this.rStatStar = RenderingDrawUtils.drawInfoStar(renderStack, IDrawRenderTypeBuffer.defaultBuffer(), 16.0f, pTicks);
        this.rStatStar.translate(this.guiLeft + 288, this.guiTop + 20);
    }

    private void drawSearchBox() {
        boolean addDots;
        TexturesAS.TEX_GUI_TEXT_FIELD.bindTexture();
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, this.guiLeft + 300, this.guiTop + 16, this.getGuiZLevel(), 88.5f, 15.0f).draw());
        RenderSystem.disableBlend();
        String text = this.searchTextEntry.getText();
        int length = this.font.func_78256_a(text);
        boolean bl = addDots = length > 75;
        while (length > 75) {
            text = text.substring(1);
            length = this.font.func_78256_a("..." + text);
        }
        if (addDots) {
            text = "..." + text;
        }
        if (ClientScheduler.getClientTick() % 20L > 10L) {
            text = text + "_";
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(this.guiLeft + 304), (double)(this.guiTop + 20), (double)this.getGuiZLevel());
        RenderingDrawUtils.renderStringAtCurrentPos(this.font, text, 0xCCCCCC);
        RenderSystem.popMatrix();
    }

    private void drawPerkTree(float partialTicks) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        PlayerProgress progress = ResearchHelper.getClientProgress();
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        TexturesAS.TEX_GUI_LINE_CONNECTION.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, arg_0 -> this.lambda$drawPerkTree$5(progress, (PlayerEntity)player, arg_0));
        RenderSystem.disableBlend();
        drawBuffer.beginDrawingPerks();
        ArrayList renderDynamic = Lists.newArrayList();
        for (PerkTreePoint<?> perkPoint : PerkTree.PERK_TREE.getPerkPoints(LogicalSide.CLIENT)) {
            Point2D.Float offset = perkPoint.getOffset();
            Rectangle2D.Float perkRect = this.drawPerk(drawBuffer, perkPoint, partialTicks, ClientScheduler.getClientTick() + (long)((int)offset.x) + (long)((int)offset.y), progress.isPerkSealed((AbstractPerk)perkPoint.getPerk()), renderDynamic);
            if (perkRect == null) continue;
            this.thisFramePerks.put((AbstractPerk)perkPoint.getPerk(), perkRect);
        }
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        drawBuffer.draw();
        RenderSystem.disableBlend();
        renderDynamic.forEach(Runnable::run);
        this.unlockEffects.keySet().removeIf(perk -> !this.drawPerkUnlock((AbstractPerk)perk, this.unlockEffects.get(perk)));
        this.breakEffects.keySet().removeIf(perk -> !this.drawPerkSealBreak((AbstractPerk)perk, this.breakEffects.get(perk), partialTicks));
    }

    private boolean drawPerkSealBreak(AbstractPerk perk, long tick, float pTicks) {
        SpriteSheetResource sealBreakSprite;
        int count = (int)(ClientScheduler.getClientTick() - tick);
        if (count >= (sealBreakSprite = SpritesAS.SPR_PERK_SEAL_BREAK).getFrameCount()) {
            return false;
        }
        Point2D.Float offset = this.sizeHandler.scalePointToGui(this, this.mousePosition, perk.getOffset());
        float sealFade = 1.0f - ((float)count + pTicks) / (float)sealBreakSprite.getFrameCount();
        float width = 22.0f;
        Rectangle2D.Float rct = this.thisFramePerks.get(perk);
        if (rct != null) {
            width = rct.width;
        }
        float sealWidth = width * 0.75f;
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        SpritesAS.SPR_PERK_SEAL.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            Point2D.Float pOffset = perk.getPoint().getOffset();
            this.drawSeal((BufferBuilder)buf, sealWidth, offset.x, offset.y, ClientScheduler.getClientTick() + (long)((int)pOffset.x) + (long)((int)pOffset.y), sealFade * 0.75f);
        });
        float uLength = sealBreakSprite.getUWidth();
        float vLength = sealBreakSprite.getVWidth();
        Tuple<Float, Float> uv = sealBreakSprite.getUVOffset(count);
        sealBreakSprite.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, offset.x - sealWidth, offset.y - sealWidth, this.getGuiZLevel(), sealWidth * 2.0f, sealWidth * 2.0f).color(1.0f, 1.0f, 1.0f, 0.85f).tex(((Float)uv.func_76341_a()).floatValue(), ((Float)uv.func_76340_b()).floatValue(), uLength, vLength).draw());
        RenderSystem.disableBlend();
        return true;
    }

    private boolean drawPerkUnlock(AbstractPerk perk, long tick) {
        SpriteSheetResource spritePerkUnlock;
        int count = (int)(ClientScheduler.getClientTick() - tick);
        if (count >= (spritePerkUnlock = SpritesAS.SPR_PERK_UNLOCK).getFrameCount()) {
            return false;
        }
        Point2D.Float offset = this.sizeHandler.scalePointToGui(this, this.mousePosition, perk.getOffset());
        float width = 22.0f;
        Rectangle2D.Float rct = this.thisFramePerks.get(perk);
        if (rct != null) {
            width = rct.width;
        }
        float unlockWidth = width * 2.5f;
        float uLength = spritePerkUnlock.getUWidth();
        float vLength = spritePerkUnlock.getVWidth();
        Tuple<Float, Float> uv = spritePerkUnlock.getUVOffset(count);
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        spritePerkUnlock.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, offset.x - unlockWidth, offset.y - unlockWidth, this.getGuiZLevel(), unlockWidth * 2.0f, unlockWidth * 2.0f).tex(((Float)uv.func_76341_a()).floatValue(), ((Float)uv.func_76340_b()).floatValue(), uLength, vLength).draw());
        RenderSystem.disableBlend();
        return true;
    }

    @Nullable
    private Rectangle2D.Float drawPerk(BatchPerkContext ctx, PerkTreePoint<?> perkPoint, float pTicks, long effectTick, boolean renderSeal, Collection<Runnable> outRenderDynamic) {
        Point2D.Float offset = this.sizeHandler.scalePointToGui(this, this.mousePosition, perkPoint.getOffset());
        float scale = this.sizeHandler.getScalingFactor();
        AllocationStatus status = ((AbstractPerk)perkPoint.getPerk()).getPerkStatus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT);
        Rectangle2D.Float drawSize = perkPoint.renderPerkAtBatch(ctx, status, effectTick, pTicks, offset.x, offset.y, this.getGuiZLevel(), scale);
        if (perkPoint instanceof DynamicPerkRender) {
            outRenderDynamic.add(() -> ((DynamicPerkRender)((Object)perkPoint)).renderAt(status, effectTick, pTicks, offset.x, offset.y, this.getGuiZLevel(), scale));
        }
        if (drawSize == null) {
            return null;
        }
        if (renderSeal) {
            this.drawSeal(ctx, (double)drawSize.width * 0.75, offset.x, offset.y, effectTick);
        }
        if (this.searchMatches.contains(perkPoint.getPerk())) {
            this.drawSearchMarkHalo(ctx, drawSize, offset.x, offset.y);
        }
        float mapDrawSize = 28.0f;
        if (perkPoint.getPerk() instanceof AttributeConverterProvider) {
            for (PerkConverter converter : ((AttributeConverterProvider)perkPoint.getPerk()).getConverters((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT, true)) {
                if (!(converter instanceof PerkConverter.Radius)) continue;
                float radius = ((PerkConverter.Radius)converter).getRadius();
                this.drawSearchHalo(ctx, mapDrawSize * radius * scale, offset.x, offset.y);
            }
        }
        return new Rectangle2D.Float(offset.x - drawSize.width / 2.0f, offset.y - drawSize.height / 2.0f, drawSize.width, drawSize.height);
    }

    private void drawSeal(BatchPerkContext ctx, double size, double x, double y, long spriteOffsetTick) {
        BufferContext batch = ctx.getContext(sealContext);
        this.drawSeal(batch, size, x, y, spriteOffsetTick, 1.0f);
    }

    private void drawSeal(BufferBuilder vb, double size, double x, double y, long spriteOffsetTick, float alpha) {
        SpriteSheetResource tex = SpritesAS.SPR_PERK_SEAL;
        if (tex == null) {
            return;
        }
        float uLength = tex.getULength();
        float vLength = tex.getVLength();
        Tuple<Float, Float> frameUV = tex.getUVOffset(spriteOffsetTick);
        Vector3 starVec = new Vector3(x - size, y - size, 0.0);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(size * (double)u * 2.0).addY(size * (double)v * 2.0);
            vb.func_225582_a_(pos.getX(), pos.getY(), pos.getZ()).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(((Float)frameUV.func_76341_a()).floatValue() + uLength * (float)u, ((Float)frameUV.func_76340_b()).floatValue() + vLength * (float)v).func_181675_d();
        }
    }

    private void drawSearchMarkHalo(BatchPerkContext ctx, Rectangle2D.Float draw, float x, float y) {
        this.drawSearchHalo(ctx, (draw.width + draw.height) / 2.0f, x, y);
    }

    private void drawSearchHalo(BatchPerkContext ctx, float size, float x, float y) {
        BufferContext batch = ctx.getContext(searchContext);
        SpriteSheetResource searchMark = SpritesAS.SPR_PERK_SEARCH;
        searchMark.bindTexture();
        Vector3 starVec = new Vector3(x - size, y - size, 0.0f);
        float uLength = searchMark.getUWidth();
        float vLength = searchMark.getVWidth();
        Tuple<Float, Float> frameUV = searchMark.getUVOffset();
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(size * (float)u * 2.0f).addY(size * (float)v * 2.0f);
            batch.func_225582_a_(pos.getX(), pos.getY(), pos.getZ()).func_227885_a_(0.8f, 0.1f, 0.1f, 1.0f).func_225583_a_(((Float)frameUV.func_76341_a()).floatValue() + uLength * (float)u, ((Float)frameUV.func_76340_b()).floatValue() + vLength * (float)v).func_181675_d();
        }
    }

    private void drawConnection(BufferBuilder vb, AllocationStatus status, Point2D.Float offset, Point2D.Float target, long effectTick) {
        Point2D.Float offsetSrc = this.sizeHandler.scalePointToGui(this, this.mousePosition, offset);
        Point2D.Float offsetDst = this.sizeHandler.scalePointToGui(this, this.mousePosition, target);
        Color overlay = Color.WHITE;
        switch (status) {
            case UNALLOCATED: {
                overlay = ColorsAS.PERK_CONNECTION_UNALLOCATED;
                break;
            }
            case ALLOCATED: {
                overlay = ColorsAS.PERK_CONNECTION_ALLOCATED;
                break;
            }
            case UNLOCKABLE: {
                overlay = ColorsAS.PERK_CONNECTION_UNLOCKABLE;
                break;
            }
        }
        double effectPart = (Math.sin(Math.toRadians((double)(effectTick * 8L) % 360.0)) + 1.0) / 4.0;
        float br = 0.1f + 0.4f * (2.0f - (float)effectPart);
        float rR = (float)overlay.getRed() / 255.0f * br;
        float rG = (float)overlay.getGreen() / 255.0f * br;
        float rB = (float)overlay.getBlue() / 255.0f * br;
        float rA = (float)overlay.getAlpha() / 255.0f * br;
        Vector3 fromStar = new Vector3(offsetSrc.x, offsetSrc.y, 0.0f);
        Vector3 toStar = new Vector3(offsetDst.x, offsetDst.y, 0.0f);
        double width = 4.0 * (double)this.sizeHandler.getScalingFactor();
        Vector3 dir = toStar.clone().subtract(fromStar);
        Vector3 degLot = dir.clone().crossProduct(new Vector3(0, 0, 1)).normalize().multiply(width);
        Vector3 vec00 = fromStar.clone().add(degLot);
        Vector3 vecV = degLot.clone().multiply(-2);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
            vb.func_225582_a_(pos.getX(), pos.getY(), pos.getZ()).func_227885_a_(rR, rG, rB, rA).func_225583_a_((float)u, (float)v).func_181675_d();
        }
    }

    @Override
    protected void mouseDragTick(double mouseX, double mouseY, double mouseDiffX, double mouseDiffY, double mouseOffsetX, double mouseOffsetY) {
        super.mouseDragTick(mouseX, mouseY, mouseDiffX, mouseDiffY, mouseOffsetX, mouseOffsetY);
        if (this.mouseSealStack.func_190926_b()) {
            this.moveMouse((float)mouseDiffX, (float)mouseDiffY);
        }
    }

    @Override
    protected void mouseDragStop(double mouseX, double mouseY, double mouseDiffX, double mouseDiffY) {
        super.mouseDragStop(mouseX, mouseY, mouseDiffX, mouseDiffY);
        if (this.mouseSealStack.func_190926_b()) {
            this.applyMovedMouseOffset();
        }
    }

    private void moveMouse(float changeX, float changeY) {
        if (this.previousMousePosition != null) {
            this.mousePosition.updateScaledPos(this.sizeHandler.clampX(this.previousMousePosition.getScaledPosX() + changeX), this.sizeHandler.clampY(this.previousMousePosition.getScaledPosY() + changeY), this.sizeHandler.getScalingFactor());
        } else {
            this.mousePosition.updateScaledPos(this.sizeHandler.clampX(changeX), this.sizeHandler.clampY(changeY), this.sizeHandler.getScalingFactor());
        }
    }

    private void applyMovedMouseOffset() {
        this.previousMousePosition = ScalingPoint.createPoint(this.mousePosition.getScaledPosX(), this.mousePosition.getScaledPosY(), this.sizeHandler.getScalingFactor(), true);
    }

    private void drawBackground() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        TexturesAS.TEX_GUI_BACKGROUND_PERKS.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, this.guiLeft - 10, this.guiTop - 10, this.getGuiZLevel(), this.guiWidth + 20, this.guiHeight + 20).color(0.65f, 0.65f, 0.65f, 1.0f).draw());
        RenderSystem.disableAlphaTest();
    }

    private void updateSearchHighlight() {
        this.searchMatches.clear();
        String matchText = this.searchTextEntry.getText().toLowerCase(Locale.ROOT);
        if (matchText.length() < 3) {
            return;
        }
        block0: for (PerkTreePoint<?> point : PerkTree.PERK_TREE.getPerkPoints(LogicalSide.CLIENT)) {
            Object perk = point.getPerk();
            if (perk instanceof ProgressGatedPerk && !((ProgressGatedPerk)perk).canSeeClient()) continue;
            if (I18n.func_188566_a((String)((AbstractPerk)perk).getCategory().getUnlocalizedName()) && ((AbstractPerk)perk).getCategory().getLocalizedName().toLowerCase(Locale.ROOT).contains(matchText)) {
                this.searchMatches.add((AbstractPerk)perk);
                continue;
            }
            for (ITextComponent tooltip : ((AbstractPerk)perk).getLocalizedTooltip()) {
                if (!tooltip.func_150254_d().toLowerCase(Locale.ROOT).contains(matchText)) continue;
                this.searchMatches.add((AbstractPerk)perk);
                continue block0;
            }
        }
        if (I18n.func_135052_a((String)"perk.info.astralsorcery.sealed", (Object[])new Object[0]).toLowerCase(Locale.ROOT).contains(matchText)) {
            PlayerProgress prog = ResearchHelper.getClientProgress();
            for (AbstractPerk sealed : prog.getSealedPerks()) {
                if (this.searchMatches.contains(sealed)) continue;
                this.searchMatches.add(sealed);
            }
        }
    }

    private void closeSocketMenu() {
        this.socketMenu = null;
        this.rSocketMenu = null;
        this.slotsSocketMenu.clear();
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        if (super.mouseReleased(mouseX, mouseY, state)) {
            return true;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!this.mouseSealStack.func_190926_b()) {
            this.mouseSealStack = ItemStack.field_190927_a;
            if (Minecraft.func_71410_x().field_71439_g == null) {
                return false;
            }
            PlayerProgress prog = ResearchHelper.getClientProgress();
            for (Map.Entry<AbstractPerk, Rectangle2D.Float> rctPerk : this.thisFramePerks.entrySet()) {
                if (!rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - (double)this.guiLeft, mouseY - (double)this.guiTop) || !prog.hasPerkUnlocked(rctPerk.getKey()) || prog.isPerkSealed(rctPerk.getKey()) || !ItemPerkSeal.useSeal((PlayerEntity)player, true)) continue;
                PktRequestPerkSealAction pkt = new PktRequestPerkSealAction(rctPerk.getKey(), true);
                PacketChannel.CHANNEL.sendToServer(pkt);
                return true;
            }
        }
        if (this.unlockPrimed == null) {
            return false;
        }
        for (Map.Entry<AbstractPerk, Rectangle2D.Float> rctPerk : this.thisFramePerks.entrySet()) {
            if (!this.unlockPrimed.equals(rctPerk.getKey()) || !rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - (double)this.guiLeft, mouseY - (double)this.guiTop) || !rctPerk.getKey().mayUnlockPerk(ResearchHelper.getClientProgress(), (PlayerEntity)player)) continue;
            PktUnlockPerk pkt = new PktUnlockPerk(false, rctPerk.getKey());
            PacketChannel.CHANNEL.sendToServer(pkt);
            break;
        }
        this.unlockPrimed = null;
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.sizeHandler.handleZoomOut();
            this.rescaleMouse();
            return true;
        }
        if (scroll > 0.0) {
            this.sizeHandler.handleZoomIn();
            this.rescaleMouse();
            return true;
        }
        return false;
    }

    private void rescaleMouse() {
        this.mousePosition.rescale(this.sizeHandler.getScalingFactor());
        if (this.previousMousePosition != null) {
            this.previousMousePosition.rescale(this.sizeHandler.getScalingFactor());
        }
        this.moveMouse(0.0f, 0.0f);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        this.unlockPrimed = null;
        return super.mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    @Override
    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        if (rectSearchTextEntry.contains(mouseX - (double)this.guiLeft, mouseY - (double)this.guiTop)) {
            this.searchTextEntry.setText("");
            return false;
        }
        if (this.socketMenu != null && this.rSocketMenu != null && !this.rSocketMenu.contains(mouseX, mouseY)) {
            this.closeSocketMenu();
            return false;
        }
        for (Map.Entry<AbstractPerk, Rectangle2D.Float> rctPerk : this.thisFramePerks.entrySet()) {
            AbstractPerk perk;
            if (!rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - (double)this.guiLeft, mouseY - (double)this.guiTop) || !((perk = rctPerk.getKey()) instanceof GemSlotPerk)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(this.socketMenu == null || mouseButton != 0 && mouseButton != 1 || this.rSocketMenu == null || this.rSocketMenu.contains(mouseX, mouseY))) {
            this.closeSocketMenu();
        }
        if (mouseButton == 0) {
            if (this.socketMenu != null) {
                for (Rectangle2D.Float r : this.slotsSocketMenu.keySet()) {
                    if (!r.contains(mouseX, mouseY) || this.socketMenu.hasItem((PlayerEntity)mc.field_71439_g, LogicalSide.CLIENT)) continue;
                    int slotId = this.slotsSocketMenu.get(r);
                    ItemStack potentialStack = mc.field_71439_g.field_71071_by.func_70301_a(slotId);
                    if (!potentialStack.func_190926_b() && !DynamicModifierHelper.getStaticModifiers(potentialStack).isEmpty()) {
                        PktPerkGemModification pkt = PktPerkGemModification.insertItem((AbstractPerk)((Object)this.socketMenu), slotId);
                        PacketChannel.CHANNEL.sendToServer(pkt);
                        this.closeSocketMenu();
                        SoundHelper.playSoundClient(SoundEvents.field_187567_bP, 0.35f, 9.0f);
                    }
                    return true;
                }
            }
            if (this.handleBookmarkClick(mouseX, mouseY)) {
                return true;
            }
            if (rectSealBox.contains(mouseX - (double)this.guiLeft, mouseY - (double)this.guiTop)) {
                if (!this.foundSeals.func_190926_b()) {
                    this.mouseSealStack = new ItemStack((IItemProvider)ItemsAS.PERK_SEAL);
                }
                return true;
            }
            if (this.rStatStar.contains(mouseX, mouseY)) {
                this.expectReinit = true;
                mc.func_147108_a((Screen)new ScreenJournalOverlayPerkStatistics(this));
                return true;
            }
        }
        PlayerProgress prog = ResearchHelper.getClientProgress();
        for (Map.Entry<AbstractPerk, Rectangle2D.Float> rctPerk : this.thisFramePerks.entrySet()) {
            if (!rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - (double)this.guiLeft, mouseY - (double)this.guiTop)) continue;
            AbstractPerk perk = rctPerk.getKey();
            if (mouseButton == 0 && mc.field_71474_y.field_74330_P && ScreenJournalPerkTree.hasControlDown()) {
                String perkKey = perk.getRegistryName().toString();
                Minecraft.func_71410_x().field_195559_v.func_197960_a(perkKey);
                mc.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.misc.ctrlcopy.copied", new Object[]{perkKey}));
                break;
            }
            if (mouseButton == 1) {
                if (!prog.hasPerkEffect(perk) || !(perk instanceof GemSlotPerk)) continue;
                if (((GemSlotPerk)((Object)perk)).hasItem((PlayerEntity)mc.field_71439_g, LogicalSide.CLIENT)) {
                    PktPerkGemModification pkt = PktPerkGemModification.dropItem(perk);
                    PacketChannel.CHANNEL.sendToServer(pkt);
                    AstralSorcery.getProxy().scheduleClientside(() -> {
                        if (mc.field_71462_r == this) {
                            this.updateSearchHighlight();
                        }
                    }, 10);
                    SoundHelper.playSoundClient(SoundEvents.field_187567_bP, 0.35f, 9.0f);
                } else {
                    this.socketMenu = (GemSlotPerk)((Object)perk);
                }
                return true;
            }
            if (mouseButton != 0) continue;
            if (perk.handleMouseClick(this, mouseX, mouseY)) {
                return true;
            }
            if (!prog.hasPerkUnlocked(perk) && perk.mayUnlockPerk(prog, (PlayerEntity)mc.field_71439_g)) {
                this.unlockPrimed = perk;
            } else if (this.sealBreakPrimed != null && this.tickSealBreak > 0) {
                PktRequestPerkSealAction pkt = new PktRequestPerkSealAction(perk, false);
                PacketChannel.CHANNEL.sendToServer(pkt);
            } else if (prog.isPerkSealed(perk)) {
                this.sealBreakPrimed = perk;
                this.tickSealBreak = 4;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.searchTextEntry.keyTyped(key)) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char charCode, int keyModifiers) {
        if (this.searchTextEntry.charTyped(charCode)) {
            return true;
        }
        return super.charTyped(charCode, keyModifiers);
    }

    public void playUnlockAnimation(AbstractPerk perk) {
        this.unlockEffects.put(perk, ClientScheduler.getClientTick());
        SoundHelper.playSoundClient(SoundsAS.PERK_UNLOCK, 0.5f, 1.0f);
    }

    public void playSealBreakAnimation(AbstractPerk perk) {
        this.updateSearchHighlight();
        this.breakEffects.put(perk, ClientScheduler.getClientTick());
        SoundHelper.playSoundClient(SoundsAS.PERK_UNSEAL, 0.5f, 1.0f);
    }

    public void playSealApplyAnimation(AbstractPerk perk) {
        this.updateSearchHighlight();
        SoundHelper.playSoundClient(SoundsAS.PERK_SEAL, 0.5f, 1.0f);
    }

    private /* synthetic */ void lambda$drawPerkTree$5(PlayerProgress progress, PlayerEntity player, BufferBuilder buf) {
        for (Tuple<AbstractPerk, AbstractPerk> perkConnection : PerkTree.PERK_TREE.getConnections()) {
            int alloc = 0;
            if (progress.hasPerkUnlocked((AbstractPerk)perkConnection.func_76341_a())) {
                ++alloc;
            }
            if (progress.hasPerkUnlocked((AbstractPerk)perkConnection.func_76340_b())) {
                ++alloc;
            }
            AllocationStatus status = alloc == 2 ? AllocationStatus.ALLOCATED : (alloc == 1 && progress.hasFreeAllocationPoint(player, LogicalSide.CLIENT) ? AllocationStatus.UNLOCKABLE : AllocationStatus.UNALLOCATED);
            Point2D.Float offsetOne = ((AbstractPerk)perkConnection.func_76341_a()).getPoint().getOffset();
            Point2D.Float offsetTwo = ((AbstractPerk)perkConnection.func_76340_b()).getPoint().getOffset();
            this.drawConnection(buf, status, offsetOne, offsetTwo, ClientScheduler.getClientTick() + (long)((int)offsetOne.x) + (long)((int)offsetOne.y) + (long)((int)offsetTwo.x) + (long)((int)offsetTwo.y));
        }
    }
}

