/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.page;

import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderPageRecipeTemplate;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInfusion;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class RenderPageLiquidInfusion
extends RenderPageRecipeTemplate {
    private LiquidInfusion recipe;

    public RenderPageLiquidInfusion(@Nullable ResearchNode node, int nodePage, LiquidInfusion recipe) {
        super(node, nodePage);
        this.recipe = recipe;
    }

    @Override
    public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
        this.clearFrameRectangles();
        this.renderRecipeGrid(offsetX, offsetY, zLevel, TexturesAS.TEX_GUI_BOOK_GRID_INFUSION);
        this.renderExpectedItemStackOutput(offsetX + 78.0f, offsetY + 25.0f, zLevel, 1.4f, this.recipe.getOutput(ItemStack.field_190927_a));
        this.renderInfoStar(offsetX, offsetY, zLevel, pTicks);
        float renderX = offsetX + 80.0f;
        float renderY = offsetY + 128.0f;
        this.renderItemStack(renderX, renderY + 15.0f, zLevel, 1.2f, new ItemStack((IItemProvider)BlocksAS.INFUSER));
        this.renderExpectedIngredientInput(renderX, renderY, zLevel, (double)1.2f, 0L, this.recipe.getItemInput());
        BlockAtlasTexture.getInstance().bindTexture();
        TextureAtlasSprite tas = RenderingUtils.getParticleTexture(new FluidStack(this.recipe.getLiquidInput(), 1000));
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 1, 0);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 2, 0);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 3, 0);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 1, 4);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 2, 4);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 3, 4);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 0, 1);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 0, 2);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 0, 3);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 4, 1);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 4, 2);
            this.renderLiquidInput((BufferBuilder)buf, offsetX, offsetY, zLevel, tas, 4, 3);
        });
    }

    private void renderLiquidInput(BufferBuilder buf, float offsetX, float offsetY, float zLevel, TextureAtlasSprite tas, int x, int y) {
        float liquidX = offsetX + 28.0f;
        float liquidY = offsetY + 76.0f;
        RenderingGuiUtils.rect(buf, liquidX + (float)x * 25.15f, liquidY + (float)y * 25.15f, zLevel, 22.3f, 22.3f).tex(tas).draw();
    }

    @Override
    public boolean propagateMouseClick(double mouseX, double mouseZ) {
        return this.handleBookLookupClick(mouseX, mouseZ);
    }

    @Override
    public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
        this.renderHoverTooltips(mouseX, mouseY, zLevel, this.recipe.func_199560_c());
        this.renderInfoStarTooltips(offsetX, offsetY, zLevel, mouseX, mouseY, toolTip -> {
            toolTip.add(new TranslationTextComponent("astralsorcery.journal.recipe.infusion.liquid", new Object[]{this.recipe.getLiquidInput().getAttributes().getDisplayName(new FluidStack(this.recipe.getLiquidInput(), 1000))}));
            toolTip.add(new TranslationTextComponent("astralsorcery.journal.recipe.infusion.chance.format", new Object[]{this.getInfuserChanceDescription(this.recipe.getConsumptionChance())}));
            if (this.recipe.doesConsumeMultipleFluids()) {
                toolTip.add(new TranslationTextComponent("astralsorcery.journal.recipe.infusion.multiple", new Object[0]));
            }
            if (!this.recipe.acceptsChaliceInput() && ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
                toolTip.add(new TranslationTextComponent("astralsorcery.journal.recipe.infusion.no_chalice", new Object[0]));
            }
            if (this.recipe.doesCopyNBTToOutputs()) {
                toolTip.add(new TranslationTextComponent("astralsorcery.journal.recipe.infusion.copy_nbt", new Object[0]));
            }
        });
    }
}

