/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.common.auxiliary.gateway.CelestialGatewayHandler;
import hellfirepvp.astralsorcery.common.constellation.ConstellationGenerator;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.util.PlayerReference;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.object.ObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.LogicalSide;

public class GatewayUI {
    private final ResourceLocation dimType;
    private final BlockPos pos;
    private final Vector3 renderCenter;
    private final double sphereRadius;
    private final Map<UUID, IConstellation> playerConstellations = new HashMap<UUID, IConstellation>();
    private final List<GatewayEntry> gatewayEntries = new ArrayList<GatewayEntry>();
    private int visibleTicks = 20;

    private GatewayUI(ResourceLocation dimType, BlockPos pos, Vector3 renderCenter, double sphereRadius) {
        this.dimType = dimType;
        this.pos = pos;
        this.renderCenter = renderCenter;
        this.sphereRadius = sphereRadius;
        this.initializePlayerConstellations();
    }

    private void initializePlayerConstellations() {
        if (!this.getThisGatewayNode().isLocked() || this.getThisGatewayNode().getAllowedUsers().isEmpty()) {
            return;
        }
        for (PlayerReference playerRef : this.getThisGatewayNode().getAllowedUsers().values()) {
            UUID playerUUID = playerRef.getPlayerUUID();
            long plSeed = playerUUID.getMostSignificantBits() ^ playerUUID.getLeastSignificantBits();
            Random sRand = new Random(plSeed);
            for (int i = 0; i < sRand.nextInt(5); ++i) {
                sRand.nextLong();
            }
            this.playerConstellations.put(playerUUID, ConstellationGenerator.generateRandom(sRand.nextLong()));
        }
    }

    public static GatewayUI create(IWorld world, BlockPos tilePos, Vector3 renderPos, double sphereRadius) {
        GatewayCache.GatewayNode gatewayNode = CelestialGatewayHandler.INSTANCE.getGatewayNode(world, LogicalSide.CLIENT, tilePos);
        if (gatewayNode == null) {
            return null;
        }
        ResourceLocation dimType = world.func_201675_m().func_186058_p().getRegistryName();
        GatewayUI ui = new GatewayUI(dimType, tilePos, renderPos, sphereRadius);
        ClientPlayerEntity thisPlayer = Minecraft.func_71410_x().field_71439_g;
        for (GatewayCache.GatewayNode node : CelestialGatewayHandler.INSTANCE.getGatewaysForWorld(world, LogicalSide.CLIENT)) {
            if (!node.hasAccess((PlayerEntity)thisPlayer)) continue;
            GatewayUI.appendEntry(ui, node, dimType, true, sphereRadius);
        }
        CelestialGatewayHandler.INSTANCE.getGatewayCache(LogicalSide.CLIENT).forEach((arg_0, arg_1) -> GatewayUI.lambda$create$0(dimType, (PlayerEntity)thisPlayer, ui, sphereRadius, arg_0, arg_1));
        return ui;
    }

    private static void appendEntry(GatewayUI ui, GatewayCache.GatewayNode node, ResourceLocation nodeDimType, boolean sameWorld, double sphereRadius) {
        Vector3 renderPos = ui.getRenderCenter();
        Vector3 nodePos = new Vector3((Vec3i)node.getPos());
        if (sameWorld) {
            if (renderPos.distance(nodePos) < 16.0) {
                return;
            }
            Vector3 dir = nodePos.subtract(renderPos);
            dir.setY(Math.max(dir.getY(), 0.0));
            Vector3 sphereDirection = dir.normalize().multiply(sphereRadius);
            GatewayEntry entry = new GatewayEntry(node, nodeDimType, sphereDirection);
            ObjectReference<Object> overlapping = new ObjectReference<Object>(null);
            ui.gatewayEntries.removeIf(otherEntry -> {
                if (Math.abs(((GatewayEntry)otherEntry).pitch - entry.pitch) < 7.0f && (Math.abs(((GatewayEntry)otherEntry).yaw - entry.yaw) <= 7.0f || Math.abs(((GatewayEntry)otherEntry).yaw - entry.yaw - 360.0f) <= 7.0f)) {
                    if (renderPos.distanceSquared(entry.getRelativePos()) < renderPos.distanceSquared(otherEntry.getRelativePos())) {
                        return true;
                    }
                    overlapping.set(otherEntry);
                    return false;
                }
                return false;
            });
            if (overlapping.get() == null) {
                ui.gatewayEntries.add(entry);
            }
        } else {
            long seed = -6395079716991528811L;
            seed |= (long)node.getPos().func_177958_n() << 48;
            seed |= (long)node.getPos().func_177956_o() << 24;
            Random rand = new Random(seed |= (long)node.getPos().func_177952_p());
            Vector3 direction = Vector3.positiveYRandom(rand).normalize().multiply(sphereRadius);
            GatewayEntry entry = new GatewayEntry(node, nodeDimType, direction);
            boolean foundSpace = false;
            for (int tries = 50; !foundSpace && tries > 0; --tries) {
                boolean mayAdd = true;
                for (GatewayEntry otherEntry2 : ui.gatewayEntries) {
                    if (!(Math.abs(otherEntry2.pitch - entry.pitch) < 15.0f) || !(Math.abs(otherEntry2.yaw - entry.yaw) <= 15.0f) && !(Math.abs(otherEntry2.yaw - entry.yaw - 360.0f) <= 15.0f)) continue;
                    mayAdd = false;
                    break;
                }
                if (mayAdd) {
                    foundSpace = true;
                    continue;
                }
                direction = Vector3.positiveYRandom(rand).normalize().multiply(sphereRadius);
                entry = new GatewayEntry(node, nodeDimType, direction);
            }
            if (foundSpace) {
                ui.gatewayEntries.add(entry);
            }
        }
    }

    public ResourceLocation getDimType() {
        return this.dimType;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Vector3 getRenderCenter() {
        return this.renderCenter;
    }

    public double getSphereRadius() {
        return this.sphereRadius;
    }

    @Nullable
    public GatewayCache.GatewayNode getThisGatewayNode() {
        return CelestialGatewayHandler.INSTANCE.getGatewayNode((IWorld)Minecraft.func_71410_x().field_71441_e, LogicalSide.CLIENT, this.getPos());
    }

    @Nullable
    public IConstellation getGeneratedConstellation(UUID playerUUID) {
        return this.playerConstellations.get(playerUUID);
    }

    public List<GatewayEntry> getGatewayEntries() {
        return Collections.unmodifiableList(this.gatewayEntries);
    }

    public void refreshView() {
        this.visibleTicks = 20;
    }

    public int getVisibleTicks() {
        return this.visibleTicks;
    }

    public void decrementVisibleTicks() {
        --this.visibleTicks;
    }

    private static /* synthetic */ void lambda$create$0(ResourceLocation dimType, PlayerEntity thisPlayer, GatewayUI ui, double sphereRadius, ResourceLocation dimTypeKey, Collection gatewayNodes) {
        if (dimTypeKey.equals((Object)dimType)) {
            return;
        }
        for (GatewayCache.GatewayNode node : gatewayNodes) {
            if (!node.hasAccess(thisPlayer)) continue;
            GatewayUI.appendEntry(ui, node, dimTypeKey, false, sphereRadius);
        }
    }

    public static class GatewayEntry {
        private final GatewayCache.GatewayNode node;
        private final ResourceLocation nodeDimension;
        private final Vector3 relativePos;
        private final float yaw;
        private final float pitch;

        private GatewayEntry(GatewayCache.GatewayNode node, ResourceLocation nodeDimension, Vector3 relativePos) {
            this.node = node;
            this.nodeDimension = nodeDimension;
            this.relativePos = relativePos.clone();
            if (this.relativePos.getY() < 0.0) {
                this.relativePos.setY(0);
            }
            Vector3 angles = relativePos.copyToPolar();
            this.yaw = (float)(180.0 - angles.getZ());
            this.pitch = Math.min(0.0f, (float)(-90.0 + angles.getY()));
        }

        public GatewayCache.GatewayNode getNode() {
            return this.node;
        }

        public ResourceLocation getNodeDimension() {
            return this.nodeDimension;
        }

        public Vector3 getRelativePos() {
            return this.relativePos;
        }

        public float getYaw() {
            return this.yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GatewayEntry that = (GatewayEntry)o;
            return Objects.equals(this.node, that.node) && Objects.equals(this.nodeDimension, that.nodeDimension);
        }

        public int hashCode() {
            return Objects.hash(this.node, this.nodeDimension);
        }
    }
}

