/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.camera.path;

import hellfirepvp.astralsorcery.client.util.camera.EntityCameraRenderView;
import hellfirepvp.astralsorcery.client.util.camera.EntityClientReplacement;
import hellfirepvp.astralsorcery.client.util.camera.ICameraPersistencyFunction;
import hellfirepvp.astralsorcery.client.util.camera.ICameraStopListener;
import hellfirepvp.astralsorcery.client.util.camera.ICameraTickListener;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class CameraPath
extends EntityCameraRenderView
implements ICameraPersistencyFunction {
    LinkedList<PathPoint> pathPoints = new LinkedList();
    private final Vector3 startVector;
    private final Vector3 focus;
    private ICameraTickListener delegate;
    private ICameraStopListener stopDelegate;
    private int totalTickDuration = 0;
    private boolean expired = false;
    private boolean stopped = false;

    CameraPath(Vector3 startPoint, Vector3 focusPoint, @Nullable ICameraTickListener tick) {
        this.startVector = startPoint;
        this.focus = focusPoint;
        this.func_226288_n_(startPoint.getX(), startPoint.getY(), startPoint.getZ());
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.delegate = tick;
        this.setCameraFocus(focusPoint);
        this.transformToFocusOnPoint(focusPoint, 0.0f, false);
    }

    public void setTickListener(ICameraTickListener delegate) {
        this.delegate = delegate;
    }

    public void setStopListener(ICameraStopListener delegate) {
        this.stopDelegate = delegate;
    }

    void addPoint(Vector3 point, int ticks) {
        this.pathPoints.addLast(new PathPoint(point, ticks));
        this.totalTickDuration += ticks;
    }

    @Override
    public void moveEntityTick(EntityCameraRenderView entity, EntityClientReplacement replacement, int ticksExisted) {
        if (this.delegate != null) {
            this.delegate.onCameraTick(entity, replacement);
        }
        this.setCameraFocus(Vector3.atEntityCenter((Entity)replacement));
        boolean bl = this.expired = this.field_70173_aa > this.totalTickDuration;
        if (this.pathPoints.isEmpty()) {
            this.expired = true;
        } else {
            Vector3 position = this.queryByTicks(ticksExisted);
            this.field_70169_q = this.func_226277_ct_();
            this.field_70167_r = this.func_226278_cu_();
            this.field_70166_s = this.func_226281_cx_();
            this.func_226288_n_(position.getX(), position.getY(), position.getZ());
        }
    }

    @Override
    public void onStopTransforming() {
        if (this.stopDelegate != null && Minecraft.func_71410_x().field_71441_e != null) {
            this.stopDelegate.onCameraStop();
        }
    }

    private Vector3 queryByTicks(int ticks) {
        if (ticks <= 0) {
            return this.startVector;
        }
        int acc = 0;
        PathPoint current = null;
        for (PathPoint point : this.pathPoints) {
            int accumulator = acc + point.ticksToGetThere;
            Vector3 prev = current == null ? this.startVector : current.dstPoint;
            current = point;
            if (accumulator >= ticks) {
                int interp = current.ticksToGetThere - (accumulator - ticks);
                int dstJump = current.ticksToGetThere;
                return current.dstPoint.clone().subtract(prev).divide(dstJump).multiply(MathHelper.func_76125_a((int)interp, (int)1, (int)dstJump)).add(prev);
            }
            acc = accumulator;
        }
        return this.pathPoints.getLast().dstPoint;
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    @Override
    public void setExpired() {
        this.expired = true;
    }

    @Override
    public void forceStop() {
        this.stopped = true;
        this.setExpired();
    }

    @Override
    public boolean wasForciblyStopped() {
        return this.stopped;
    }

    CameraPath copy() {
        CameraPath c = new CameraPath(this.startVector, this.focus, this.delegate);
        for (PathPoint fp : this.pathPoints) {
            c.pathPoints.addLast(new PathPoint(fp.dstPoint, fp.ticksToGetThere));
        }
        c.totalTickDuration = this.totalTickDuration;
        return c;
    }

    private static class PathPoint {
        private final Vector3 dstPoint;
        private final int ticksToGetThere;

        PathPoint(Vector3 dstPoint, int ticksToGetThere) {
            this.dstPoint = dstPoint;
            this.ticksToGetThere = ticksToGetThere;
        }
    }
}

