/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.advancement.instance;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.advancement.AltarCraftTrigger;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class AltarRecipeInstance
extends CriterionInstance {
    private Set<ResourceLocation> recipeNames = new HashSet<ResourceLocation>();
    private List<Ingredient> recipeOutputs = new ArrayList<Ingredient>();

    private AltarRecipeInstance(ResourceLocation id) {
        super(id);
    }

    public static AltarRecipeInstance craftRecipe(ResourceLocation ... recipeIds) {
        AltarRecipeInstance instance = new AltarRecipeInstance(AltarCraftTrigger.ID);
        instance.recipeNames.addAll(Arrays.asList(recipeIds));
        return instance;
    }

    public static AltarRecipeInstance craftRecipe(SimpleAltarRecipe ... recipes) {
        AltarRecipeInstance instance = new AltarRecipeInstance(AltarCraftTrigger.ID);
        Arrays.asList(recipes).forEach(recipe -> instance.recipeNames.add(recipe.func_199560_c()));
        return instance;
    }

    public static AltarRecipeInstance withOutput(IItemProvider ... outputs) {
        return AltarRecipeInstance.withOutput(Ingredient.func_199804_a((IItemProvider[])outputs));
    }

    public static AltarRecipeInstance withOutput(ItemStack ... outputs) {
        return AltarRecipeInstance.withOutput(Ingredient.func_193369_a((ItemStack[])outputs));
    }

    public static AltarRecipeInstance withOutput(Tag<Item> ... outputs) {
        return AltarRecipeInstance.withOutput(Arrays.stream(outputs).map(Ingredient::func_199805_a).collect(Collectors.toList()));
    }

    public static AltarRecipeInstance withOutput(Ingredient ... outputs) {
        return AltarRecipeInstance.withOutput(Arrays.asList(outputs));
    }

    public static AltarRecipeInstance withOutput(List<Ingredient> outputs) {
        AltarRecipeInstance instance = new AltarRecipeInstance(AltarCraftTrigger.ID);
        instance.recipeOutputs.addAll(outputs);
        return instance;
    }

    public JsonElement func_200288_b() {
        JsonObject out = new JsonObject();
        if (!this.recipeNames.isEmpty()) {
            JsonArray names = new JsonArray();
            for (ResourceLocation name : this.recipeNames) {
                names.add(name.toString());
            }
            out.add("recipeNames", (JsonElement)names);
        }
        if (!this.recipeOutputs.isEmpty()) {
            JsonArray outputs = new JsonArray();
            for (Ingredient output : this.recipeOutputs) {
                outputs.add(output.func_200304_c());
            }
            out.add("recipeOutputs", (JsonElement)outputs);
        }
        return out;
    }

    public static AltarRecipeInstance deserialize(ResourceLocation id, JsonObject json) {
        AltarRecipeInstance instance = new AltarRecipeInstance(id);
        JsonArray recipeNames = JSONUtils.func_151213_a((JsonObject)json, (String)"recipeNames", (JsonArray)new JsonArray());
        for (int idx = 0; idx < recipeNames.size(); ++idx) {
            JsonElement element = recipeNames.get(idx);
            String key = JSONUtils.func_151206_a((JsonElement)element, (String)String.format("recipeNames[%s]", idx));
            instance.recipeNames.add(new ResourceLocation(key));
        }
        for (JsonElement element : JSONUtils.func_151213_a((JsonObject)json, (String)"recipeOutputs", (JsonArray)new JsonArray())) {
            instance.recipeOutputs.add(Ingredient.func_199802_a((JsonElement)element));
        }
        return instance;
    }

    public boolean test(SimpleAltarRecipe recipe, ItemStack output) {
        if (this.recipeNames.isEmpty() && this.recipeOutputs.isEmpty()) {
            return true;
        }
        ResourceLocation recipeName = recipe.func_199560_c();
        if (this.recipeNames.contains(recipeName)) {
            return true;
        }
        for (Ingredient i : this.recipeOutputs) {
            if (!i.test(output)) continue;
            return true;
        }
        return false;
    }
}

