/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.link;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public interface LinkableTileEntity {
    default public World getLinkWorld() {
        if (this instanceof TileEntity) {
            return ((TileEntity)this).func_145831_w();
        }
        throw new IllegalStateException("LinkableTileEntity not implemented on TileEntity: " + this.getClass());
    }

    default public BlockPos getLinkPos() {
        if (this instanceof TileEntity) {
            return ((TileEntity)this).func_174877_v();
        }
        throw new IllegalStateException("LinkableTileEntity not implemented on TileEntity: " + this.getClass());
    }

    @Nullable
    default public String getUnLocalizedDisplayName() {
        if (this instanceof TileEntity) {
            BlockState state = ((TileEntity)this).func_195044_w();
            return state.func_177230_c().func_149739_a();
        }
        throw new IllegalStateException("LinkableTileEntity not implemented on TileEntity: " + this.getClass());
    }

    default public boolean doesAcceptLinks() {
        return true;
    }

    public void onBlockLinkCreate(PlayerEntity var1, BlockPos var2);

    public void onEntityLinkCreate(PlayerEntity var1, LivingEntity var2);

    default public boolean onSelect(PlayerEntity player) {
        if (player.func_225608_bj_()) {
            for (BlockPos linkTo : Lists.newArrayList(this.getLinkedPositions())) {
                this.tryUnlink(player, linkTo);
            }
            player.func_145747_a(new TranslationTextComponent("astralsorcery.misc.link.unlink.all", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            return false;
        }
        return true;
    }

    public boolean tryLinkBlock(PlayerEntity var1, BlockPos var2);

    public boolean tryLinkEntity(PlayerEntity var1, LivingEntity var2);

    public boolean tryUnlink(PlayerEntity var1, BlockPos var2);

    public List<BlockPos> getLinkedPositions();
}

