/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.TriFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.trees.Tree;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.BlockSnapshot;

public class TreeType {
    private static final List<TreeType> TYPES = new ArrayList<TreeType>();
    private final BiPredicate<World, BlockPos> treeTest;
    private final TriFunction<ServerWorld, BlockPos, Random, Supplier<List<BlockPos>>> treeGenerator;

    private TreeType(BiPredicate<World, BlockPos> treeTest, TriFunction<ServerWorld, BlockPos, Random, Supplier<List<BlockPos>>> treeGenerator) {
        this.treeTest = treeTest;
        this.treeGenerator = treeGenerator;
    }

    public static TreeType register(BiPredicate<World, BlockPos> treeTest, TriFunction<ServerWorld, BlockPos, Random, Supplier<List<BlockPos>>> treeGenerator) {
        TreeType type = new TreeType(treeTest, treeGenerator);
        TYPES.add(type);
        return type;
    }

    public Supplier<List<BlockPos>> getTreeGenerator(ServerWorld world, BlockPos pos, Random rand) {
        return this.treeGenerator.apply(world, pos, rand);
    }

    @Nullable
    public static TreeType isTree(World world, BlockPos pos) {
        for (TreeType type : TYPES) {
            if (!type.treeTest.test(world, pos)) continue;
            return type;
        }
        return null;
    }

    static {
        TreeType.register((world, pos) -> {
            BlockState state = world.func_180495_p(pos);
            return state.func_177230_c() instanceof SaplingBlock && ((SaplingBlock)state.func_177230_c()).field_196387_c != null;
        }, (world, pos, rand) -> {
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof SaplingBlock) {
                Tree treeFeature = ((SaplingBlock)state.func_177230_c()).field_196387_c;
                return () -> {
                    List<BlockSnapshot> blockSnapshots = MiscUtils.captureBlockChanges((World)world, () -> treeFeature.func_225545_a_((IWorld)world, world.func_72863_F().func_201711_g(), pos, state, rand));
                    return blockSnapshots.stream().filter(snapshot -> {
                        Block b = snapshot.getCurrentBlock().func_177230_c();
                        return b.func_203417_a(BlockTags.field_206952_E) || b.func_203417_a(BlockTags.field_200031_h) || b instanceof VineBlock;
                    }).map(BlockSnapshot::getPos).collect(Collectors.toList());
                };
            }
            return Collections::emptyList;
        });
    }
}

