/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.entity;

import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PatreonPartialEntity {
    protected static final Random rand = new Random();
    private final UUID ownerUUID;
    private final UUID effectUUID;
    protected Vector3 pos = new Vector3();
    protected Vector3 prevPos = new Vector3();
    protected Vector3 motion = new Vector3();
    protected boolean removed = false;
    protected boolean updatePos = false;
    private Integer lastTickedDimension = null;

    public PatreonPartialEntity(UUID effectUUID, UUID ownerUUID) {
        this.effectUUID = effectUUID;
        this.ownerUUID = ownerUUID;
    }

    public UUID getEffectUUID() {
        return this.effectUUID;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public Vector3 getPos() {
        return this.pos;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @Nullable
    public PatreonEffect getEffect() {
        return PatreonEffectHelper.getEffect(this.getEffectUUID());
    }

    @Nullable
    public Integer getLastTickedDimension() {
        return this.lastTickedDimension;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickClient() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickEffects(IWorld world) {
    }

    public boolean tick(IWorld world) {
        boolean changed = this.lastTickedDimension == null || this.lastTickedDimension.intValue() != world.func_201675_m().func_186058_p().func_186068_a();
        this.lastTickedDimension = world.func_201675_m().func_186058_p().func_186068_a();
        if (this.updateMotion(world)) {
            changed = true;
        }
        if (this.tryMoveEntity(world)) {
            changed = true;
        }
        if (world.func_201670_d()) {
            this.tickEffects(world);
        }
        return changed;
    }

    private boolean updateMotion(IWorld world) {
        Vector3 prevMot = this.motion.clone();
        PlayerEntity target = this.findOwner(world);
        if (target == null) {
            this.motion = new Vector3();
        } else {
            Vector3 moveTarget = Vector3.atEntityCenter((Entity)target).addY(1.5);
            if (moveTarget.distanceSquared(this.pos) <= 3.0) {
                this.motion.multiply(0.95f);
            } else {
                double diffX = (moveTarget.getX() - this.pos.getX()) / 8.0;
                double diffY = (moveTarget.getY() - this.pos.getY()) / 8.0;
                double diffZ = (moveTarget.getZ() - this.pos.getZ()) / 8.0;
                double dist = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
                this.motion = new Vector3(diffX * dist, diffY * dist, diffZ * dist);
            }
        }
        return !this.motion.equals(prevMot);
    }

    private boolean tryMoveEntity(IWorld world) {
        this.prevPos = this.pos.clone();
        PlayerEntity owner = this.findOwner(world);
        if (owner != null && this.pos.distance(Vector3.atEntityCenter((Entity)owner)) >= 16.0) {
            this.placeNear(owner);
            return true;
        }
        this.pos.add(this.motion);
        return !this.pos.equals(this.prevPos);
    }

    public void placeNear(PlayerEntity player) {
        this.pos = Vector3.atEntityCenter((Entity)player).setY(player.func_226278_cu_()).addY(player.func_213302_cg()).add(Vector3.random().setY(0).normalize());
        this.prevPos = this.pos.clone();
        this.motion = new Vector3();
        this.updatePos = true;
    }

    @Nullable
    public PlayerEntity findOwner(IWorld world) {
        return world.func_217371_b(this.ownerUUID);
    }

    public void readFromNBT(CompoundNBT cmp) {
        this.lastTickedDimension = cmp.func_74762_e("lastTickedDimension");
        if (cmp.func_74764_b("pos") && cmp.func_74764_b("prevPos")) {
            this.pos = NBTHelper.readVector3(cmp.func_74775_l("pos"));
            this.prevPos = NBTHelper.readVector3(cmp.func_74775_l("prevPos"));
        }
    }

    public void writeToNBT(CompoundNBT cmp) {
        cmp.func_74768_a("lastTickedDimension", this.lastTickedDimension == null ? 0 : this.lastTickedDimension);
        if (this.updatePos) {
            cmp.func_218657_a("pos", (INBT)NBTHelper.writeVector3(this.pos));
            cmp.func_218657_a("prevPos", (INBT)NBTHelper.writeVector3(this.prevPos));
            this.updatePos = false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatreonPartialEntity that = (PatreonPartialEntity)o;
        return Objects.equals(this.effectUUID, that.effectUUID);
    }

    public int hashCode() {
        return Objects.hash(this.effectUUID);
    }
}

