/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.base;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.tile.base.TileFakedState;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BlockFakedState
extends ContainerBlock {
    protected BlockFakedState(Block.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playParticles(World world, BlockPos pos, Random rand) {
        if (rand.nextInt(8) == 0) {
            VFXColorFunction<EntityVisualFX> colorFn = VFXColorFunction.WHITE;
            TileFakedState fakedState = MiscUtils.getTileAt((IBlockReader)world, pos, TileFakedState.class, false);
            if (fakedState != null) {
                colorFn = VFXColorFunction.constant(fakedState.getOverlayColor());
            }
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.random().abs().add((Vec3i)pos))).alpha(VFXAlphaFunction.FADE_OUT)).color(colorFn)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.05f)).setMaxAge(25 + rand.nextInt(5));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        BlockState fakeState = this.getFakedState((IBlockReader)world, pos);
        RenderingUtils.playBlockBreakParticles(pos, state, fakeState);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        BlockState fakeState = this.getFakedState((IBlockReader)world, pos);
        return fakeState.getSoundType(world, pos, entity);
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        BlockState fakeState = this.getFakedState(world, pos);
        return fakeState.func_215700_a(world, pos, context);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Lists.newArrayList();
    }

    public Vec3d func_190949_e(BlockState state, IBlockReader worldIn, BlockPos pos) {
        BlockState fakeState = this.getFakedState(worldIn, pos);
        try {
            return fakeState.func_191059_e(worldIn, pos);
        }
        catch (Exception exception) {
            return Vec3d.field_186680_a;
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        BlockState fakeState = this.getFakedState(worldIn, pos);
        try {
            return fakeState.func_215685_b(worldIn, pos, context);
        }
        catch (Exception exception) {
            return super.func_220071_b(state, worldIn, pos, context);
        }
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        BlockState fakeState = this.getFakedState(worldIn, pos);
        try {
            return fakeState.func_196951_e(worldIn, pos);
        }
        catch (Exception exception) {
            return super.func_196247_c(state, worldIn, pos);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockState fakeState = this.getFakedState((IBlockReader)world, pos);
        try {
            return fakeState.func_227031_a_(world, player, handIn, hit);
        }
        catch (Exception exception) {
            return super.func_225533_a_(state, world, pos, player, handIn, hit);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockState fakeState = this.getFakedState(world, pos);
        try {
            return fakeState.getPickBlock(target, world, pos, player);
        }
        catch (Exception exception) {
            return ItemStack.field_190927_a;
        }
    }

    @Nonnull
    private BlockState getFakedState(IBlockReader world, BlockPos pos) {
        TileFakedState tb = MiscUtils.getTileAt(world, pos, TileFakedState.class, true);
        return tb != null ? tb.getFakedState() : Blocks.field_150350_a.func_176223_P();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }
}

