/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile;

import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.properties.PropertiesGlass;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.item.ItemAquamarine;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.DataAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.util.ColorUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.observerlib.api.block.BlockStructureObserver;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;

public class BlockCelestialGateway
extends ContainerBlock
implements CustomItemBlock,
BlockStructureObserver {
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375);

    public BlockCelestialGateway() {
        super(PropertiesGlass.coatedGlass().func_200951_a(12).func_200948_a(-1.0f, 3600000.0f).harvestLevel(1).harvestTool(ToolType.PICKAXE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        DyeColor color = BlockCelestialGateway.getColor(stack);
        if (color != null) {
            tooltip.add(ColorUtils.getTranslation(color).func_211708_a(ColorUtils.textFormattingForDye(color)));
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = new ItemStack((IItemProvider)BlocksAS.GATEWAY);
        TileCelestialGateway gateway = MiscUtils.getTileAt(world, pos, TileCelestialGateway.class, true);
        if (gateway != null) {
            if (gateway.func_145818_k_()) {
                stack.func_200302_a(gateway.func_145748_c_());
            }
            gateway.getColor().ifPresent(color -> BlockCelestialGateway.setColor(stack, color));
        }
        return stack;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileCelestialGateway gateway = MiscUtils.getTileAt((IBlockReader)world, pos, TileCelestialGateway.class, false);
        if (gateway != null && gateway.getOwner() != null && gateway.getOwner().isPlayer(player)) {
            if (gateway.isLocked()) {
                if (!world.func_201670_d()) {
                    ItemStack remaining = ItemUtils.dropItemToPlayer(player, new ItemStack((IItemProvider)ItemsAS.AQUAMARINE));
                    if (!remaining.func_190926_b()) {
                        ItemUtils.dropItemNaturally(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), remaining);
                    }
                    gateway.unlock();
                }
                return ActionResultType.SUCCESS;
            }
            ItemStack held = player.func_184586_b(hand);
            if (held.func_77973_b() instanceof ItemAquamarine) {
                if (!world.func_201670_d()) {
                    held.func_190918_g(1);
                    gateway.lock();
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileCelestialGateway gateway = MiscUtils.getTileAt((IBlockReader)world, pos, TileCelestialGateway.class, true);
        if (gateway != null) {
            DyeColor color;
            if (stack.func_82837_s()) {
                gateway.setDisplayText(stack.func_200301_q());
            }
            if ((color = BlockCelestialGateway.getColor(stack)) != null) {
                gateway.setColor(color);
            }
        }
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        TileCelestialGateway gateway = MiscUtils.getTileAt(world, pos, TileCelestialGateway.class, true);
        if (gateway != null && (!gateway.isLocked() || gateway.getOwner() != null && gateway.getOwner().isPlayer(player))) {
            int i = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) ? 30 : 100;
            return player.getDigSpeed(state, pos) / 2.5f / (float)i;
        }
        return this.field_149782_v;
    }

    public float func_176195_g(BlockState blockState, IBlockReader world, BlockPos pos) {
        TileCelestialGateway gateway = MiscUtils.getTileAt(world, pos, TileCelestialGateway.class, true);
        if (gateway != null && gateway.isLocked() && gateway.getOwner() != null) {
            return -1.0f;
        }
        return this.field_149782_v;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moving) {
        if (state != newState && !world.func_201670_d()) {
            ((GatewayCache)DataAS.DOMAIN_AS.getData((IWorld)world, DataAS.KEY_GATEWAY_CACHE)).removePosition(world, pos);
            TileCelestialGateway gateway = MiscUtils.getTileAt((IBlockReader)world, pos, TileCelestialGateway.class, true);
            if (gateway != null && gateway.isLocked()) {
                ItemUtils.dropItemNaturally(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), new ItemStack((IItemProvider)ItemsAS.AQUAMARINE));
            }
        }
        super.func_196243_a(state, world, pos, newState, moving);
    }

    public BlockState func_196271_a(BlockState state, Direction placedAgainst, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        TileCelestialGateway gateway = MiscUtils.getTileAt((IBlockReader)world, pos, TileCelestialGateway.class, true);
        if (gateway != null && gateway.isLocked()) {
            return true;
        }
        return BlockCelestialGateway.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
    }

    @Nullable
    public static DyeColor getColor(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof BlockItem) || !(((BlockItem)stack.func_77973_b()).func_179223_d() instanceof BlockCelestialGateway)) {
            return null;
        }
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        if (!tag.func_74764_b("color")) {
            return null;
        }
        return NBTHelper.readEnum(tag, "color", DyeColor.class);
    }

    public static void setColor(ItemStack stack, @Nullable DyeColor color) {
        if (!(stack.func_77973_b() instanceof BlockItem) || !(((BlockItem)stack.func_77973_b()).func_179223_d() instanceof BlockCelestialGateway)) {
            return;
        }
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        if (color == null) {
            tag.func_82580_o("color");
        } else {
            NBTHelper.writeEnum(tag, "color", color);
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileCelestialGateway();
    }
}

