/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.source.orbital.FXOrbitalArmara;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.ConstellationEffectEntityCollect;
import hellfirepvp.astralsorcery.common.data.config.registry.TechnicalEntityRegistry;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperSpawnDeny;
import hellfirepvp.astralsorcery.common.item.crystal.ItemAttunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.EffectsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.block.WorldBlockPos;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import hellfirepvp.astralsorcery.common.util.tick.TickTokenMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class CEffectArmara
extends ConstellationEffectEntityCollect<LivingEntity> {
    public static ArmaraConfig CONFIG = new ArmaraConfig();
    private int rememberedTimeout = 0;

    public CEffectArmara(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.armara, LivingEntity.class, e -> e.func_70089_S() && TechnicalEntityRegistry.INSTANCE.canAffect((Entity)e));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        if (pedestal.getTicksExisted() % 20 == 0) {
            EffectHelper.spawnSource(new FXOrbitalArmara(new Vector3((Vec3i)pos).add(0.5, 0.5, 0.5)).setOrbitRadius(0.8 + (double)rand.nextFloat() * 0.7).setOrbitAxis(Vector3.RotAxis.Y_AXIS).setTicksPerRotation(20 + rand.nextInt(20)));
        }
        ConstellationEffectProperties prop = this.createProperties(pedestal.getMirrorCount());
        ItemStack socket = pedestal.getCurrentCrystal();
        if (!socket.func_190926_b() && socket.func_77973_b() instanceof ItemAttunedCrystalBase) {
            IMinorConstellation trait = ((ItemAttunedCrystalBase)socket.func_77973_b()).getTraitConstellation(socket);
            prop.modify(trait);
            if (prop.isCorrupted()) {
                return;
            }
        }
        PlayerEntity owner = pedestal.getOwner();
        List projectiles = world.func_217357_a(Entity.class, BOX.func_186670_a(pos).func_186662_g(prop.getSize()));
        if (!projectiles.isEmpty()) {
            for (Entity e : projectiles) {
                if (!e.func_70089_S() || !TechnicalEntityRegistry.INSTANCE.canAffect(e)) continue;
                if (e instanceof IProjectile) {
                    double xRatio = (double)pos.func_177958_n() + 0.5 - e.func_226277_ct_();
                    double zRatio = (double)pos.func_177952_p() + 0.5 - e.func_226281_cx_();
                    float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
                    Vector3 motion = new Vector3(e.func_213322_ci());
                    motion.multiply(new Vector3(0.5, 1.0, 0.5));
                    motion.subtract(xRatio / (double)f * 0.4, 0.0, zRatio / (double)f * 0.4);
                    ((IProjectile)e).func_70186_c(motion.getX(), motion.getY(), motion.getZ(), 1.5f, 0.0f);
                    continue;
                }
                if (!(e instanceof MobEntity)) continue;
                ((LivingEntity)e).func_70653_a((Entity)(owner == null ? e : owner), 0.4f, (double)pos.func_177958_n() + 0.5 - e.func_226277_ct_(), (double)pos.func_177952_p() + 0.5 - e.func_226281_cx_());
            }
        }
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        List projectiles;
        int toAdd = 2 + rand.nextInt(5);
        WorldBlockPos at = WorldBlockPos.wrapServer(world, pos);
        TickTokenMap.SimpleTickToken token = (TickTokenMap.SimpleTickToken)EventHelperSpawnDeny.spawnDenyRegions.get((Object)at);
        if (token != null) {
            int next = token.getRemainingTimeout() + toAdd;
            if (next > 400) {
                next = 400;
            }
            token.setTimeout(next);
            this.rememberedTimeout = next;
        } else {
            this.rememberedTimeout = Math.min(400, this.rememberedTimeout + toAdd);
            EventHelperSpawnDeny.spawnDenyRegions.put(at, new TickTokenMap.SimpleTickToken<Double>(properties.getSize(), this.rememberedTimeout));
        }
        PlayerEntity owner = this.getOwningPlayerInWorld(world, pos);
        if (!properties.isCorrupted() && !(projectiles = world.func_217357_a(Entity.class, BOX.func_186670_a(pos).func_186662_g(properties.getSize()))).isEmpty()) {
            for (Entity e : projectiles) {
                if (!e.func_70089_S() || !TechnicalEntityRegistry.INSTANCE.canAffect(e)) continue;
                if (e instanceof IProjectile) {
                    double xRatio = (double)pos.func_177958_n() + 0.5 - e.func_226277_ct_();
                    double zRatio = (double)pos.func_177952_p() + 0.5 - e.func_226281_cx_();
                    float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
                    Vector3 motion = new Vector3(e.func_213322_ci());
                    motion.multiply(new Vector3(0.5, 1.0, 0.5));
                    motion.subtract(xRatio / (double)f * 0.4, 0.0, zRatio / (double)f * 0.4);
                    ((IProjectile)e).func_70186_c(motion.getX(), motion.getY(), motion.getZ(), 1.5f, 0.0f);
                    continue;
                }
                if (!(e instanceof MobEntity)) continue;
                ((LivingEntity)e).func_70653_a((Entity)(owner == null ? e : owner), 0.4f, (double)pos.func_177958_n() + 0.5 - e.func_226277_ct_(), (double)pos.func_177952_p() + 0.5 - e.func_226281_cx_());
            }
        }
        int potionAmplifier = (Integer)CEffectArmara.CONFIG.potionAmplifier.get();
        List entities = this.collectEntities(world, pos, properties);
        for (LivingEntity entity : entities) {
            if (!entity.func_70089_S() || !(entity instanceof MobEntity) && !(entity instanceof PlayerEntity)) continue;
            if (properties.isCorrupted()) {
                if (entity instanceof PlayerEntity) continue;
                EntityUtils.applyPotionEffectAtHalf(entity, new EffectInstance(Effects.field_76424_c, 100, potionAmplifier + 4));
                EntityUtils.applyPotionEffectAtHalf(entity, new EffectInstance(Effects.field_76428_l, 100, potionAmplifier + 4));
                EntityUtils.applyPotionEffectAtHalf(entity, new EffectInstance(Effects.field_76429_m, 100, potionAmplifier + 2));
                EntityUtils.applyPotionEffectAtHalf(entity, new EffectInstance(Effects.field_76420_g, 100, potionAmplifier + 4));
                EntityUtils.applyPotionEffectAtHalf(entity, new EffectInstance(Effects.field_76427_o, 100, potionAmplifier + 4));
                EntityUtils.applyPotionEffectAtHalf(entity, new EffectInstance(Effects.field_76422_e, 100, potionAmplifier + 4));
                EntityUtils.applyPotionEffectAtHalf(entity, new EffectInstance((Effect)EffectsAS.EFFECT_DROP_MODIFIER, 100, 5));
                continue;
            }
            EntityUtils.applyPotionEffectAtHalf(entity, new EffectInstance(Effects.field_76429_m, 30, Math.min(potionAmplifier, 3), true, true));
            if (!(entity instanceof PlayerEntity)) continue;
            EntityUtils.applyPotionEffectAtHalf(entity, new EffectInstance(Effects.field_76444_x, 30, potionAmplifier, true, false));
        }
        return true;
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    @Override
    public void readFromNBT(CompoundNBT cmp) {
        super.readFromNBT(cmp);
        this.rememberedTimeout = cmp.func_74762_e("rememberedTimeout");
    }

    @Override
    public void writeToNBT(CompoundNBT cmp) {
        super.writeToNBT(cmp);
        cmp.func_74768_a("rememberedTimeout", this.rememberedTimeout);
    }

    private static class ArmaraConfig
    extends ConstellationEffect.Config {
        private final int defaultPotionAmplifier = 1;
        public ForgeConfigSpec.IntValue potionAmplifier;

        public ArmaraConfig() {
            super("armara", 16.0, 2.0);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.potionAmplifier = cfgBuilder.comment("Set the amplifier for the potion effects this ritual provides.").translation(this.translationKey("potionAmplifier")).defineInRange("potionAmplifier", this.defaultPotionAmplifier, 0, 10);
        }
    }
}

