/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.AnimalHelper;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.ConstellationEffectEntityCollect;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.EffectsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class CEffectBootes
extends ConstellationEffectEntityCollect<LivingEntity> {
    public static BootesConfig CONFIG = new BootesConfig();

    public CEffectBootes(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.bootes, LivingEntity.class, entity -> AnimalHelper.getHandler(entity) != null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        if (rand.nextInt(3) == 0) {
            ConstellationEffectProperties prop = this.createProperties(pedestal.getMirrorCount());
            Vector3 playAt = new Vector3((Vec3i)pos).add(0.5, 0.5, 0.5).add((double)rand.nextFloat() * (prop.getSize() / 2.0) * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * (prop.getSize() / 4.0), (double)rand.nextFloat() * (prop.getSize() / 2.0) * (double)(rand.nextBoolean() ? 1 : -1));
            Vector3 motion = Vector3.random().multiply(0.015);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(playAt)).setMotion(motion)).color(VFXColorFunction.constant(ColorsAS.CONSTELLATION_BOOTES))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.5f)).setMaxAge(30 + rand.nextInt(20));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(playAt)).setMotion(motion.clone().negate())).color(VFXColorFunction.constant(ColorsAS.CONSTELLATION_BOOTES))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.5f)).setMaxAge(30 + rand.nextInt(20));
        }
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        boolean didEffect = false;
        List entities = this.collectEntities(world, pos, properties);
        Collections.shuffle(entities);
        entities.subList(0, Math.min(25, entities.size()));
        for (LivingEntity entity : entities) {
            AnimalHelper.HerdableAnimal animal = AnimalHelper.getHandler(entity);
            if (animal == null) continue;
            if (properties.isCorrupted()) {
                entity.field_70172_ad = 0;
                entity.func_195064_c(new EffectInstance((Effect)EffectsAS.EFFECT_DROP_MODIFIER, 1000, 5));
                if (!DamageUtil.attackEntityFrom((Entity)entity, CommonProxy.DAMAGE_SOURCE_STELLAR, 5000.0f)) continue;
                didEffect = true;
                continue;
            }
            if (!((double)rand.nextFloat() < (Double)CEffectBootes.CONFIG.herdingChance.get())) continue;
            didEffect = MiscUtils.executeWithChunk((IWorldReader)world, entity.func_180425_c(), Boolean.valueOf(didEffect), didEffectFlag -> {
                List<ItemStack> rawDrops = EntityUtils.generateLoot(entity, rand, CommonProxy.DAMAGE_SOURCE_STELLAR, null);
                ArrayList drops = new ArrayList();
                rawDrops.forEach(drop -> {
                    for (int i = 0; i < drop.func_190916_E(); ++i) {
                        drops.add(ItemUtils.copyStackWithSize(drop, 1));
                    }
                });
                for (ItemStack drop2 : drops) {
                    if (!((double)rand.nextFloat() < (Double)CEffectBootes.CONFIG.herdingLootChance.get()) || ItemUtils.dropItemNaturally(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), drop2) == null) continue;
                    didEffectFlag = true;
                }
                return didEffectFlag;
            }, false);
            this.sendConstellationPing((IWorld)world, Vector3.atEntityCorner((Entity)entity));
        }
        return didEffect;
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    private static class BootesConfig
    extends ConstellationEffect.Config {
        private final double defaultHerdingChance = 0.05;
        private final double defaultHerdingLootChance = 0.01;
        public ForgeConfigSpec.DoubleValue herdingChance;
        public ForgeConfigSpec.DoubleValue herdingLootChance;

        public BootesConfig() {
            super("bootes", 12.0, 4.0);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.herdingChance = cfgBuilder.comment("Set the chance that an registered animal will be considered for generating loot if it is close to the ritual.").translation(this.translationKey("herdingChance")).defineInRange("herdingChance", this.defaultHerdingChance, 0.0, 1.0);
            this.herdingLootChance = cfgBuilder.comment("Set the chance that a drop that has been found on the entity's loot table is actually dropped.").translation(this.translationKey("herdingLootChance")).defineInRange("herdingLootChance", this.defaultHerdingLootChance, 0.0, 1.0);
        }
    }
}

